/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.proxy.handlers.http.ntlm;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.apache.mina.proxy.handlers.http.ntlm.NTLMConstants;
import org.apache.mina.proxy.handlers.http.ntlm.NTLMResponses;
import org.apache.mina.proxy.utils.ByteUtilities;

public class NTLMUtilities
implements NTLMConstants {
    public static final byte[] writeSecurityBuffer(short s, int n) {
        byte[] byArray = new byte[8];
        NTLMUtilities.writeSecurityBuffer(s, s, n, byArray, 0);
        return byArray;
    }

    public static final void writeSecurityBuffer(short s, short s2, int n, byte[] byArray, int n2) {
        ByteUtilities.writeShort(s, byArray, n2);
        ByteUtilities.writeShort(s2, byArray, n2 + 2);
        ByteUtilities.writeInt(n, byArray, n2 + 4);
    }

    public static final byte[] createType1Message(String string, String string2, Integer n, byte[] byArray) {
        byte[] byArray2 = null;
        if (byArray != null && byArray.length != 8) {
            throw new IllegalArgumentException("osVersion parameter should be a 8 byte wide array");
        }
        if (string == null || string2 == null) {
            throw new IllegalArgumentException("workStation and domain must be non null");
        }
        int n2 = n != null ? n | 0x2000 | 0x1000 : 12291;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            byteArrayOutputStream.write(NTLM_SIGNATURE);
            byteArrayOutputStream.write(ByteUtilities.writeInt(1));
            byteArrayOutputStream.write(ByteUtilities.writeInt(n2));
            byte[] byArray3 = ByteUtilities.getOEMStringAsByteArray(string2);
            byte[] byArray4 = ByteUtilities.getOEMStringAsByteArray(string);
            int n3 = byArray != null ? 40 : 32;
            byteArrayOutputStream.write(NTLMUtilities.writeSecurityBuffer((short)byArray3.length, n3 + byArray4.length));
            byteArrayOutputStream.write(NTLMUtilities.writeSecurityBuffer((short)byArray4.length, n3));
            if (byArray != null) {
                byteArrayOutputStream.write(byArray);
            }
            byteArrayOutputStream.write(byArray4);
            byteArrayOutputStream.write(byArray3);
            byArray2 = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream.close();
        }
        catch (IOException iOException) {
            return null;
        }
        return byArray2;
    }

    public static final int writeSecurityBufferAndUpdatePointer(ByteArrayOutputStream byteArrayOutputStream, short s, int n) throws IOException {
        byteArrayOutputStream.write(NTLMUtilities.writeSecurityBuffer(s, n));
        return n + s;
    }

    public static final byte[] extractChallengeFromType2Message(byte[] byArray) {
        byte[] byArray2 = new byte[8];
        System.arraycopy(byArray, 24, byArray2, 0, 8);
        return byArray2;
    }

    public static final int extractFlagsFromType2Message(byte[] byArray) {
        byte[] byArray2 = new byte[4];
        System.arraycopy(byArray, 20, byArray2, 0, 4);
        ByteUtilities.changeWordEndianess(byArray2, 0, 4);
        return ByteUtilities.makeIntFromByte4(byArray2);
    }

    public static final byte[] createType3Message(String string, String string2, byte[] byArray, String string3, String string4, Integer n, byte[] byArray2) {
        byte[] byArray3 = null;
        if (byArray == null || byArray.length != 8) {
            throw new IllegalArgumentException("challenge[] should be a 8 byte wide array");
        }
        if (byArray2 != null && byArray2.length != 8) {
            throw new IllegalArgumentException("osVersion should be a 8 byte wide array");
        }
        int n2 = n != null ? n : 12291;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            byteArrayOutputStream.write(NTLM_SIGNATURE);
            byteArrayOutputStream.write(ByteUtilities.writeInt(3));
            byte[] byArray4 = NTLMResponses.getLMResponse(string2, byArray);
            byte[] byArray5 = NTLMResponses.getNTLMResponse(string2, byArray);
            boolean bl = ByteUtilities.isFlagSet(n2, 1);
            byte[] byArray6 = ByteUtilities.encodeString(string3, bl);
            byte[] byArray7 = ByteUtilities.encodeString(string, bl);
            byte[] byArray8 = ByteUtilities.encodeString(string4, bl);
            int n3 = byArray2 != null ? 72 : 64;
            int n4 = n3 + byArray6.length + byArray7.length + byArray8.length;
            n4 = NTLMUtilities.writeSecurityBufferAndUpdatePointer(byteArrayOutputStream, (short)byArray4.length, n4);
            NTLMUtilities.writeSecurityBufferAndUpdatePointer(byteArrayOutputStream, (short)byArray5.length, n4);
            n3 = NTLMUtilities.writeSecurityBufferAndUpdatePointer(byteArrayOutputStream, (short)byArray6.length, n3);
            n3 = NTLMUtilities.writeSecurityBufferAndUpdatePointer(byteArrayOutputStream, (short)byArray7.length, n3);
            NTLMUtilities.writeSecurityBufferAndUpdatePointer(byteArrayOutputStream, (short)byArray8.length, n3);
            byteArrayOutputStream.write(new byte[]{0, 0, 0, 0, -102, 0, 0, 0});
            byteArrayOutputStream.write(ByteUtilities.writeInt(n2));
            if (byArray2 != null) {
                byteArrayOutputStream.write(byArray2);
            }
            byteArrayOutputStream.write(byArray6);
            byteArrayOutputStream.write(byArray7);
            byteArrayOutputStream.write(byArray8);
            byteArrayOutputStream.write(byArray4);
            byteArrayOutputStream.write(byArray5);
            byArray3 = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        return byArray3;
    }
}

