/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.plugins.webclient;

import cz.vity.freerapid.plugins.webclient.ConnectionSettings;
import cz.vity.freerapid.plugins.webclient.DefaultFileStreamRecognizer;
import cz.vity.freerapid.plugins.webclient.HostConfigurationWithStickyProtocol;
import cz.vity.freerapid.plugins.webclient.ProxySocketFactory;
import cz.vity.freerapid.plugins.webclient.interfaces.FileStreamRecognizer;
import cz.vity.freerapid.plugins.webclient.interfaces.HttpDownloadClient;
import cz.vity.freerapid.plugins.webclient.interfaces.HttpFile;
import cz.vity.freerapid.plugins.webclient.utils.HttpUtils;
import cz.vity.freerapid.plugins.webclient.utils.PlugUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.SimpleHttpConnectionManager;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.util.URIUtil;

public class DownloadClient
implements HttpDownloadClient {
    private static final Logger logger = Logger.getLogger(DownloadClient.class.getName());
    protected HttpClient client = new HttpClient();
    protected Protocol protocol = null;
    protected String referer = "";
    protected String asString;
    private int redirect;
    private volatile ConnectionSettings settings;
    public static final String START_POSITION = "startPosition";
    public static final String SUPPOSE_TO_DOWNLOAD = "supposeToDownload";
    private int timeout = 120000;
    private FileStreamRecognizer streamRecognizer;

    @Override
    public void initClient(ConnectionSettings settings) {
        if (settings == null) {
            throw new NullPointerException("Internet connection settings cannot be null");
        }
        this.settings = settings;
        HttpClientParams clientParams = this.client.getParams();
        clientParams.setCookiePolicy("compatibility");
        clientParams.setParameter("http.protocol.single-cookie-header", true);
        clientParams.setSoTimeout(this.timeout);
        clientParams.setConnectionManagerTimeout(this.timeout);
        clientParams.setHttpElementCharset("UTF-8");
        this.client.setHttpConnectionManager(new SimpleHttpConnectionManager(true));
        this.client.getHttpConnectionManager().getParams().setConnectionTimeout(this.timeout);
        HttpState initialState = new HttpState();
        HostConfiguration configuration = new HostConfiguration();
        if (settings.getProxyType() == Proxy.Type.SOCKS) {
            configuration = new HostConfigurationWithStickyProtocol();
            Proxy proxy = new Proxy(settings.getProxyType(), new InetSocketAddress(settings.getProxyURL(), settings.getProxyPort()));
            this.protocol = new Protocol("http", new ProxySocketFactory(proxy), 80);
        } else if (settings.getProxyType() == Proxy.Type.HTTP) {
            configuration.setProxy(settings.getProxyURL(), settings.getProxyPort());
            if (settings.getUserName() != null) {
                initialState.setProxyCredentials(AuthScope.ANY, new NTCredentials(settings.getUserName(), settings.getPassword(), "", ""));
            }
        }
        this.client.setHostConfiguration(configuration);
        clientParams.setBooleanParameter("http.protocol.allow-circular-redirects", true);
        this.client.setState(initialState);
    }

    private boolean hasAuthentification() {
        if (this.settings == null) {
            throw new IllegalStateException("Client not initialized");
        }
        return this.settings.isProxySet() && this.settings.getUserName() != null;
    }

    protected void setDefaultsForMethod(HttpMethod method) {
        if (this.client.getParams().isParameterSet("userAgent")) {
            method.setRequestHeader("User-Agent", this.client.getParams().getParameter("userAgent").toString());
        } else {
            method.setRequestHeader("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:27.0) Gecko/20100101 Firefox/27.0");
        }
        method.setRequestHeader("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8");
        method.setRequestHeader("Accept-Language", "en-US,en;q=0.5");
        method.setRequestHeader("Accept-Encoding", "gzip");
        if (this.referer != null && !this.referer.isEmpty()) {
            method.setRequestHeader("Referer", this.referer);
        }
        method.setFollowRedirects(false);
    }

    @Override
    public PostMethod getPostMethod(String uri) {
        PostMethod m;
        try {
            m = new PostMethod(uri);
        }
        catch (IllegalArgumentException e) {
            logger.warning("Invalid URI detected for PostMethod: " + uri + " Trying to reencode ");
            try {
                m = new PostMethod(URIUtil.encodePathQuery(uri));
            }
            catch (URIException e1) {
                throw e;
            }
        }
        this.setDefaultsForMethod(m);
        m.setDoAuthentication(this.hasAuthentification());
        return m;
    }

    @Override
    public String getReferer() {
        return this.referer;
    }

    @Override
    public InputStream makeFinalRequestForFile(HttpMethod method, HttpFile file, boolean allowRedirect) throws IOException {
        if (method == null) {
            throw new NullPointerException("HttpMethod cannot be null");
        }
        if (file == null) {
            throw new NullPointerException("File cannot be null");
        }
        file.getProperties().remove(START_POSITION);
        file.getProperties().remove(SUPPOSE_TO_DOWNLOAD);
        return this.makeRequestFile(method, file, 0, allowRedirect);
    }

    private InputStream makeRequestFile(HttpMethod method, HttpFile file, int deep, boolean allowRedirect) throws IOException {
        this.asString = "";
        if (allowRedirect && method instanceof GetMethod) {
            method.setFollowRedirects(true);
        }
        this.addRangeHeader(file, method);
        this.toString(method);
        this.processHttpMethod(method);
        int statuscode = method.getStatusCode();
        if (statuscode == 500 || statuscode == 403) {
            logger.severe("Status code je 500");
            this.updateAsString(method);
            return null;
        }
        if (statuscode >= 500) {
            logger.severe("Status code > 500: " + statuscode);
            this.updateAsString(method);
            return null;
        }
        boolean isRedirect = this.isRedirect(statuscode);
        if (statuscode != 200 && statuscode != 206 && !isRedirect) {
            logger.warning("Loading file failed - invalid HTTP return status code: " + statuscode);
            this.updateAsString(method);
            return null;
        }
        if (allowRedirect && isRedirect && deep < 2) {
            Header header = method.getResponseHeader("location");
            if (header != null) {
                String newuri = header.getValue();
                if (newuri == null || "".equals(newuri)) {
                    newuri = "/";
                }
                if (!newuri.contains("http://")) {
                    newuri = "http://" + method.getURI().getHost() + newuri;
                }
                logger.info("Redirect target: " + newuri);
                if (this.client.getParams().getBooleanParameter("useRefererWhenRedirect", false)) {
                    this.setReferer(newuri);
                }
                method.releaseConnection();
                GetMethod redirect = this.getGetMethod(newuri);
                InputStream inputStream = this.makeRequestFile(redirect, file, deep + 1, allowRedirect);
                logger.info("Redirect: " + redirect.getStatusLine().toString());
                return inputStream;
            }
            logger.warning("Invalid redirect");
            return null;
        }
        return this.processFileForDownload(method, file);
    }

    private void addRangeHeader(HttpFile file, HttpMethod method) {
        long l;
        if (!file.isResumeSupported()) {
            logger.info("Resume is not supported");
            return;
        }
        File storeFile = file.getStoreFile();
        if (storeFile != null && storeFile.exists() && (l = Math.max(file.getRealDownload(), 0L)) != 0L) {
            String range = "bytes=" + l + "-";
            method.addRequestHeader("Range", range);
            logger.info("Setting range to " + range);
        }
    }

    private InputStream processFileForDownload(HttpMethod method, HttpFile file) throws IOException {
        String fn;
        Header contentType = this.getContentType(method);
        boolean isStream = this.checkContentTypeStream(method, true);
        String fileName = HttpUtils.getFileName(method);
        if (fileName != null && !fileName.isEmpty()) {
            if (!this.client.getParams().isParameterTrue("dontUseHeaderFilename")) {
                file.setFileName(fileName);
            }
            if (this.client.getParams().isParameterTrue("noContentTypeInHeader")) {
                isStream = true;
            }
        } else if (method.getResponseHeader("Content-Range") == null) {
            logger.warning("No Content-Disposition (filename) header in file");
        }
        if ((fn = file.getFileName()) == null) {
            throw new IOException("No defined file name");
        }
        file.setFileName(HttpUtils.replaceInvalidCharsForFileSystem(PlugUtils.unescapeHtml(fn), "_"));
        if (!isStream && contentType != null && this.client.getParams().isParameterSet("considerAsStream")) {
            String ct = this.client.getParams().getParameter("considerAsStream").toString();
            if (contentType.getValue().equalsIgnoreCase(ct)) {
                logger.info("considering as stream '" + ct + "'");
                isStream = true;
            }
        }
        if (isStream && this.client.getParams().isParameterFalse("noContentLengthAvailable")) {
            Header contentLength = method.getResponseHeader("Content-Length");
            if (contentLength == null) {
                isStream = false;
                logger.warning("No Content-Length in header");
            } else {
                Long contentResponseLength = Long.valueOf(contentLength.getValue());
                Header contentRange = method.getResponseHeader("Content-Range");
                if (contentRange != null) {
                    String val = contentRange.getValue();
                    Matcher matcher = Pattern.compile("(\\d+)-\\d+/(\\d+)").matcher(val);
                    if (matcher.find()) {
                        file.getProperties().put(START_POSITION, Long.valueOf(matcher.group(1)));
                        file.setFileSize(Long.valueOf(matcher.group(2)));
                    } else {
                        file.getProperties().put(START_POSITION, 0L);
                    }
                    file.setResumeSupported(true);
                } else {
                    if (!this.client.getParams().isParameterTrue("ignoreAcceptRanges")) {
                        Header acceptRangesHeader = method.getResponseHeader("Accept-Ranges");
                        if (file.isResumeSupported()) {
                            file.setResumeSupported(acceptRangesHeader != null && "bytes".equals(acceptRangesHeader.getValue()));
                        }
                    }
                    file.setFileSize(contentResponseLength);
                }
                file.getProperties().put(SUPPOSE_TO_DOWNLOAD, contentResponseLength);
            }
        }
        if (isStream) {
            return method.getResponseBodyAsStream();
        }
        logger.warning("Loading file failed");
        this.updateAsString(method);
        return null;
    }

    private Header getContentType(HttpMethod method) {
        return method.getResponseHeader("Content-Type");
    }

    private boolean checkContentTypeStream(HttpMethod method, boolean showWarnings) {
        FileStreamRecognizer recognizer = (FileStreamRecognizer)this.client.getParams().getParameter("fileStreamRecognizer");
        if (recognizer == null) {
            if (this.streamRecognizer == null) {
                this.streamRecognizer = new DefaultFileStreamRecognizer();
            }
            recognizer = this.streamRecognizer;
        }
        return recognizer.isStream(method, showWarnings);
    }

    @Override
    public InputStream makeRequestForFile(HttpMethod method) throws IOException {
        this.toString(method);
        this.processHttpMethod(method);
        int statuscode = method.getStatusCode();
        if (statuscode == 200) {
            this.checkContentTypeStream(method, true);
            Header hce = method.getResponseHeader("Content-Encoding");
            if (null != hce && !hce.getValue().isEmpty()) {
                if ("gzip".equalsIgnoreCase(hce.getValue())) {
                    logger.info("Found GZIP stream");
                    return new GZIPInputStream(method.getResponseBodyAsStream());
                }
                logger.warning("Unknown Content-Encoding: " + hce.getValue());
            }
            return method.getResponseBodyAsStream();
        }
        logger.warning("Loading file failed");
        this.updateAsString(method);
        return null;
    }

    private void processHttpMethod(HttpMethod method) throws IOException {
        if (this.protocol != null) {
            this.client.getHostConfiguration().setHost(method.getURI().getHost(), 80, this.protocol);
        }
        this.client.executeMethod(method);
    }

    @Override
    public int makeRequest(HttpMethod method, boolean allowRedirect) throws IOException {
        this.asString = "";
        if (allowRedirect && method instanceof GetMethod) {
            method.setFollowRedirects(true);
        }
        this.processHttpMethod(method);
        int statuscode = method.getStatusCode();
        boolean isRedirect = this.isRedirect(statuscode);
        if (!isRedirect) {
            this.redirect = 0;
        }
        if (statuscode == 500 || statuscode == 403) {
            logger.severe("Status code je 500");
        } else if (statuscode >= 500) {
            logger.severe("Status code > 500: " + statuscode);
        }
        if (allowRedirect && isRedirect && this.redirect != 1) {
            this.redirect = 1;
            Header header = method.getResponseHeader("location");
            if (header != null) {
                String newuri = header.getValue();
                if (newuri == null || "".equals(newuri)) {
                    newuri = "/";
                }
                if (!newuri.matches("(?i)https?://.+")) {
                    if (!newuri.startsWith("/")) {
                        newuri = "/" + newuri;
                    }
                    newuri = method.getURI().getScheme() + "://" + method.getURI().getHost() + newuri;
                }
                logger.info("Redirect target: " + newuri);
                if (this.client.getParams().getBooleanParameter("useRefererWhenRedirect", false)) {
                    this.setReferer(newuri);
                }
                GetMethod redirect = this.getGetMethod(newuri);
                int i = this.makeRequest(redirect, allowRedirect);
                logger.info("Redirect: " + redirect.getStatusLine().toString());
                return i;
            }
            logger.warning("Invalid redirect");
        } else {
            this.redirect = 0;
            if (!this.checkContentTypeStream(method, false)) {
                this.updateAsString(method);
            } else {
                this.asString = "Text content type expected, but binary stream was found";
                logger.warning(this.asString);
            }
        }
        method.releaseConnection();
        return statuscode;
    }

    private void updateAsString(HttpMethod method) throws IOException {
        Header hce = method.getResponseHeader("Content-Encoding");
        this.asString = "";
        if (null != hce && !hce.getValue().isEmpty()) {
            if ("gzip".equalsIgnoreCase(hce.getValue())) {
                logger.info("Extracting GZIP");
                this.asString = this.inflate(method.getResponseBodyAsStream());
            } else {
                logger.warning("Unknown Content-Encoding: " + hce.getValue());
            }
        } else {
            InputStream bodyAsStream = method.getResponseBodyAsStream();
            this.asString = bodyAsStream == null ? "" : this.streamToString(bodyAsStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String streamToString(InputStream in) {
        BufferedReader in2 = null;
        StringWriter sw = new StringWriter();
        char[] buffer = new char[4000];
        try {
            int x;
            in2 = new BufferedReader(new InputStreamReader(in, this.getContentPageCharset()));
            while ((x = in2.read(buffer)) != -1) {
                sw.write(buffer, 0, x);
            }
            String string = sw.toString();
            return string;
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Error during reading content of page", e);
        }
        finally {
            if (in2 != null) {
                try {
                    in2.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return "";
    }

    protected boolean isRedirect(int statuscode) {
        return statuscode == 302 || statuscode == 301 || statuscode == 303 || statuscode == 307;
    }

    @Override
    public GetMethod getGetMethod(String uri) {
        GetMethod m;
        try {
            m = new GetMethod(uri);
        }
        catch (IllegalArgumentException e) {
            logger.warning("Invalid URI detected for GetMethod: " + uri + " Trying to reencode ");
            try {
                m = new GetMethod(URIUtil.encodePathQuery(uri));
            }
            catch (URIException e1) {
                throw e;
            }
        }
        this.setDefaultsForMethod(m);
        m.setDoAuthentication(this.hasAuthentification());
        return m;
    }

    protected void toString(HttpMethod method) {
        logger.info("===============HTTP METHOD===============");
        String path = method.getPath();
        logger.info("path = " + path);
        Header[] headers = method.getRequestHeaders();
        StringBuilder builder = new StringBuilder();
        for (Header header : headers) {
            if (header == null) continue;
            builder.append(header.toString());
        }
        logger.info("header = \n" + builder.toString().trim());
        if (method instanceof PostMethod) {
            NameValuePair[] parameters;
            PostMethod postMethod = (PostMethod)method;
            builder = new StringBuilder();
            for (NameValuePair pair : parameters = postMethod.getParameters()) {
                builder.append(pair.getName()).append("=").append(pair.getValue()).append("\n");
            }
        }
        logger.info("post parameters: \n" + builder.toString().trim());
        logger.info("query string = " + method.getQueryString());
        logger.info("=========================================");
    }

    protected String inflate(InputStream in) throws IOException {
        int b;
        byte[] buffer = new byte[4000];
        GZIPInputStream gin = new GZIPInputStream(in);
        StringBuilder builder = new StringBuilder();
        while ((b = gin.read(buffer)) != -1) {
            builder.append(new String(buffer, 0, b, this.getContentPageCharset()));
        }
        return builder.toString();
    }

    protected String getContentPageCharset() {
        Object o = this.getHTTPClient().getParams().getParameter("pageCharset");
        if (o == null) {
            return "UTF-8";
        }
        return o.toString();
    }

    @Override
    public void setReferer(String referer) {
        if (referer == null) {
            throw new NullPointerException("Referer cannot be null");
        }
        logger.info("Setting referer to " + referer);
        this.referer = referer;
    }

    @Override
    public ConnectionSettings getSettings() {
        return this.settings;
    }

    @Override
    public HttpClient getHTTPClient() {
        return this.client;
    }

    @Override
    public String getContentAsString() {
        return this.asString;
    }

    @Override
    public void setConnectionTimeOut(int timeout) {
        this.timeout = timeout;
    }
}

