/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.plugimpl;

import cz.vity.freerapid.core.AppPrefs;
import cz.vity.freerapid.core.QuietMode;
import cz.vity.freerapid.core.tasks.DownloadTask;
import cz.vity.freerapid.gui.dialogs.AccountDialog;
import cz.vity.freerapid.plugins.webclient.hoster.PremiumAccount;
import cz.vity.freerapid.plugins.webclient.interfaces.DialogSupport;
import cz.vity.freerapid.swing.Swinger;
import cz.vity.freerapid.utilities.Hq2x;
import cz.vity.freerapid.utilities.LogUtils;
import cz.vity.freerapid.utilities.Sound;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.image.BufferedImage;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.jdesktop.appframework.swingx.SingleXFrameApplication;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.SingleFrameApplication;

public class StandardDialogSupportImpl
implements DialogSupport {
    private static final Logger logger = Logger.getLogger(StandardDialogSupportImpl.class.getName());
    private volatile String captchaResult;
    private volatile String passwordResult;
    private static final Object captchaLock = new Object();
    private final ApplicationContext context;

    public StandardDialogSupportImpl(ApplicationContext context) {
        this.context = context;
    }

    @Override
    public PremiumAccount showAccountDialog(final PremiumAccount account, final String title) throws Exception {
        final PremiumAccount[] result = new PremiumAccount[]{null};
        if (!EventQueue.isDispatchThread()) {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    StandardDialogSupportImpl.this.getAccount(title, account, result);
                }
            });
        } else {
            this.getAccount(title, account, result);
        }
        return result[0];
    }

    @Override
    public boolean showOKCancelDialog(final Component container, final String title) throws Exception {
        final boolean[] dialogResult = new boolean[]{false};
        Runnable runable = new Runnable(){

            @Override
            public void run() {
                dialogResult[0] = Swinger.showInputDialog(title, container, true) == 0;
            }
        };
        if (!EventQueue.isDispatchThread()) {
            SwingUtilities.invokeAndWait(runable);
        } else {
            runable.run();
        }
        return dialogResult[0];
    }

    @Override
    public void showOKDialog(final Component container, final String title) throws Exception {
        if (!EventQueue.isDispatchThread()) {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    Swinger.showInputDialog(title, container, false);
                }
            });
        } else {
            Swinger.showInputDialog(title, container, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String askForCaptcha(final BufferedImage image) throws Exception {
        Object object = captchaLock;
        synchronized (object) {
            this.captchaResult = "";
            if (!EventQueue.isDispatchThread()) {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        StandardDialogSupportImpl.this.askCaptcha(image);
                    }
                });
            } else {
                this.askCaptcha(image);
            }
            return this.captchaResult;
        }
    }

    private void askCaptcha(BufferedImage image) {
        if (AppPrefs.getProperty("zoomCaptchaImage", false)) {
            image = Hq2x.zoom(image);
        }
        boolean bringToFront = false;
        if (!QuietMode.getInstance().isActive() || !QuietMode.getInstance().isCaptchaDisabled()) {
            Swinger.bringToFront(((SingleFrameApplication)this.context.getApplication()).getMainFrame(), true);
            bringToFront = true;
        } else {
            QuietMode.getInstance().playUserInteractionRequiredSound();
        }
        if (AppPrefs.getProperty("blindMode", false)) {
            Sound.playSound(this.context.getResourceMap().getString("captchaWav", new Object[0]));
        }
        JFrame parentComponent = AppPrefs.getProperty("popWindowWithoutMainFrame", false) ? null : (bringToFront ? null : ((SingleFrameApplication)this.context.getApplication()).getMainFrame());
        this.captchaResult = (String)JOptionPane.showInputDialog(parentComponent, this.context.getResourceMap(DownloadTask.class).getString("InsertWhatYouSee", new Object[0]), this.context.getResourceMap(DownloadTask.class).getString("InsertCaptcha", new Object[0]), -1, new ImageIcon(image), null, null);
    }

    private void getAccount(String title, PremiumAccount account, PremiumAccount[] result) {
        SingleXFrameApplication app = (SingleXFrameApplication)this.context.getApplication();
        AccountDialog dialog = new AccountDialog((Frame)app.getMainFrame(), title, account);
        try {
            app.prepareDialog(dialog, true);
        }
        catch (IllegalStateException e) {
            LogUtils.processException(logger, e);
        }
        result[0] = dialog.getAccount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String askForPassword(final String name) throws Exception {
        Object object = captchaLock;
        synchronized (object) {
            this.passwordResult = "";
            if (!EventQueue.isDispatchThread()) {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        StandardDialogSupportImpl.this.askPassword(name);
                    }
                });
            } else {
                this.askPassword(name);
            }
            return this.passwordResult;
        }
    }

    private void askPassword(String name) {
        boolean bringToFront = false;
        if (!QuietMode.getInstance().isActive() || !QuietMode.getInstance().isDialogsDisabled()) {
            bringToFront = true;
            JFrame mainFrame = ((SingleFrameApplication)this.context.getApplication()).getMainFrame();
            Swinger.bringToFront(mainFrame, true);
        } else {
            QuietMode.getInstance().playUserInteractionRequiredSound();
        }
        JFrame parentComponent = bringToFront ? null : ((SingleFrameApplication)this.context.getApplication()).getMainFrame();
        this.passwordResult = (String)JOptionPane.showInputDialog(parentComponent, this.context.getResourceMap(DownloadTask.class).getString("FileIsPasswordProtected", name), this.context.getResourceMap(DownloadTask.class).getString("InsertPassword", new Object[0]), -1, null, null, null);
    }
}

