/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.managers;

import com.jgoodies.binding.adapter.Bindings;
import com.jgoodies.binding.beans.PropertyConnector;
import com.jgoodies.binding.value.ValueModel;
import cz.vity.freerapid.core.AppPrefs;
import cz.vity.freerapid.gui.SearchField;
import cz.vity.freerapid.gui.dialogs.CompoundUndoManager;
import cz.vity.freerapid.gui.managers.ManagerDirector;
import cz.vity.freerapid.gui.managers.search.SearchItem;
import cz.vity.freerapid.swing.SwingUtils;
import cz.vity.freerapid.swing.Swinger;
import cz.vity.freerapid.swing.ToolbarSeparator;
import cz.vity.freerapid.swing.binding.BindUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.jdesktop.application.ApplicationContext;

public class ToolbarManager
implements PropertyChangeListener {
    private final JPanel toolbarPanel = new JPanel(new BorderLayout());
    private static final Dimension buttonDimensionWithText = new Dimension(74, 68);
    private static final Dimension buttonWithoutWithoutTextDimension = new Dimension(40, 38);
    private JToolBar toolbar = new JToolBar("mainToolbar");
    private float fontSize;
    private SearchField searchField;
    private final ManagerDirector directorManager;
    private final ApplicationContext context;

    public ToolbarManager(ManagerDirector directorManager, ApplicationContext context) {
        this.directorManager = directorManager;
        this.context = context;
        this.toolbarPanel.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 0));
        Action action = context.getActionMap().get("showToolbar");
        ValueModel valueModel = BindUtils.getPrefsValueModel("showToolbar", true);
        action.putValue("SwingSelectedKey", valueModel.getValue());
        PropertyConnector.connectAndUpdate(valueModel, this.toolbarPanel, "visible");
        this.fontSize = context.getResourceMap().getFloat("buttonBarFontSize").floatValue();
        this.createToolbar();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        if ("done".equals(propertyName) || "started".equals(propertyName)) {
            // empty if block
        }
    }

    private void createToolbar() {
        this.toolbarPanel.add(this.toolbar);
        this.toolbar.setFocusable(false);
        this.toolbar.setFloatable(false);
        Border border = this.toolbar.getBorder();
        Border innerBorder = BorderFactory.createEmptyBorder(2, 2, 1, 2);
        if (border != null) {
            this.toolbar.setBorder(BorderFactory.createCompoundBorder(border, innerBorder));
        } else {
            this.toolbar.setBorder(innerBorder);
        }
        this.toolbar.add(this.getButton(Swinger.getAction("addNewLinksAction")));
        this.toolbar.add(new ToolbarSeparator());
        this.toolbar.add(this.getButton(Swinger.getAction("resumeAction")));
        this.toolbar.add(this.getButton(Swinger.getAction("pauseAction")));
        this.toolbar.add(this.getButton(Swinger.getAction("cancelAction")));
        this.toolbar.add(new ToolbarSeparator());
        this.toolbar.add(this.getButton(Swinger.getAction("topAction")));
        this.toolbar.add(this.getButton(Swinger.getAction("upAction")));
        this.toolbar.add(this.getButton(Swinger.getAction("downAction")));
        this.toolbar.add(this.getButton(Swinger.getAction("bottomAction")));
        this.toolbar.add(Box.createGlue());
        this.searchField = new SearchField(this.context);
        new CompoundUndoManager(this.searchField);
        this.searchField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                SearchItem searchItem;
                if (e.getKeyCode() == 10 && (searchItem = ToolbarManager.this.searchField.getSelectedItem()) != null) {
                    ToolbarManager.this.directorManager.getSearchManager().openBrowser(searchItem, ToolbarManager.this.searchField.getText());
                    Swinger.inputFocus(ToolbarManager.this.searchField);
                }
            }
        });
        ValueModel valueModel = BindUtils.getPrefsValueModel("searchFieldText", "");
        Bindings.bind(this.searchField, valueModel, false);
        valueModel = BindUtils.getPrefsValueModel("searchFieldVisible", true);
        PropertyConnector.connectAndUpdate(valueModel, this.searchField, "visible");
        this.searchField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (ToolbarManager.this.directorManager.getSearchManager().checkForDirChange()) {
                    ToolbarManager.this.directorManager.getSearchManager().loadSearchData();
                    ToolbarManager.this.searchField.setSearchItemList(ToolbarManager.this.directorManager.getSearchManager().getSearchItems());
                }
            }
        });
        this.toolbar.add(this.searchField);
        this.toolbar.add(Box.createHorizontalStrut(3));
        AbstractButton btn = this.getButton(Swinger.getAction("paypalSupportAction"));
        btn.setCursor(Cursor.getPredefinedCursor(12));
        btn.putClientProperty("noChange", true);
        btn.setOpaque(false);
        btn.setRolloverEnabled(false);
        btn.setBackground(null);
        btn.setText(null);
        btn.setBorder(new EmptyBorder(0, 0, 0, 0));
        if (AppPrefs.getProperty("showPaypal", true)) {
            this.toolbar.add(btn);
        }
        this.toolbar.add(Box.createHorizontalStrut(18));
        this.updateButtons(AppPrefs.getProperty("showButtonTextToolbar", true));
        this.checkPreferences();
    }

    void initManager() {
        this.searchField.setSearchItemList(this.directorManager.getSearchManager().getSearchItems());
    }

    private void checkPreferences() {
        AppPrefs.getPreferences().addPreferenceChangeListener(new PreferenceChangeListener(){

            @Override
            public void preferenceChange(final PreferenceChangeEvent evt) {
                if ("showButtonTextToolbar".equals(evt.getKey())) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ToolbarManager.this.updateButtons(Boolean.valueOf(evt.getNewValue()));
                        }
                    });
                }
            }
        });
    }

    private void updateButtons(boolean withText) {
        Dimension dimension;
        Component[] components = this.toolbar.getComponents();
        if (withText) {
            this.toolbarPanel.setPreferredSize(new Dimension(400, 54));
            dimension = buttonDimensionWithText;
        } else {
            dimension = buttonWithoutWithoutTextDimension;
            this.toolbarPanel.setPreferredSize(new Dimension(400, 47));
        }
        for (Component c : components) {
            AbstractButton button;
            if (!(c instanceof AbstractButton) || (button = (AbstractButton)c).getClientProperty("noChange") != null) continue;
            button.setMinimumSize(dimension);
            button.setPreferredSize(dimension);
            button.setMaximumSize(dimension);
            if (withText) {
                this.updateButtonText(button, button.getAction());
                continue;
            }
            button.setText(null);
        }
        this.toolbar.getParent().validate();
        this.toolbar.getParent().repaint();
    }

    private void setToolBarVisible(boolean visible) {
        this.toolbarPanel.setVisible(visible);
    }

    public JComponent getComponent() {
        return this.toolbarPanel;
    }

    private AbstractButton getToggleButton(Action action) {
        JToggleButton button = new JToggleButton(action);
        return this.setButtonProperties(button, action);
    }

    private AbstractButton getButton(Action action) {
        JButton button = new JButton(action);
        return this.setButtonProperties(button, action);
    }

    private AbstractButton setButtonProperties(AbstractButton button, Action action) {
        button.setRolloverEnabled(true);
        button.setIconTextGap(0);
        Object desc = action.getValue("ShortDescription");
        Font font = button.getFont();
        button.setFont(font.deriveFont(this.fontSize));
        button.setVerticalTextPosition(3);
        button.setHorizontalTextPosition(0);
        button.setText(null);
        Object keystroke = action.getValue("AcceleratorKey");
        if (desc != null && keystroke != null) {
            button.setToolTipText(desc.toString() + " (" + SwingUtils.keyStroke2String((KeyStroke)keystroke) + ")");
        }
        button.setMnemonic(0);
        button.setFocusable(false);
        return button;
    }

    private void updateButtonText(AbstractButton button, Action action) {
        String s = (String)action.getValue("Name");
        if (s != null && s.endsWith("...")) {
            s = s.substring(0, s.length() - 3);
        }
        button.setText(s);
    }

    public SearchField getSearchField() {
        return this.searchField;
    }
}

