/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.managers;

import cz.vity.freerapid.gui.managers.ManagerDirector;
import cz.vity.freerapid.gui.managers.search.OpenSearchDescription;
import cz.vity.freerapid.gui.managers.search.OpenSearchDescriptionBinding;
import cz.vity.freerapid.gui.managers.search.SearchItem;
import cz.vity.freerapid.utilities.Browser;
import cz.vity.freerapid.utilities.LogUtils;
import cz.vity.freerapid.utilities.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Logger;
import jlibs.xml.sax.binding.BindingHandler;
import org.jdesktop.application.ApplicationContext;
import org.xml.sax.InputSource;

public class SearchManager {
    private static final String SEARCH_DIR = "search";
    private static final Logger logger = Logger.getLogger(SearchManager.class.getName());
    private List<SearchItem> searchItems = Collections.emptyList();
    private int filesCount = -1;
    private long lastModified = -1L;

    public SearchManager(ApplicationContext context, ManagerDirector managerDirector) {
    }

    public void loadSearchData() {
        File dir = this.getDirectory();
        if (dir == null) {
            this.searchItems = Collections.emptyList();
            return;
        }
        Object[] files = this.getFiles(dir);
        this.searchItems = new ArrayList<SearchItem>(files.length);
        this.filesCount = -1;
        this.lastModified = -1L;
        this.filesCount = files.length;
        Arrays.sort(files);
        BindingHandler handler = new BindingHandler(OpenSearchDescriptionBinding.class);
        handler.setPopulateNamespaces(true);
        for (Object f : files) {
            long lm = ((File)f).lastModified();
            if (lm > this.lastModified) {
                this.lastModified = lm;
            }
            logger.info("Parsing search.xml file " + ((File)f).getAbsolutePath());
            try {
                OpenSearchDescription searchDescription = (OpenSearchDescription)handler.parse(new InputSource(new FileInputStream((File)f)));
                if (searchDescription == null) {
                    logger.warning("Ignoring file - this is not OpenSearchDescription file! " + ((File)f).getAbsolutePath());
                    continue;
                }
                if (searchDescription.getUrlTemplate() == null || searchDescription.getShortName() == null) {
                    logger.warning("Invalid search description " + searchDescription);
                    continue;
                }
                this.searchItems.add(new SearchItem(((File)f).getName(), searchDescription));
            }
            catch (Exception e) {
                LogUtils.processException(logger, e);
            }
        }
    }

    private File getDirectory() {
        File dir = new File(Utils.getAppPath(), SEARCH_DIR);
        if (!dir.exists() || !dir.isDirectory()) {
            return null;
        }
        return dir;
    }

    public boolean checkForDirChange() {
        File directory = this.getDirectory();
        if (directory == null) {
            return false;
        }
        File[] files = this.getFiles(directory);
        if (files.length != this.filesCount) {
            return true;
        }
        for (File file : files) {
            if (file.lastModified() <= this.lastModified) continue;
            return true;
        }
        return false;
    }

    private File[] getFiles(File dir) {
        return dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase(Locale.ENGLISH).endsWith(".xml");
            }
        });
    }

    public void openBrowser(SearchItem item, String searchText) {
        OpenSearchDescription sd = item.getSearchDescription();
        String enc = sd.getInputEncoding();
        String uri = sd.getUrlTemplate();
        uri = this.replaceSearchedText(searchText, enc, uri);
        Map<String, String> parameters = sd.getUrlParams();
        if (!parameters.isEmpty()) {
            StringBuilder builder = new StringBuilder(uri);
            if (!uri.contains("?")) {
                builder.append('?');
            }
            for (Map.Entry<String, String> entry : parameters.entrySet()) {
                char lastChar = builder.charAt(builder.length() - 1);
                if (lastChar != '&' && lastChar != '?' && lastChar != '/') {
                    builder.append('&');
                }
                builder.append(entry.getKey()).append('=');
                if (entry.getValue().contains("{searchTerms}")) {
                    builder.append(this.replaceSearchedText(searchText, enc, entry.getValue()));
                    continue;
                }
                builder.append(entry.getValue());
            }
            uri = builder.toString();
        }
        try {
            URL url = new URI(uri).toURL();
            logger.info("Opening URL " + url.toExternalForm());
            Browser.openBrowser(url);
        }
        catch (MalformedURLException e) {
            logger.severe("Error generating URL:" + uri + " " + e.getMessage());
        }
        catch (URISyntaxException e) {
            logger.severe("Error generating URL:" + uri + " " + e.getMessage());
        }
        catch (IllegalArgumentException e) {
            logger.severe("Error generating URL:" + uri + " " + e.getMessage());
        }
    }

    private String replaceSearchedText(String searchText, String enc, String value) {
        return value.replace("{searchTerms}", this.encode(searchText, enc));
    }

    private String encode(String value, String encoding) {
        String encoded;
        try {
            encoded = URLEncoder.encode(value, encoding);
        }
        catch (UnsupportedEncodingException e) {
            return value;
        }
        return encoded;
    }

    public List<SearchItem> getSearchItems() {
        return this.searchItems;
    }
}

