/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui;

import cz.vity.freerapid.core.AppPrefs;
import cz.vity.freerapid.gui.managers.search.SearchItem;
import cz.vity.freerapid.swing.ComponentFactory;
import cz.vity.freerapid.swing.Swinger;
import cz.vity.freerapid.utilities.Browser;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.geom.Rectangle2D;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.border.Border;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.jdesktop.application.Action;
import org.jdesktop.application.ApplicationContext;

public class SearchField
extends JTextField
implements FocusListener,
PopupMenuListener {
    private String emptyString;
    private static final int PREFFERED_HEIGHT = 25;
    private JToggleButton btn;
    private SearchItem selectedItem = null;
    private List<SearchItem> searchItemList = Collections.emptyList();

    public SearchField(ApplicationContext context) {
        this.addFocusListener(this);
        this.emptyString = "";
        this.btn = new JToggleButton("");
        this.btn.setSize(19, 19);
        this.btn.setMinimumSize(this.btn.getSize());
        this.btn.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.btn.setFocusable(false);
        this.add(this.btn);
        this.btn.setCursor(Cursor.getDefaultCursor());
        Border border = this.getBorder();
        this.setBorder(BorderFactory.createCompoundBorder(border, BorderFactory.createEmptyBorder(0, 25, 0, 0)));
        this.btn.setLocation(border == null ? 2 : border.getBorderInsets((Component)this).left, this.getInsets().top);
        Dimension preferredSize = new Dimension(AppPrefs.getProperty("searchFieldWidth", 165), 25);
        this.setPreferredSize(preferredSize);
        this.setMaximumSize(preferredSize);
        this.setMinimumSize(preferredSize);
        this.addFocusListener(new ComponentFactory.SelectAllOnFocusListener());
        this.btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchField.this.doPopmenu();
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (SearchField.this.hasFocus() && e.isAltDown() && e.getKeyCode() == 40) {
                    SearchField.this.doPopmenu();
                    e.consume();
                }
            }
        });
        Swinger.initActions(this, context);
    }

    @Action
    public void manageSearchEngines() {
        Swinger.showInformationDialog(Swinger.getResourceMap().getString("howToManageSearchEngines", new Object[0]));
        Browser.openBrowser("https://addons.mozilla.org/en-US/firefox/search-engines/");
    }

    private void doPopmenu() {
        if (this.searchItemList == null) {
            return;
        }
        JPopupMenu popmenu = new JPopupMenu();
        for (SearchItem item : this.searchItemList) {
            popmenu.add(new SelectSearchEngineAction(item));
        }
        if (!this.searchItemList.isEmpty()) {
            popmenu.addSeparator();
        }
        popmenu.add(Swinger.getAction("manageSearchEngines"));
        popmenu.show(this.getParent(), this.getLocation().x, this.getLocation().y + this.getHeight());
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (!this.hasFocus() && this.getText().isEmpty() && this.emptyString != null && !this.emptyString.isEmpty()) {
            g.setColor(Color.GRAY);
            Font f = this.getFont().deriveFont(2);
            g.setFont(f);
            Rectangle2D bounds = g.getFontMetrics(f).getStringBounds(this.emptyString, g);
            g.drawString(this.emptyString, this.getInsets().left, this.getHeight() + this.getInsets().top - this.getInsets().bottom - (int)(bounds.getHeight() / 2.0));
        }
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e) {
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        this.btn.getModel().setSelected(false);
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.repaint();
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.focusGained(e);
    }

    public String getEmptyString() {
        return this.emptyString;
    }

    public void setEmptyString(String emptyString) {
        this.emptyString = emptyString;
        this.repaint();
    }

    public List<SearchItem> getSearchItemList() {
        return this.searchItemList;
    }

    public void setSearchItemList(List<SearchItem> searchItemList) {
        if (searchItemList == null) {
            throw new IllegalArgumentException("Search list cannot be null");
        }
        String idDefault = AppPrefs.getProperty("searchFieldSearchEngine", "google");
        this.searchItemList = searchItemList;
        for (SearchItem item : searchItemList) {
            if (!item.getId().equals(idDefault)) continue;
            this.setSelectedItem(item);
            return;
        }
        if (searchItemList.isEmpty()) {
            this.setSelectedItem(null);
        } else {
            this.setSelectedItem(searchItemList.get(0));
        }
    }

    public SearchItem getSelectedItem() {
        return this.selectedItem;
    }

    public void setSelectedItem(SearchItem selectedItem) {
        String id;
        this.selectedItem = selectedItem;
        if (selectedItem == null) {
            this.setEmptyString("");
            this.btn.setIcon(null);
            id = null;
        } else {
            id = selectedItem.getId();
            this.btn.setIcon(selectedItem.getImage());
            this.setEmptyString(selectedItem.getSearchDescription().getShortName());
        }
        AppPrefs.storeProperty("searchFieldSearchEngine", id);
    }

    private class SelectSearchEngineAction
    extends AbstractAction {
        private final SearchItem item;

        private SelectSearchEngineAction(SearchItem item) {
            super(item.getSearchDescription().getShortName(), item.getImage());
            this.putValue("ShortDescription", item.getSearchDescription().getShortName());
            this.putValue("LongDescription", item.getSearchDescription().getDescription());
            this.item = item;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SearchField.this.setSelectedItem(this.item);
            Swinger.inputFocus(SearchField.this);
        }
    }
}

