/*
 * Decompiled with CFR 0.152.
 */
package jlibs.core.util.i18n;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import jlibs.core.lang.model.ModelUtil;

public class I18N {
    public static final String BASENAME = "Bundle";

    public static <T> T getImplementation(Class<T> bundleClass) {
        try {
            return (T)ModelUtil.findClass(bundleClass, "${package}._Bundle").getDeclaredField("INSTANCE").get(null);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static ResourceBundle bundle(Class clazz) {
        return ResourceBundle.getBundle(clazz.getPackage().getName().replace('.', '/') + "/" + BASENAME);
    }

    public static String getValue(Class clazz, String key, Object ... args) {
        try {
            return MessageFormat.format(I18N.bundle(clazz).getString(key), args);
        }
        catch (MissingResourceException ex) {
            return null;
        }
    }

    public static String getHint(Class clazz, String member, String hint, Object ... args) {
        return I18N.getValue(clazz, clazz.getSimpleName() + '.' + member + '.' + hint, args);
    }

    public static String getHint(Class clazz, String hint, Object ... args) {
        return I18N.getValue(clazz, clazz.getSimpleName() + '.' + hint, args);
    }
}

