/*
 * Decompiled with CFR 0.152.
 */
package davmail;

import davmail.AbstractConnection;
import davmail.BundleMessage;
import davmail.Settings;
import davmail.exception.DavMailException;
import davmail.ui.tray.DavGatewayTray;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.HashSet;
import javax.net.ServerSocketFactory;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

public abstract class AbstractServer
extends Thread {
    protected boolean nosslFlag;
    private final int port;
    private ServerSocket serverSocket;

    public abstract String getProtocolName();

    public int getPort() {
        return this.port;
    }

    public AbstractServer(String name, int port, int defaultPort) {
        super(name);
        this.setDaemon(true);
        this.port = port == 0 ? defaultPort : port;
    }

    public void bind() throws DavMailException {
        ServerSocketFactory serverSocketFactory;
        String bindAddress = Settings.getProperty("davmail.bindAddress");
        String keystoreFile = Settings.getProperty("davmail.ssl.keystoreFile");
        if (keystoreFile == null || keystoreFile.length() == 0 || this.nosslFlag) {
            serverSocketFactory = ServerSocketFactory.getDefault();
        } else {
            try {
                SSLContext sslContext = SSLContext.getInstance("TLS");
                sslContext.init(this.getKeyManagers(), this.getTrustManagers(), null);
                serverSocketFactory = sslContext.getServerSocketFactory();
            }
            catch (IOException | GeneralSecurityException ex) {
                throw new DavMailException("LOG_EXCEPTION_CREATING_SSL_SERVER_SOCKET", this.getProtocolName(), this.port, ex.getMessage() == null ? ex.toString() : ex.getMessage());
            }
        }
        try {
            this.serverSocket = bindAddress == null || bindAddress.length() == 0 ? serverSocketFactory.createServerSocket(this.port) : serverSocketFactory.createServerSocket(this.port, 0, Inet4Address.getByName(bindAddress));
            if (this.serverSocket instanceof SSLServerSocket) {
                HashSet<String> protocols = new HashSet<String>();
                for (String protocol : ((SSLServerSocket)this.serverSocket).getEnabledProtocols()) {
                    if (protocol.startsWith("SSL")) continue;
                    protocols.add(protocol);
                }
                ((SSLServerSocket)this.serverSocket).setEnabledProtocols(protocols.toArray(new String[0]));
                ((SSLServerSocket)this.serverSocket).setNeedClientAuth(Settings.getBooleanProperty("davmail.ssl.needClientAuth", false));
            }
        }
        catch (IOException e) {
            throw new DavMailException("LOG_SOCKET_BIND_FAILED", this.getProtocolName(), this.port);
        }
    }

    protected TrustManager[] getTrustManagers() throws CertificateException, NoSuchAlgorithmException, IOException, KeyStoreException {
        String truststoreFile = Settings.getProperty("davmail.ssl.truststoreFile");
        if (truststoreFile == null || truststoreFile.length() == 0) {
            return null;
        }
        try (FileInputStream trustStoreInputStream = new FileInputStream(truststoreFile);){
            KeyStore trustStore = KeyStore.getInstance(Settings.getProperty("davmail.ssl.truststoreType"));
            trustStore.load(trustStoreInputStream, Settings.getCharArrayProperty("davmail.ssl.truststorePass"));
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            tmf.init(trustStore);
            TrustManager[] trustManagerArray = tmf.getTrustManagers();
            return trustManagerArray;
        }
    }

    protected KeyManager[] getKeyManagers() throws CertificateException, NoSuchAlgorithmException, IOException, KeyStoreException, UnrecoverableKeyException {
        String keystoreFile = Settings.getProperty("davmail.ssl.keystoreFile");
        if (keystoreFile == null || keystoreFile.length() == 0) {
            return null;
        }
        try (FileInputStream keyStoreInputStream = new FileInputStream(keystoreFile);){
            KeyStore keystore = KeyStore.getInstance(Settings.getProperty("davmail.ssl.keystoreType"));
            keystore.load(keyStoreInputStream, Settings.getCharArrayProperty("davmail.ssl.keystorePass"));
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(keystore, Settings.getCharArrayProperty("davmail.ssl.keyPass"));
            KeyManager[] keyManagerArray = kmf.getKeyManagers();
            return keyManagerArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        AbstractConnection connection = null;
        Socket clientSocket = null;
        try {
            while (!this.serverSocket.isClosed()) {
                clientSocket = this.serverSocket.accept();
                clientSocket.setSoTimeout(Settings.getIntProperty("davmail.clientSoTimeout", 300) * 1000);
                DavGatewayTray.debug(new BundleMessage("LOG_CONNECTION_FROM", clientSocket.getInetAddress(), this.port));
                if (Settings.getBooleanProperty("davmail.allowRemote") || clientSocket.getInetAddress().isLoopbackAddress() || clientSocket.getInetAddress().equals(InetAddress.getByAddress(new byte[]{-2, -128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1}))) {
                    connection = this.createConnectionHandler(clientSocket);
                    connection.start();
                    continue;
                }
                DavGatewayTray.warn(new BundleMessage("LOG_EXTERNAL_CONNECTION_REFUSED", new Object[0]));
            }
        }
        catch (IOException e) {
            if (!this.serverSocket.isClosed()) {
                DavGatewayTray.warn(new BundleMessage("LOG_EXCEPTION_LISTENING_FOR_CONNECTIONS", new Object[0]), e);
            }
        }
        finally {
            try {
                if (clientSocket != null) {
                    clientSocket.close();
                }
            }
            catch (IOException e) {
                DavGatewayTray.warn(new BundleMessage("LOG_EXCEPTION_CLOSING_CLIENT_SOCKET", new Object[0]), e);
            }
            if (connection != null) {
                connection.close();
            }
        }
    }

    public abstract AbstractConnection createConnectionHandler(Socket var1);

    public void close() {
        try {
            if (this.serverSocket != null) {
                this.serverSocket.close();
            }
        }
        catch (IOException e) {
            DavGatewayTray.warn(new BundleMessage("LOG_EXCEPTION_CLOSING_SERVER_SOCKET", new Object[0]), e);
        }
    }
}

