/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.remotecontrol;

import java.io.IOException;
import java.lang.reflect.Field;
import org.openstreetmap.josm.tools.Utils;
import sun.security.x509.DNSName;

public final class DNSNameFix
extends DNSName {
    private static final String alpha = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
    private static final String digitsAndHyphen = "0123456789-";
    private static final String alphaDigitsAndHyphen = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-";

    public DNSNameFix(String string) throws IOException {
        super("fake");
        if (string == null || string.isEmpty()) {
            throw new IOException("DNS name must not be null");
        }
        if (string.indexOf(32) != -1) {
            throw new IOException("DNS names or NameConstraints with blank components are not permitted");
        }
        if (string.charAt(0) == '.' || string.charAt(string.length() - 1) == '.') {
            throw new IOException("DNS names or NameConstraints may not begin or end with a .");
        }
        int n = 0;
        while (n < string.length()) {
            int n2 = string.indexOf(46, n);
            if (n2 < 0) {
                n2 = string.length();
            }
            if (n2 - n < 1) {
                throw new IOException("DNSName SubjectAltNames with empty components are not permitted");
            }
            for (int i = n + 1; i < n2; ++i) {
                char c = string.charAt(i);
                if (alphaDigitsAndHyphen.indexOf(c) >= 0) continue;
                throw new IOException("DNSName components must consist of letters, digits, and hyphens");
            }
            n = n2 + 1;
        }
        try {
            Field field = this.getClass().getSuperclass().getDeclaredField("name");
            Utils.setObjectsAccessible(field);
            field.set(this, string);
        }
        catch (ReflectiveOperationException | SecurityException exception) {
            throw new IOException(exception);
        }
    }
}

