/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.v8debug.ui.vars.tooltip;

import java.util.concurrent.CancellationException;
import javax.swing.SwingUtilities;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.editor.ext.ToolTipSupport;
import org.netbeans.lib.v8debug.vars.V8Value;
import org.netbeans.modules.javascript.v8debug.V8Debugger;
import org.netbeans.modules.javascript.v8debug.frames.CallFrame;
import org.netbeans.modules.javascript.v8debug.ui.vars.models.VariablesModel;
import org.netbeans.modules.javascript.v8debug.vars.EvaluationError;
import org.netbeans.modules.javascript.v8debug.vars.V8Evaluator;
import org.netbeans.modules.javascript.v8debug.vars.Variable;
import org.netbeans.modules.javascript2.debug.ui.tooltip.AbstractJSToolTipAnnotation;
import org.openide.util.Pair;

public class ToolTipAnnotation
extends AbstractJSToolTipAnnotation {
    protected void handleToolTipClose(DebuggerEngine engine, ToolTipSupport tts) {
        V8Debugger debugger = (V8Debugger)engine.lookupFirst(null, V8Debugger.class);
        if (debugger == null) {
            return;
        }
        ToolTipAnnotation.handleToolTipClose(debugger, tts);
    }

    public static void handleToolTipClose(V8Debugger debugger, final ToolTipSupport tts) {
        V8Debugger.Listener listener = new V8Debugger.Listener(){

            public void notifySuspended(boolean suspended) {
                if (!suspended) {
                    this.doClose();
                }
            }

            public void notifyCurrentFrame(CallFrame cf) {
                this.doClose();
            }

            public void notifyFinished() {
                this.doClose();
            }

            private void doClose() {
                SwingUtilities.invokeLater(() -> tts.setToolTipVisible(false));
            }
        };
        debugger.addListener(listener);
        tts.addPropertyChangeListener(pl -> {
            if ("status".equals(pl.getPropertyName()) && !tts.isToolTipVisible()) {
                debugger.removeListener(listener);
            }
        });
    }

    protected Pair<String, Object> evaluate(String expression, DebuggerEngine engine) throws CancellationException {
        String toolTipText;
        Variable var = null;
        V8Debugger debugger = (V8Debugger)engine.lookupFirst(null, V8Debugger.class);
        if (debugger == null || !debugger.isSuspended()) {
            return null;
        }
        try {
            V8Value value = V8Evaluator.evaluate((V8Debugger)debugger, (String)expression);
            if (value == null) {
                throw new CancellationException();
            }
            toolTipText = expression + " = " + V8Evaluator.getStringValue((V8Value)value);
            if (VariablesModel.hasChildren(value)) {
                var = new Variable(Variable.Kind.LOCAL, expression, value.getHandle(), value, false);
            }
        }
        catch (EvaluationError ex) {
            toolTipText = expression + " = >" + ex.getMessage() + "<";
        }
        return Pair.of((Object)toolTipText, var);
    }
}

