/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.editor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.csl.api.CodeCompletionContext;
import org.netbeans.modules.csl.api.CodeCompletionHandler;
import org.netbeans.modules.csl.api.CodeCompletionResult;
import org.netbeans.modules.csl.api.CompletionProposal;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.HtmlFormatter;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.csl.api.ParameterInfo;
import org.netbeans.modules.csl.spi.DefaultCompletionResult;
import org.netbeans.modules.csl.spi.support.CancelSupport;
import org.netbeans.modules.javascript2.lexer.api.JsTokenId;
import org.netbeans.modules.javascript2.lexer.api.LexUtilities;
import org.netbeans.modules.javascript2.model.api.JsObject;
import org.netbeans.modules.javascript2.model.api.Model;
import org.netbeans.modules.javascript2.types.spi.ParserResult;
import org.netbeans.modules.parsing.api.Snapshot;

public class JsonCodeCompletion
implements CodeCompletionHandler {
    private static final Logger LOGGER = Logger.getLogger(JsonCodeCompletion.class.getName());
    private boolean caseSensitive;

    public CodeCompletionResult complete(CodeCompletionContext context) {
        CancelSupport cancelSupport = CancelSupport.getDefault();
        if (cancelSupport.isCancelled()) {
            return CodeCompletionResult.NONE;
        }
        long start = System.currentTimeMillis();
        Document doc = context.getParserResult().getSnapshot().getSource().getDocument(false);
        if (doc == null) {
            return CodeCompletionResult.NONE;
        }
        ParserResult info = (ParserResult)context.getParserResult();
        TokenHierarchy th = info.getSnapshot().getTokenHierarchy();
        if (th == null) {
            return CodeCompletionResult.NONE;
        }
        TokenSequence ts = th.tokenSequence(JsTokenId.jsonLanguage());
        if (ts == null) {
            return CodeCompletionResult.NONE;
        }
        String pref = context.getPrefix();
        int caretOffset = context.getParserResult().getSnapshot().getEmbeddedOffset(context.getCaretOffset());
        final int anchor = caretOffset - pref.length();
        ts.move(anchor);
        if (!ts.moveNext() && !ts.movePrevious()) {
            return CodeCompletionResult.NONE;
        }
        Model model = Model.getModel((org.netbeans.modules.csl.spi.ParserResult)info, (boolean)false);
        if (model == null) {
            return CodeCompletionResult.NONE;
        }
        this.caseSensitive = context.isCaseSensitive();
        ArrayList<1> resultList = new ArrayList<1>();
        Token token = ts.token();
        final JsTokenId tokenId = (JsTokenId)token.id();
        ts.movePrevious();
        Token prevToken = LexUtilities.findPreviousNonWsNonComment((TokenSequence)ts);
        JsTokenId prevTokenId = (JsTokenId)prevToken.id();
        if (!(prevTokenId != JsTokenId.BRACKET_LEFT_CURLY && prevTokenId != JsTokenId.OPERATOR_COMMA || tokenId != JsTokenId.STRING && tokenId != JsTokenId.WHITESPACE)) {
            HashSet<String> keys = new HashSet<String>();
            this.findKeys(model.getGlobalObject(), caretOffset, keys);
            for (final String key : keys) {
                if (!this.startsWith(key, pref)) continue;
                resultList.add(new CompletionProposal(){

                    public int getAnchorOffset() {
                        return anchor;
                    }

                    public ElementHandle getElement() {
                        return null;
                    }

                    public String getName() {
                        return key;
                    }

                    public String getInsertPrefix() {
                        return tokenId == JsTokenId.STRING ? key : '\"' + key + '\"';
                    }

                    public String getSortText() {
                        return key;
                    }

                    public String getLhsHtml(HtmlFormatter formatter) {
                        formatter.appendText(key);
                        return formatter.getText();
                    }

                    public String getRhsHtml(HtmlFormatter formatter) {
                        return null;
                    }

                    public ElementKind getKind() {
                        return ElementKind.PROPERTY;
                    }

                    public ImageIcon getIcon() {
                        return null;
                    }

                    public Set<Modifier> getModifiers() {
                        return Collections.emptySet();
                    }

                    public boolean isSmart() {
                        return false;
                    }

                    public int getSortPrioOverride() {
                        return 1;
                    }

                    public String getCustomInsertTemplate() {
                        return null;
                    }
                });
            }
        }
        long end = System.currentTimeMillis();
        LOGGER.log(Level.FINE, "Counting JSON CC took {0}ms ", end - start);
        if (!resultList.isEmpty()) {
            return new DefaultCompletionResult(resultList, false);
        }
        return CodeCompletionResult.NONE;
    }

    public String document(org.netbeans.modules.csl.spi.ParserResult info, ElementHandle element) {
        return null;
    }

    public ElementHandle resolveLink(String link, ElementHandle originalHandle) {
        return null;
    }

    public String getPrefix(org.netbeans.modules.csl.spi.ParserResult info, int caretOffset, boolean upToOffset) {
        Token token;
        String prefix = "";
        Document doc = info.getSnapshot().getSource().getDocument(false);
        if (doc == null) {
            return null;
        }
        TokenSequence ts = LexUtilities.getTokenSequence((Snapshot)info.getSnapshot(), (int)caretOffset, (Language)JsTokenId.jsonLanguage());
        if (ts == null) {
            return null;
        }
        int offset = info.getSnapshot().getEmbeddedOffset(caretOffset);
        ts.move(offset);
        if (!ts.moveNext() && !ts.movePrevious()) {
            return null;
        }
        if (ts.offset() == offset) {
            ts.movePrevious();
        }
        if ((token = ts.token()) != null && token.id() != JsTokenId.EOL) {
            JsTokenId id = (JsTokenId)token.id();
            if (id == JsTokenId.STRING && offset < ts.offset() + token.length()) {
                prefix = token.text().toString();
                prefix = prefix.substring(1, prefix.length() - 1);
                if (upToOffset) {
                    int prefixIndex = this.getPrefixIndexFromSequence(prefix.substring(0, offset - ts.offset() - 1));
                    prefix = prefix.substring(prefixIndex, offset - ts.offset() - 1);
                }
            }
            if (id == JsTokenId.KEYWORD_FALSE || id == JsTokenId.KEYWORD_TRUE || id == JsTokenId.KEYWORD_NULL) {
                prefix = token.text().toString();
                if (upToOffset && offset - ts.offset() >= 0) {
                    prefix = prefix.substring(0, offset - ts.offset());
                }
            }
            if (id.isError()) {
                prefix = token.text().toString();
                prefix = prefix.substring(0, offset - ts.offset());
            }
        }
        LOGGER.log(Level.FINE, String.format("Prefix for cc: %s", prefix));
        return prefix;
    }

    public CodeCompletionHandler.QueryType getAutoQuery(JTextComponent component, String typedText) {
        return CodeCompletionHandler.QueryType.NONE;
    }

    public String resolveTemplateVariable(String variable, org.netbeans.modules.csl.spi.ParserResult info, int caretOffset, String name, Map parameters) {
        return null;
    }

    public Set<String> getApplicableTemplates(Document doc, int selectionBegin, int selectionEnd) {
        return null;
    }

    public ParameterInfo parameters(org.netbeans.modules.csl.spi.ParserResult info, int caretOffset, CompletionProposal proposal) {
        return ParameterInfo.NONE;
    }

    private int getPrefixIndexFromSequence(String prefix) {
        int spaceIndex = prefix.lastIndexOf(" ") + 1;
        int dotIndex = prefix.lastIndexOf(".") + 1;
        int hashIndex = prefix.lastIndexOf("#") + 1;
        int bracketIndex = prefix.lastIndexOf("[") + 1;
        int columnIndex = prefix.lastIndexOf(":") + 1;
        int parenIndex = prefix.lastIndexOf("(") + 1;
        int slashIndex = prefix.lastIndexOf(47) + 1;
        return Math.max(0, Math.max(hashIndex, Math.max(dotIndex, Math.max(parenIndex, Math.max(columnIndex, Math.max(bracketIndex, Math.max(spaceIndex, slashIndex)))))));
    }

    private boolean startsWith(String theString, String prefix) {
        if (prefix == null || prefix.length() == 0) {
            return true;
        }
        return this.caseSensitive ? theString.startsWith(prefix) : theString.toLowerCase().startsWith(prefix.toLowerCase());
    }

    private boolean findKeys(JsObject object, int offset, Set<String> keys) {
        boolean containsOffset = false;
        for (Map.Entry entry : object.getProperties().entrySet()) {
            containsOffset = this.findKeys((JsObject)entry.getValue(), offset, keys);
            if (((JsObject)entry.getValue()).containsOffset(offset) && !containsOffset) {
                containsOffset = true;
                continue;
            }
            if (((String)entry.getKey()).isEmpty() || ((JsObject)entry.getValue()).isAnonymous()) continue;
            keys.add((String)entry.getKey());
        }
        return containsOffset;
    }
}

