/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.utils.cli.options;

import java.io.File;
import org.netbeans.installer.utils.ResourceUtils;
import org.netbeans.installer.utils.cli.CLIArgumentsList;
import org.netbeans.installer.utils.cli.CLIOptionOneArgument;
import org.netbeans.installer.utils.exceptions.CLIOptionException;
import org.netbeans.installer.utils.helper.ExecutionMode;

public class CreateBundleOption
extends CLIOptionOneArgument {
    public static final String CREATE_BUNDLE_ARG = "--create-bundle";
    private static final String WARNING_BUNDLE_FILE_EXISTS_KEY = "O.warning.bundle.file.exists";
    private static final String WARNING_BAD_CREATE_BUNDLE_ARG_KEY = "O.warning.bad.create.bundle.arg";

    @Override
    public void execute(CLIArgumentsList arguments) throws CLIOptionException {
        File targetFile = new File(arguments.next()).getAbsoluteFile();
        if (targetFile.exists()) {
            throw new CLIOptionException(ResourceUtils.getString(CreateBundleOption.class, WARNING_BUNDLE_FILE_EXISTS_KEY, CREATE_BUNDLE_ARG, targetFile));
        }
        ExecutionMode.setCurrentExecutionMode(ExecutionMode.CREATE_BUNDLE);
        System.setProperty("nbi.create.bundle.path", targetFile.getAbsolutePath());
    }

    @Override
    public String getName() {
        return CREATE_BUNDLE_ARG;
    }

    @Override
    protected String getLackOfArgumentsMessage() {
        return ResourceUtils.getString(CreateBundleOption.class, WARNING_BAD_CREATE_BUNDLE_ARG_KEY, CREATE_BUNDLE_ARG);
    }
}

