/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.debugger;

import java.beans.Customizer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.debugger.ActionsManagerListener;
import org.netbeans.api.debugger.LazyActionsManagerListener;
import org.netbeans.api.debugger.Lookup;
import org.netbeans.debugger.registry.ContextAwareServicePath;
import org.netbeans.spi.debugger.ActionsProvider;
import org.netbeans.spi.debugger.ActionsProviderListener;
import org.openide.util.Cancellable;
import org.openide.util.Mutex;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;

public final class ActionsManager {
    public static final Object ACTION_STEP_OVER = "stepOver";
    public static final Object ACTION_RUN_INTO_METHOD = "runIntoMethod";
    public static final Object ACTION_STEP_INTO = "stepInto";
    public static final Object ACTION_STEP_OUT = "stepOut";
    public static final Object ACTION_STEP_OPERATION = "stepOperation";
    public static final Object ACTION_CONTINUE = "continue";
    public static final Object ACTION_START = "start";
    public static final Object ACTION_KILL = "kill";
    public static final Object ACTION_MAKE_CALLER_CURRENT = "makeCallerCurrent";
    public static final Object ACTION_MAKE_CALLEE_CURRENT = "makeCalleeCurrent";
    public static final Object ACTION_PAUSE = "pause";
    public static final Object ACTION_RUN_TO_CURSOR = "runToCursor";
    public static final Object ACTION_POP_TOPMOST_CALL = "popTopmostCall";
    public static final Object ACTION_FIX = "fix";
    public static final Object ACTION_RESTART = "restart";
    public static final Object ACTION_TOGGLE_BREAKPOINT = "toggleBreakpoint";
    public static final Object ACTION_NEW_WATCH = "newWatch";
    public static final Object ACTION_EVALUATE = "evaluate";
    private static final Logger logger = Logger.getLogger(ActionsManager.class.getName());
    private final Vector<ActionsManagerListener> listener = new Vector();
    private final HashMap<String, List<ActionsManagerListener>> listeners = new HashMap();
    private HashMap<Object, List<ActionsProvider>> actionProviders;
    private final Object actionProvidersLock = new Object();
    private final AtomicBoolean actionProvidersInitialized = new AtomicBoolean(false);
    private MyActionListener actionListener = new MyActionListener();
    private Lookup lookup;
    private boolean doiingDo = false;
    private boolean destroy = false;
    private volatile List<? extends ActionsProvider> aps;
    private volatile PropertyChangeListener providersChangeListener;
    private boolean listerersLoaded = false;
    private List lazyListeners;

    ActionsManager(Lookup lookup) {
        this.lookup = lookup;
        logger.log(Level.FINE, "new ActionsManager({0}) = {1}", new Object[]{lookup, this});
    }

    public final void doAction(Object action) {
        this.doiingDo = true;
        List<ActionsProvider> l = this.getActionProvidersForActionWithInit(action);
        boolean done = false;
        if (l != null) {
            int k = l.size();
            for (int i = 0; i < k; ++i) {
                ActionsProvider ap = l.get(i);
                if (!ap.isEnabled(action)) continue;
                this.fireActionToBeRun(action);
                done = true;
                ap.doAction(action);
            }
        }
        if (done) {
            this.fireActionDone(action);
        }
        this.doiingDo = false;
        if (this.destroy) {
            this.destroyIn();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Task postAction(final Object action) {
        boolean inited;
        this.doiingDo = true;
        Object object = this.actionProvidersLock;
        synchronized (object) {
            inited = this.actionProviders != null;
        }
        if (!inited && Mutex.EVENT.isReadAccess()) {
            return this.postActionWithLazyInit(action);
        }
        List<ActionsProvider> l = this.getActionProvidersForActionWithInit(action);
        boolean posted = false;
        int k = l != null ? l.size() : 0;
        List<ActionsProvider> postedActions = new ArrayList<ActionsProvider>(k);
        final AsynchActionTask task = new AsynchActionTask(postedActions);
        if (l != null) {
            int i;
            for (i = 0; i < k; ++i) {
                ActionsProvider ap = l.get(i);
                if (!ap.isEnabled(action)) continue;
                postedActions.add(ap);
                posted = true;
            }
            if (posted) {
                final int[] count = new int[]{0};
                Runnable notifier = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        int[] nArray = count;
                        synchronized (count) {
                            count[0] = count[0] - 1;
                            if (count[0] == 0) {
                                task.actionDone();
                                ActionsManager.this.fireActionDone(action);
                                ActionsManager.this.doiingDo = false;
                                if (ActionsManager.this.destroy) {
                                    ActionsManager.this.destroyIn();
                                }
                            }
                            // ** MonitorExit[var1_1] (shouldn't be in output)
                            return;
                        }
                    }
                };
                if (postedActions.size() > 1) {
                    postedActions = ActionsManager.selectTheMostSpecific(postedActions);
                }
                count[0] = k = postedActions.size();
                this.fireActionToBeRun(action);
                for (i = 0; i < k; ++i) {
                    postedActions.get(i).postAction(action, notifier);
                }
            }
        }
        if (!posted) {
            this.doiingDo = false;
            if (this.destroy) {
                this.destroyIn();
            }
            task.actionDone();
        }
        return task;
    }

    private Task postActionWithLazyInit(final Object action) {
        final AsynchActionTask task = new AsynchActionTask(Collections.emptyList());
        new RequestProcessor(ActionsManager.class).post(new Runnable(){

            @Override
            public void run() {
                try {
                    ActionsManager.this.doAction(action);
                }
                finally {
                    task.actionDone();
                }
            }
        });
        return task;
    }

    private static List<ActionsProvider> selectTheMostSpecific(List<ActionsProvider> aps) {
        Iterator<ActionsProvider> it = aps.iterator();
        ActionsProvider ap = it.next();
        String path = ActionsManager.getPath(ap);
        if (path == null) {
            return aps;
        }
        int n = aps.size();
        String[] paths = new String[n];
        ActionsProvider[] apArr = new ActionsProvider[n];
        int i = 0;
        paths[i] = path;
        apArr[i] = ap;
        while (it.hasNext()) {
            ap = it.next();
            path = ActionsManager.getPath(ap);
            if (path == null) {
                return aps;
            }
            paths[++i] = path;
            apArr[i] = ap;
        }
        block1: for (i = 0; i < n; ++i) {
            String p1 = paths[i];
            for (int j = 0; j < n; ++j) {
                String p2;
                if (i == j || !p1.startsWith(p2 = paths[j])) continue;
                String[] newPaths = new String[n - 1];
                ActionsProvider[] newApArr = new ActionsProvider[n - 1];
                if (j > 0) {
                    System.arraycopy(paths, 0, newPaths, 0, j);
                    System.arraycopy(apArr, 0, newApArr, 0, j);
                }
                if (j < n - 1) {
                    System.arraycopy(paths, j + 1, newPaths, j, n - 1 - j);
                    System.arraycopy(apArr, j + 1, newApArr, j, n - 1 - j);
                }
                paths = newPaths;
                apArr = newApArr;
                --i;
                --n;
                continue block1;
            }
        }
        if (n < aps.size()) {
            aps = Arrays.asList(apArr);
        }
        return aps;
    }

    private static String getPath(ActionsProvider ap) {
        if (ap instanceof ContextAwareServicePath) {
            String path = ((ContextAwareServicePath)((Object)ap)).getServicePath();
            int i = path.lastIndexOf(47);
            if (i > 0) {
                return path.substring(0, i);
            }
            return "";
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isEnabled(Object action) {
        List<ActionsProvider> l;
        boolean doInit = false;
        Object object = this.actionProvidersLock;
        synchronized (object) {
            if (this.actionProviders == null) {
                this.actionProviders = new HashMap();
                doInit = true;
            }
        }
        if (doInit) {
            if (Mutex.EVENT.isReadAccess()) {
                new RequestProcessor(ActionsManager.class).post(new Runnable(){

                    @Override
                    public void run() {
                        ActionsManager.this.initActionImpls();
                    }
                });
            } else {
                this.initActionImpls();
            }
        }
        if ((l = this.getActionProvidersForAction(action)) != null) {
            int k = l.size();
            for (int i = 0; i < k; ++i) {
                ActionsProvider ap = l.get(i);
                if (!ap.isEnabled(action)) continue;
                return true;
            }
        }
        return false;
    }

    public void destroy() {
        if (!this.doiingDo) {
            this.destroyIn();
        }
        this.destroy = true;
    }

    public void addActionsManagerListener(ActionsManagerListener l) {
        this.listener.addElement(l);
    }

    public void removeActionsManagerListener(ActionsManagerListener l) {
        this.listener.removeElement(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addActionsManagerListener(String propertyName, ActionsManagerListener l) {
        HashMap<String, List<ActionsManagerListener>> hashMap = this.listeners;
        synchronized (hashMap) {
            List<ActionsManagerListener> ls = this.listeners.get(propertyName);
            if (ls == null) {
                ls = new ArrayList<ActionsManagerListener>();
                this.listeners.put(propertyName, ls);
            }
            ls.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeActionsManagerListener(String propertyName, ActionsManagerListener l) {
        HashMap<String, List<ActionsManagerListener>> hashMap = this.listeners;
        synchronized (hashMap) {
            List<ActionsManagerListener> ls = this.listeners.get(propertyName);
            if (ls == null) {
                return;
            }
            ls.remove(l);
            if (ls.isEmpty()) {
                this.listeners.remove(propertyName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireActionToBeRun(Object action) {
        List<ActionsManagerListener> l1;
        this.initListeners();
        HashMap<String, List<ActionsManagerListener>> hashMap = this.listeners;
        synchronized (hashMap) {
            l1 = this.listeners.get("actionToBeRun");
            if (l1 != null) {
                l1 = new ArrayList<ActionsManagerListener>(l1);
            }
        }
        if (l1 != null) {
            int k = l1.size();
            PropertyChangeEvent e = new PropertyChangeEvent(this, "actionToBeRun", null, action);
            for (int i = 0; i < k; ++i) {
                ActionsManagerListener aml = l1.get(i);
                if (!(aml instanceof PropertyChangeListener)) continue;
                ((PropertyChangeListener)((Object)aml)).propertyChange(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireActionDone(Object action) {
        int i;
        List<ActionsManagerListener> l1;
        this.initListeners();
        ArrayList<ActionsManagerListener> l = new ArrayList<ActionsManagerListener>(this.listener);
        HashMap<String, List<ActionsManagerListener>> hashMap = this.listeners;
        synchronized (hashMap) {
            l1 = this.listeners.get("actionPerformed");
            if (l1 != null) {
                l1 = new ArrayList<ActionsManagerListener>(l1);
            }
        }
        int k = l.size();
        for (i = 0; i < k; ++i) {
            ((ActionsManagerListener)l.get(i)).actionPerformed(action);
        }
        if (l1 != null) {
            k = l1.size();
            for (i = 0; i < k; ++i) {
                l1.get(i).actionPerformed(action);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireActionStateChanged(Object action) {
        int i;
        List<ActionsManagerListener> l1;
        boolean enabled = this.isEnabled(action);
        this.initListeners();
        ArrayList<ActionsManagerListener> l = new ArrayList<ActionsManagerListener>(this.listener);
        HashMap<String, List<ActionsManagerListener>> hashMap = this.listeners;
        synchronized (hashMap) {
            l1 = this.listeners.get("actionStateChanged");
            if (l1 != null) {
                l1 = new ArrayList<ActionsManagerListener>(l1);
            }
        }
        int k = l.size();
        for (i = 0; i < k; ++i) {
            ((ActionsManagerListener)l.get(i)).actionStateChanged(action, enabled);
        }
        if (l1 != null) {
            k = l1.size();
            for (i = 0; i < k; ++i) {
                l1.get(i).actionStateChanged(action, enabled);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ActionsProvider> getActionProvidersForAction(Object action) {
        List<ActionsProvider> l;
        Object object = this.actionProvidersLock;
        synchronized (object) {
            l = this.actionProviders.get(action);
            if (l != null) {
                l = new ArrayList<ActionsProvider>(l);
            }
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ActionsProvider> getActionProvidersForActionWithInit(Object action) {
        boolean doInit = false;
        Object object = this.actionProvidersLock;
        synchronized (object) {
            if (this.actionProviders == null) {
                this.actionProviders = new HashMap();
                doInit = true;
            }
        }
        if (doInit) {
            this.initActionImpls();
        } else if (!this.actionProvidersInitialized.get()) {
            object = this.actionProvidersInitialized;
            synchronized (object) {
                if (!this.actionProvidersInitialized.get()) {
                    try {
                        this.actionProvidersInitialized.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
        return this.getActionProvidersForAction(action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerActionsProvider(Object action, ActionsProvider p) {
        Object object = this.actionProvidersLock;
        synchronized (object) {
            List<ActionsProvider> l = this.actionProviders.get(action);
            if (l == null) {
                l = new ArrayList<ActionsProvider>();
                this.actionProviders.put(action, l);
            }
            l.add(p);
        }
        p.addActionsProviderListener(this.actionListener);
        this.fireActionStateChanged(action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerActionsProviders(List<? extends ActionsProvider> aps) {
        List<? extends ActionsProvider> list = aps;
        synchronized (list) {
            if (logger.isLoggable(Level.INFO)) {
                boolean bl;
                StringBuilder sb = new StringBuilder(this.toString());
                boolean bl2 = false;
                sb.append(".registerActionsProviders:");
                for (ActionsProvider actionsProvider : aps) {
                    sb.append("\n  ");
                    if (actionsProvider != null) {
                        sb.append(actionsProvider.toString());
                        continue;
                    }
                    sb.append("NULL element in list " + Integer.toHexString(aps.hashCode()));
                    bl = true;
                }
                sb.append("\n");
                if (bl) {
                    logger.info(sb.toString());
                } else {
                    logger.fine(sb.toString());
                }
            }
            for (ActionsProvider actionsProvider : aps) {
                if (actionsProvider == null) continue;
                for (ActionsProvider actionsProvider2 : actionsProvider.getActions()) {
                    this.registerActionsProvider(actionsProvider2, actionsProvider);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initActionImpls() {
        try {
            this.aps = this.lookup.lookup(null, ActionsProvider.class);
            this.providersChangeListener = new PropertyChangeListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    logger.log(Level.FINE, "{0} Providers lookup changed, aps = {1}", new Object[]{this, ActionsManager.this.aps});
                    Object object = ActionsManager.this.actionProvidersLock;
                    synchronized (object) {
                        ActionsManager.this.actionProviders.clear();
                    }
                    ActionsManager.this.registerActionsProviders(ActionsManager.this.aps);
                }
            };
            logger.log(Level.FINE, "{0}.initActionImpls(): Add ProvidersChangeListener to {1}", new Object[]{this, this.aps});
            ((Customizer)((Object)this.aps)).addPropertyChangeListener(this.providersChangeListener);
            this.registerActionsProviders(this.aps);
        }
        finally {
            AtomicBoolean atomicBoolean = this.actionProvidersInitialized;
            synchronized (atomicBoolean) {
                this.actionProvidersInitialized.set(true);
                this.actionProvidersInitialized.notifyAll();
            }
        }
    }

    private synchronized void initListeners() {
        if (this.listerersLoaded) {
            return;
        }
        this.listerersLoaded = true;
        this.lazyListeners = this.lookup.lookup(null, LazyActionsManagerListener.class);
        int k = this.lazyListeners.size();
        for (int i = 0; i < k; ++i) {
            LazyActionsManagerListener l = (LazyActionsManagerListener)this.lazyListeners.get(i);
            if (l == null) continue;
            String[] props = l.getProperties();
            if (props == null) {
                this.addActionsManagerListener(l);
                continue;
            }
            int jj = props.length;
            for (int j = 0; j < jj; ++j) {
                this.addActionsManagerListener(props[j], l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyIn() {
        Customizer caps = (Customizer)((Object)this.aps);
        PropertyChangeListener pchl = this.providersChangeListener;
        if (caps != null && pchl != null) {
            caps.removePropertyChangeListener(pchl);
            logger.log(Level.FINE, "{0}.destroyIn(): ProvidersChangeListener removed from {1}", new Object[]{this, caps});
        }
        Object object = this;
        synchronized (object) {
            if (this.lazyListeners != null) {
                int k = this.lazyListeners.size();
                for (int i = 0; i < k; ++i) {
                    LazyActionsManagerListener l = (LazyActionsManagerListener)this.lazyListeners.get(i);
                    if (l == null) continue;
                    String[] props = l.getProperties();
                    if (props == null) {
                        this.removeActionsManagerListener(l);
                        continue;
                    }
                    int jj = props.length;
                    for (int j = 0; j < jj; ++j) {
                        this.removeActionsManagerListener(props[j], l);
                    }
                    l.destroy();
                }
                this.lazyListeners = new ArrayList();
            }
        }
        object = this.actionProvidersLock;
        synchronized (object) {
            Collection<List<ActionsProvider>> apsc = this.actionProviders.values();
            for (List<ActionsProvider> aps : apsc) {
                for (ActionsProvider ap : aps) {
                    ap.removeActionsProviderListener(this.actionListener);
                }
            }
        }
    }

    class MyActionListener
    implements ActionsProviderListener {
        MyActionListener() {
        }

        @Override
        public void actionStateChange(Object action, boolean enabled) {
            ActionsManager.this.fireActionStateChanged(action);
        }
    }

    private static class AsynchActionTask
    extends Task
    implements Cancellable {
        private Collection postedActions;

        public AsynchActionTask(Collection postedActions) {
            this.postedActions = postedActions;
        }

        void actionDone() {
            this.notifyFinished();
        }

        public boolean cancel() {
            for (Object action : this.postedActions) {
                Cancellable c = this.getCancellable(action);
                if (c != null) {
                    if (c.cancel()) continue;
                    return false;
                }
                return false;
            }
            return true;
        }

        private Cancellable getCancellable(Object action) {
            if (action instanceof Cancellable) {
                return (Cancellable)action;
            }
            try {
                Field delegateField = action.getClass().getDeclaredField("delegate");
                delegateField.setAccessible(true);
                action = delegateField.get(action);
                if (action instanceof Cancellable) {
                    return (Cancellable)action;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }
    }
}

