/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jspparser;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;

public final class ContextUtil {
    private ContextUtil() {
    }

    public static String getThrowableMessage(Throwable throwable, boolean includeStackTrace) {
        if (includeStackTrace) {
            StringWriter swriter = new StringWriter();
            PrintWriter pw = new PrintWriter(swriter);
            throwable.printStackTrace(pw);
            pw.close();
            return swriter.toString();
        }
        return throwable.getMessage();
    }

    public static boolean isInSubTree(FileObject folder, FileObject fo) {
        if (fo == folder) {
            return true;
        }
        return FileUtil.isParentOf((FileObject)folder, (FileObject)fo);
    }

    public static String findRelativePath(FileObject rootFolder, FileObject relativeObject) {
        String rfp = rootFolder.getPath();
        String rop = relativeObject.getPath();
        if (!ContextUtil.isInSubTree(rootFolder, relativeObject)) {
            FileObject parent;
            String message = relativeObject + " not under " + rootFolder + "\n";
            FileSystem fs = null;
            try {
                fs = rootFolder.getFileSystem();
            }
            catch (FileStateInvalidException ex) {
                fs = null;
            }
            message = message + rootFolder + " valid=" + rootFolder.isValid() + " id=" + System.identityHashCode(rootFolder) + " filesystem=" + fs + "\n";
            try {
                fs = relativeObject.getFileSystem();
            }
            catch (FileStateInvalidException ex) {
                fs = null;
            }
            message = message + relativeObject + " valid=" + relativeObject.isValid() + " id=" + System.identityHashCode(relativeObject) + " filesystem=" + fs + "\n";
            for (parent = relativeObject.getParent(); parent != null && !rfp.equals(parent.getPath()); parent = parent.getParent()) {
                try {
                    fs = parent.getFileSystem();
                }
                catch (FileStateInvalidException ex) {
                    fs = null;
                }
                message = message + parent + " valid=" + parent.isValid() + " id=" + System.identityHashCode(parent) + " filesystem=" + fs + "\n";
            }
            if (parent == null) {
                fs = null;
            } else {
                try {
                    fs = parent.getFileSystem();
                }
                catch (FileStateInvalidException ex) {
                    fs = null;
                }
            }
            String valid = parent != null ? String.valueOf(parent.isValid()) : "null";
            message = message + parent + " valid=" + valid + " id=" + System.identityHashCode(parent) + " filesystem=" + fs + "\n";
            throw new IllegalArgumentException(message);
        }
        String result = rop.substring(rfp.length());
        if (result.startsWith("/")) {
            result = result.substring(1);
        }
        return result;
    }

    public static String findRelativeContextPath(FileObject rootFolder, FileObject relativeObject) {
        String result = "/" + ContextUtil.findRelativePath(rootFolder, relativeObject);
        return relativeObject.isFolder() ? result + "/" : result;
    }
}

