/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.api.webservices;

import java.io.IOException;
import java.util.List;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.j2ee.dd.api.webservices.ServiceImplBean;
import org.netbeans.modules.websvc.spi.webservices.WebServicesSupportImpl;
import org.netbeans.modules.websvc.spi.webservices.WebServicesSupportProvider;
import org.netbeans.modules.websvc.webservices.WebServicesSupportAccessor;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public final class WebServicesSupport {
    private WebServicesSupportImpl impl;
    private static final Lookup.Result implementations = Lookup.getDefault().lookup(new Lookup.Template(WebServicesSupportProvider.class));

    private WebServicesSupport(WebServicesSupportImpl impl) {
        if (impl == null) {
            throw new IllegalArgumentException();
        }
        this.impl = impl;
    }

    public static WebServicesSupport getWebServicesSupport(FileObject f) {
        if (f == null) {
            throw new NullPointerException("Passed null to WebServicesSupport.getWebServicesSupport(FileObject)");
        }
        for (WebServicesSupportProvider impl : implementations.allInstances()) {
            WebServicesSupport wss = impl.findWebServicesSupport(f);
            if (wss == null) continue;
            return wss;
        }
        return null;
    }

    public void addServiceImpl(String serviceName, FileObject configFile, boolean fromWSDL) {
        this.impl.addServiceImpl(serviceName, configFile, fromWSDL);
    }

    public void addServiceEntriesToDD(String serviceName, String serviceEndpointInterface, String servantClassName) {
        this.impl.addServiceEntriesToDD(serviceName, serviceEndpointInterface, servantClassName);
    }

    public FileObject getWebservicesDD() {
        return this.impl.getWebservicesDD();
    }

    public FileObject getWsDDFolder() {
        return this.impl.getWsDDFolder();
    }

    public String getArchiveDDFolderName() {
        return this.impl.getArchiveDDFolderName();
    }

    public String getImplementationBean(String linkName) {
        return this.impl.getImplementationBean(linkName);
    }

    public void removeServiceEntry(String linkName) {
        this.impl.removeServiceEntry(linkName);
    }

    public void removeProjectEntries(String serviceName) {
        this.impl.removeProjectEntries(serviceName);
    }

    public AntProjectHelper getAntProjectHelper() {
        return this.impl.getAntProjectHelper();
    }

    public String generateImplementationBean(String name, FileObject pkg, Project project, String delegateData) throws IOException {
        return this.impl.generateImplementationBean(name, pkg, project, delegateData);
    }

    public void addServiceImplLinkEntry(ServiceImplBean serviceImplBean, String wsName) {
        this.impl.addServiceImplLinkEntry(serviceImplBean, wsName);
    }

    public ReferenceHelper getReferenceHelper() {
        return this.impl.getReferenceHelper();
    }

    public List getServices() {
        return this.impl.getServices();
    }

    public void addInfrastructure(String implBeanClass, FileObject pkg) {
        this.impl.addInfrastructure(implBeanClass, pkg);
    }

    public boolean isFromWSDL(String serviceName) {
        return this.impl.isFromWSDL(serviceName);
    }

    public void addServiceImpl(String serviceName, FileObject configFile, boolean fromWSDL, String[] wscompileFeatures) {
        this.impl.addServiceImpl(serviceName, configFile, fromWSDL, wscompileFeatures);
    }

    public boolean isBroken(Project project) {
        return WebServicesSupport.getWebServicesSupport(project.getProjectDirectory()) == null && !this.getServices().isEmpty();
    }

    public void showBrokenAlert(Project project) {
        ProjectInformation pi = ProjectUtils.getInformation((Project)project);
        String projectName = null;
        if (pi != null) {
            projectName = pi.getDisplayName();
        }
        NotifyDescriptor.Message alert = new NotifyDescriptor.Message((Object)NbBundle.getMessage(WebServicesSupport.class, (String)"ERR_NoJaxrpcPluginFound", (Object)projectName), 2);
        DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)alert);
    }

    static {
        WebServicesSupportAccessor.DEFAULT = new WebServicesSupportAccessor(){

            @Override
            public WebServicesSupport createWebServicesSupport(WebServicesSupportImpl spiWebServicesSupport) {
                return new WebServicesSupport(spiWebServicesSupport);
            }

            @Override
            public WebServicesSupportImpl getWebServicesSupportImpl(WebServicesSupport wss) {
                return wss == null ? null : wss.impl;
            }
        };
    }
}

