/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.dd.impl.client;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.j2ee.dd.api.client.AppClient;
import org.netbeans.modules.j2ee.dd.api.common.CommonDDBean;
import org.netbeans.modules.j2ee.dd.api.common.EjbRef;
import org.netbeans.modules.j2ee.dd.api.common.EnvEntry;
import org.netbeans.modules.j2ee.dd.api.common.Icon;
import org.netbeans.modules.j2ee.dd.api.common.MessageDestination;
import org.netbeans.modules.j2ee.dd.api.common.MessageDestinationRef;
import org.netbeans.modules.j2ee.dd.api.common.NameAlreadyUsedException;
import org.netbeans.modules.j2ee.dd.api.common.ResourceEnvRef;
import org.netbeans.modules.j2ee.dd.api.common.ResourceRef;
import org.netbeans.modules.j2ee.dd.api.common.RootInterface;
import org.netbeans.modules.j2ee.dd.api.common.ServiceRef;
import org.netbeans.modules.j2ee.dd.api.common.VersionNotSupportedException;
import org.openide.filesystems.FileAlreadyLockedException;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.xml.sax.SAXParseException;

public class AppClientProxy
implements AppClient {
    private AppClient app;
    private String version;
    private List<PropertyChangeListener> listeners;
    public boolean writing = false;
    private OutputProvider outputProvider;
    private SAXParseException error;
    private int ddStatus;
    private static final Logger LOGGER = Logger.getLogger(AppClientProxy.class.getName());

    public AppClientProxy(AppClient app, String version) {
        this.app = app;
        this.version = version;
        this.listeners = new ArrayList<PropertyChangeListener>();
    }

    public void setOriginal(AppClient app) {
        if (this.app != app) {
            for (PropertyChangeListener pcl : this.listeners) {
                if (this.app != null) {
                    this.app.removePropertyChangeListener(pcl);
                }
                if (app == null) continue;
                app.addPropertyChangeListener(pcl);
            }
            this.app = app;
            if (app != null) {
                String version = app.getVersion() != null ? app.getVersion().toString() : "";
                this.setProxyVersion(version);
            }
        }
    }

    public AppClient getOriginal() {
        return this.app;
    }

    public void setProxyVersion(String value) {
        if (this.version == null && value != null || this.version != null && !this.version.equals(value)) {
            PropertyChangeEvent evt = new PropertyChangeEvent(this, "dd_version", this.version, value);
            this.version = value;
            Iterator<PropertyChangeListener> i = this.listeners.iterator();
            while (i.hasNext()) {
                i.next().propertyChange(evt);
            }
        }
    }

    @Override
    public CommonDDBean addBean(String beanName) throws ClassNotFoundException {
        return this.app == null ? null : this.app.addBean(beanName);
    }

    @Override
    public CommonDDBean addBean(String beanName, String[] propertyNames, Object[] propertyValues, String keyProperty) throws ClassNotFoundException, NameAlreadyUsedException {
        return this.app == null ? null : this.app.addBean(beanName, propertyNames, propertyValues, keyProperty);
    }

    @Override
    public int addIcon(Icon value) throws VersionNotSupportedException {
        return this.app == null ? -1 : this.app.addIcon(value);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        if (this.app != null) {
            this.app.addPropertyChangeListener(pcl);
        }
        this.listeners.add(pcl);
    }

    @Override
    public CommonDDBean createBean(String beanName) throws ClassNotFoundException {
        return this.app == null ? null : this.app.createBean(beanName);
    }

    @Override
    public CommonDDBean findBeanByName(String beanName, String propertyName, String value) {
        return this.app == null ? null : this.app.findBeanByName(beanName, propertyName, value);
    }

    @Override
    public Map getAllDescriptions() {
        return this.app == null ? new HashMap() : this.app.getAllDescriptions();
    }

    @Override
    public Map getAllDisplayNames() {
        return this.app == null ? new HashMap() : this.app.getAllDisplayNames();
    }

    @Override
    public Map getAllIcons() {
        return this.app == null ? new HashMap() : this.app.getAllIcons();
    }

    @Override
    public String getDefaultDescription() {
        return this.app == null ? null : this.app.getDefaultDescription();
    }

    @Override
    public String getDefaultDisplayName() {
        return this.app == null ? null : this.app.getDefaultDisplayName();
    }

    @Override
    public Icon getDefaultIcon() {
        return this.app == null ? null : this.app.getDefaultIcon();
    }

    @Override
    public String getDescription(String locale) throws VersionNotSupportedException {
        return this.app == null ? null : this.app.getDescription(locale);
    }

    @Override
    public String getDisplayName(String locale) throws VersionNotSupportedException {
        return this.app == null ? null : this.app.getDisplayName(locale);
    }

    @Override
    public SAXParseException getError() {
        return this.error;
    }

    public void setError(SAXParseException error) {
        this.error = error;
    }

    @Override
    public Icon getIcon(int index) throws VersionNotSupportedException {
        return this.app == null ? null : this.app.getIcon(index);
    }

    @Override
    public String getId() {
        return this.app == null ? null : this.app.getId();
    }

    @Override
    public String getLargeIcon() {
        return this.app == null ? null : this.app.getLargeIcon();
    }

    @Override
    public String getLargeIcon(String locale) throws VersionNotSupportedException {
        return this.app == null ? null : this.app.getLargeIcon(locale);
    }

    @Override
    public String getSmallIcon() {
        return this.app == null ? null : this.app.getSmallIcon();
    }

    @Override
    public String getSmallIcon(String locale) throws VersionNotSupportedException {
        return this.app == null ? null : this.app.getSmallIcon(locale);
    }

    @Override
    public int getStatus() {
        return this.ddStatus;
    }

    public void setStatus(int value) {
        if (this.ddStatus != value) {
            PropertyChangeEvent evt = new PropertyChangeEvent(this, "dd_status", this.ddStatus, value);
            this.ddStatus = value;
            Iterator<PropertyChangeListener> i = this.listeners.iterator();
            while (i.hasNext()) {
                i.next().propertyChange(evt);
            }
        }
    }

    @Override
    public Object getValue(String propertyName) {
        return this.app == null ? null : this.app.getValue(propertyName);
    }

    @Override
    public BigDecimal getVersion() {
        if (this.version == null) {
            return null;
        }
        try {
            return new BigDecimal(this.version);
        }
        catch (NumberFormatException nfe) {
            LOGGER.log(Level.INFO, "Not a valid version: " + this.version, nfe);
            return null;
        }
    }

    @Override
    public void merge(RootInterface root, int mode) {
        if (this.app != null) {
            if (root instanceof AppClientProxy) {
                this.app.merge(((AppClientProxy)root).getOriginal(), mode);
            } else {
                this.app.merge(root, mode);
            }
        }
    }

    @Override
    public Icon newIcon() {
        try {
            return this.app == null ? null : this.app.newIcon();
        }
        catch (VersionNotSupportedException vnse) {
            return null;
        }
    }

    @Override
    public void removeAllDescriptions() {
        if (this.app != null) {
            this.app.removeAllDescriptions();
        }
    }

    @Override
    public void removeAllDisplayNames() {
        if (this.app != null) {
            this.app.removeAllDisplayNames();
        }
    }

    @Override
    public void removeAllIcons() {
        if (this.app != null) {
            this.app.removeAllIcons();
        }
    }

    @Override
    public void removeDescription() {
        if (this.app != null) {
            this.app.removeDescription();
        }
    }

    @Override
    public void removeDescriptionForLocale(String locale) throws VersionNotSupportedException {
        if (this.app != null) {
            this.app.removeDescriptionForLocale(locale);
        }
    }

    @Override
    public void removeDisplayName() {
        if (this.app != null) {
            this.app.removeDisplayName();
        }
    }

    @Override
    public void removeDisplayNameForLocale(String locale) throws VersionNotSupportedException {
        if (this.app != null) {
            this.app.removeDisplayNameForLocale(locale);
        }
    }

    @Override
    public void removeIcon() {
        if (this.app != null) {
            this.app.removeIcon();
        }
    }

    @Override
    public int removeIcon(Icon value) throws VersionNotSupportedException {
        return this.app == null ? -1 : this.app.removeIcon(value);
    }

    @Override
    public void removeIcon(String locale) throws VersionNotSupportedException {
        if (this.app != null) {
            this.app.removeIcon(locale);
        }
    }

    @Override
    public void removeLargeIcon() {
        if (this.app != null) {
            this.app.removeLargeIcon();
        }
    }

    @Override
    public void removeLargeIcon(String locale) throws VersionNotSupportedException {
        if (this.app != null) {
            this.app.removeLargeIcon(locale);
        }
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        if (this.app != null) {
            this.app.removePropertyChangeListener(pcl);
        }
        this.listeners.remove(pcl);
    }

    @Override
    public void removeSmallIcon() {
        if (this.app != null) {
            this.app.removeSmallIcon();
        }
    }

    @Override
    public void removeSmallIcon(String locale) throws VersionNotSupportedException {
        if (this.app != null) {
            this.app.removeSmallIcon(locale);
        }
    }

    @Override
    public void setAllDescriptions(Map descriptions) throws VersionNotSupportedException {
        if (this.app != null) {
            this.app.setAllDescriptions(descriptions);
        }
    }

    @Override
    public void setAllDisplayNames(Map displayNames) throws VersionNotSupportedException {
        if (this.app != null) {
            this.app.setAllDisplayNames(displayNames);
        }
    }

    @Override
    public void setAllIcons(String[] locales, String[] smallIcons, String[] largeIcons) throws VersionNotSupportedException {
        if (this.app != null) {
            this.app.setAllIcons(locales, smallIcons, largeIcons);
        }
    }

    @Override
    public void setDescription(String description) {
        if (this.app != null) {
            this.app.setDescription(description);
        }
    }

    @Override
    public void setDescription(String locale, String description) throws VersionNotSupportedException {
        if (this.app != null) {
            this.app.setDescription(locale, description);
        }
    }

    @Override
    public void setDisplayName(String displayName) {
        if (this.app != null) {
            this.app.setDisplayName(displayName);
        }
    }

    @Override
    public void setDisplayName(String locale, String displayName) throws VersionNotSupportedException {
        if (this.app != null) {
            this.app.setDisplayName(locale, displayName);
        }
    }

    @Override
    public void setIcon(Icon[] value) throws VersionNotSupportedException {
        if (this.app != null) {
            this.app.setIcon(value);
        }
    }

    @Override
    public void setIcon(Icon icon) {
        if (this.app != null) {
            this.app.setIcon(icon);
        }
    }

    @Override
    public void setIcon(int index, Icon value) throws VersionNotSupportedException {
        if (this.app != null) {
            this.app.setIcon(index, value);
        }
    }

    @Override
    public void setId(String value) {
        if (this.app != null) {
            this.app.setId(value);
        }
    }

    @Override
    public void setLargeIcon(String icon) {
        if (this.app != null) {
            this.app.setLargeIcon(icon);
        }
    }

    @Override
    public void setLargeIcon(String locale, String icon) throws VersionNotSupportedException {
        if (this.app != null) {
            this.app.setLargeIcon(locale, icon);
        }
    }

    @Override
    public void setSmallIcon(String icon) {
        if (this.app != null) {
            this.app.setSmallIcon(icon);
        }
    }

    @Override
    public void setSmallIcon(String locale, String icon) throws VersionNotSupportedException {
        if (this.app != null) {
            this.app.setSmallIcon(locale, icon);
        }
    }

    @Override
    public int sizeIcon() throws VersionNotSupportedException {
        return this.app == null ? 0 : this.app.sizeIcon();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(FileObject fo) throws IOException {
        if (this.app != null) {
            try {
                FileLock lock = fo.lock();
                try (OutputStream os = fo.getOutputStream(lock);){
                    this.writing = true;
                    this.write(os);
                }
                finally {
                    lock.releaseLock();
                }
            }
            catch (FileAlreadyLockedException ex) {
                DataObject dobj = DataObject.find((FileObject)fo);
                if (dobj != null && dobj instanceof OutputProvider) {
                    ((OutputProvider)dobj).write(this);
                }
                throw ex;
            }
        }
    }

    @Override
    public void write(OutputStream os) throws IOException {
        if (this.app != null) {
            this.writing = true;
            this.app.write(os);
        }
    }

    @Override
    public Object clone() {
        AppClientProxy proxy = null;
        if (this.app == null) {
            proxy = new AppClientProxy(null, this.version);
        } else {
            AppClientProxy clonedApp = (AppClientProxy)this.app.clone();
            proxy = new AppClientProxy(clonedApp, this.version);
        }
        proxy.setError(this.error);
        proxy.setStatus(this.ddStatus);
        return proxy;
    }

    public boolean isWriting() {
        return this.writing;
    }

    public void setWriting(boolean writing) {
        this.writing = writing;
    }

    public void setOutputProvider(OutputProvider iop) {
        this.outputProvider = iop;
    }

    @Override
    public int addEjbRef(EjbRef value) {
        return this.app == null ? -1 : this.app.addEjbRef(value);
    }

    @Override
    public int addEnvEntry(EnvEntry value) {
        return this.app == null ? -1 : this.app.addEnvEntry(value);
    }

    @Override
    public int addMessageDestination(MessageDestination value) throws VersionNotSupportedException {
        return this.app == null ? -1 : this.app.addMessageDestination(value);
    }

    @Override
    public int addMessageDestinationRef(MessageDestinationRef value) throws VersionNotSupportedException {
        return this.app == null ? -1 : this.app.addMessageDestinationRef(value);
    }

    @Override
    public int addResourceEnvRef(ResourceEnvRef value) {
        return this.app == null ? -1 : this.app.addResourceEnvRef(value);
    }

    @Override
    public int addResourceRef(ResourceRef value) {
        return this.app == null ? -1 : this.app.addResourceRef(value);
    }

    @Override
    public int addServiceRef(ServiceRef value) throws VersionNotSupportedException {
        return this.app == null ? -1 : this.app.addServiceRef(value);
    }

    @Override
    public String getCallbackHandler() {
        return this.app != null ? this.app.getCallbackHandler() : null;
    }

    @Override
    public EjbRef[] getEjbRef() {
        return this.app != null ? this.app.getEjbRef() : null;
    }

    @Override
    public EjbRef getEjbRef(int index) {
        return this.app != null ? this.app.getEjbRef(index) : null;
    }

    @Override
    public EnvEntry[] getEnvEntry() {
        return this.app == null ? new EnvEntry[]{} : this.app.getEnvEntry();
    }

    @Override
    public EnvEntry getEnvEntry(int index) {
        return this.app == null ? null : this.app.getEnvEntry(index);
    }

    @Override
    public MessageDestination[] getMessageDestination() throws VersionNotSupportedException {
        return this.app == null ? new MessageDestination[]{} : this.app.getMessageDestination();
    }

    @Override
    public MessageDestination getMessageDestination(int index) throws VersionNotSupportedException {
        return this.app == null ? null : this.app.getMessageDestination(index);
    }

    @Override
    public MessageDestinationRef[] getMessageDestinationRef() throws VersionNotSupportedException {
        return this.app == null ? new MessageDestinationRef[]{} : this.app.getMessageDestinationRef();
    }

    @Override
    public MessageDestinationRef getMessageDestinationRef(int index) throws VersionNotSupportedException {
        return this.app == null ? null : this.app.getMessageDestinationRef(index);
    }

    @Override
    public ResourceEnvRef[] getResourceEnvRef() {
        return this.app == null ? null : (this.app == null ? new ResourceEnvRef[]{} : this.app.getResourceEnvRef());
    }

    @Override
    public ResourceEnvRef getResourceEnvRef(int index) {
        return this.app == null ? null : this.app.getResourceEnvRef(index);
    }

    @Override
    public ResourceRef[] getResourceRef() {
        return this.app == null ? new ResourceRef[]{} : this.app.getResourceRef();
    }

    @Override
    public ResourceRef getResourceRef(int index) {
        return this.app == null ? null : this.app.getResourceRef(index);
    }

    @Override
    public ServiceRef[] getServiceRef() throws VersionNotSupportedException {
        return this.app == null ? new ServiceRef[]{} : this.app.getServiceRef();
    }

    @Override
    public ServiceRef getServiceRef(int index) throws VersionNotSupportedException {
        return this.app == null ? null : this.app.getServiceRef(index);
    }

    @Override
    public EjbRef newEjbRef() {
        return this.app != null ? this.app.newEjbRef() : null;
    }

    @Override
    public EnvEntry newEnvEntry() {
        return this.app != null ? this.app.newEnvEntry() : null;
    }

    @Override
    public MessageDestination newMessageDestination() throws VersionNotSupportedException {
        return this.app != null ? this.app.newMessageDestination() : null;
    }

    @Override
    public MessageDestinationRef newMessageDestinationRef() throws VersionNotSupportedException {
        return this.app != null ? this.app.newMessageDestinationRef() : null;
    }

    @Override
    public ResourceEnvRef newResourceEnvRef() {
        return this.app != null ? this.app.newResourceEnvRef() : null;
    }

    @Override
    public ResourceRef newResourceRef() {
        return this.app != null ? this.app.newResourceRef() : null;
    }

    @Override
    public ServiceRef newServiceRef() throws VersionNotSupportedException {
        return this.app != null ? this.app.newServiceRef() : null;
    }

    @Override
    public int removeEjbRef(EjbRef value) {
        return this.app == null ? -1 : this.app.removeEjbRef(value);
    }

    @Override
    public int removeEnvEntry(EnvEntry value) {
        return this.app == null ? -1 : this.app.removeEnvEntry(value);
    }

    @Override
    public int removeMessageDestination(MessageDestination value) throws VersionNotSupportedException {
        return this.app == null ? -1 : this.app.removeMessageDestination(value);
    }

    @Override
    public int removeMessageDestinationRef(MessageDestinationRef value) throws VersionNotSupportedException {
        return this.app == null ? -1 : this.app.removeMessageDestinationRef(value);
    }

    @Override
    public int removeResourceEnvRef(ResourceEnvRef value) {
        return this.app == null ? -1 : this.app.removeResourceEnvRef(value);
    }

    @Override
    public int removeResourceRef(ResourceRef value) {
        return this.app == null ? -1 : this.app.removeResourceRef(value);
    }

    @Override
    public int removeServiceRef(ServiceRef value) throws VersionNotSupportedException {
        return this.app == null ? -1 : this.app.removeServiceRef(value);
    }

    @Override
    public void setVersion(BigDecimal version) {
        if (this.app != null) {
            this.app.setVersion(version);
        }
    }

    @Override
    public void setEjbRef(EjbRef[] value) {
        if (this.app != null) {
            this.app.setEjbRef(value);
        }
    }

    @Override
    public void setResourceRef(int index, ResourceRef value) {
        if (this.app != null) {
            this.app.setResourceRef(index, value);
        }
    }

    @Override
    public void setResourceEnvRef(ResourceEnvRef[] value) {
        if (this.app != null) {
            this.app.setResourceEnvRef(value);
        }
    }

    @Override
    public void setServiceRef(int index, ServiceRef value) throws VersionNotSupportedException {
        if (this.app != null) {
            this.app.setServiceRef(index, value);
        }
    }

    @Override
    public void setMessageDestination(MessageDestination[] value) throws VersionNotSupportedException {
        if (this.app != null) {
            this.app.setMessageDestination(value);
        }
    }

    @Override
    public void setResourceEnvRef(int index, ResourceEnvRef value) {
        if (this.app != null) {
            this.app.setResourceEnvRef(index, value);
        }
    }

    @Override
    public void setEnvEntry(EnvEntry[] value) {
        if (this.app != null) {
            this.app.setEnvEntry(value);
        }
    }

    @Override
    public void setMessageDestination(int index, MessageDestination value) throws VersionNotSupportedException {
        if (this.app != null) {
            this.app.setMessageDestination(index, value);
        }
    }

    @Override
    public void setMessageDestinationRef(MessageDestinationRef[] value) throws VersionNotSupportedException {
        if (this.app != null) {
            this.app.setMessageDestinationRef(value);
        }
    }

    @Override
    public void setMessageDestinationRef(int index, MessageDestinationRef value) throws VersionNotSupportedException {
        if (this.app != null) {
            this.app.setMessageDestinationRef(index, value);
        }
    }

    @Override
    public void setEnvEntry(int index, EnvEntry value) {
        if (this.app != null) {
            this.app.setEnvEntry(index, value);
        }
    }

    @Override
    public void setEjbRef(int index, EjbRef value) {
        if (this.app != null) {
            this.app.setEjbRef(index, value);
        }
    }

    @Override
    public void setCallbackHandler(String value) {
        if (this.app != null) {
            this.app.setCallbackHandler(value);
        }
    }

    @Override
    public void setServiceRef(ServiceRef[] value) throws VersionNotSupportedException {
        if (this.app != null) {
            this.app.setServiceRef(value);
        }
    }

    @Override
    public void setResourceRef(ResourceRef[] value) {
        if (this.app != null) {
            this.app.setResourceRef(value);
        }
    }

    @Override
    public int sizeEjbRef() {
        return this.app != null ? this.app.sizeEjbRef() : 0;
    }

    @Override
    public int sizeEnvEntry() {
        return this.app == null ? 0 : this.app.sizeEnvEntry();
    }

    @Override
    public int sizeMessageDestination() throws VersionNotSupportedException {
        return this.app == null ? 0 : this.app.sizeMessageDestination();
    }

    @Override
    public int sizeMessageDestinationRef() throws VersionNotSupportedException {
        return this.app == null ? 0 : this.app.sizeMessageDestinationRef();
    }

    @Override
    public int sizeResourceEnvRef() {
        return this.app == null ? 0 : this.app.sizeResourceEnvRef();
    }

    @Override
    public int sizeResourceRef() {
        return this.app == null ? 0 : this.app.sizeResourceRef();
    }

    @Override
    public int sizeServiceRef() throws VersionNotSupportedException {
        return this.app == null ? 0 : this.app.sizeServiceRef();
    }

    public static interface OutputProvider {
        public void write(AppClient var1) throws IOException;

        public FileObject getTarget();
    }
}

