/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.dd.api.ejb;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.modules.j2ee.dd.api.common.CommonDDBean;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJar;
import org.netbeans.modules.j2ee.dd.impl.common.DDProviderDataObject;
import org.netbeans.modules.j2ee.dd.impl.common.DDUtils;
import org.netbeans.modules.j2ee.dd.impl.ejb.EjbJarProxy;
import org.netbeans.modules.schema2beans.BaseBean;
import org.netbeans.modules.xml.api.EncodingUtil;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class DDProvider {
    private static final String EJB_21_DOCTYPE = "http://java.sun.com/xml/ns/j2ee/ejb-jar_2_1.xsd";
    private static final String EJB_30_DOCTYPE = "http://java.sun.com/xml/ns/javaee/ejb-jar_3_0.xsd";
    private static final String EJB_31_DOCTYPE = "http://java.sun.com/xml/ns/javaee/ejb-jar_3_1.xsd";
    private static final String EJB_32_DOCTYPE = "http://xmlns.jcp.org/xml/ns/javaee/ejb-jar_3_2.xsd";
    private static final DDProvider ddProvider = new DDProvider();
    private final Map<Object, EjbJarProxy> ddMap = new HashMap<Object, EjbJarProxy>(5);

    private DDProvider() {
    }

    public static DDProvider getDefault() {
        return ddProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized EjbJar getDDRoot(FileObject fo) throws IOException {
        if (fo == null) {
            return null;
        }
        try {
            DataObject dataObject = DataObject.find((FileObject)fo);
            if (dataObject instanceof DDProviderDataObject) {
                return this.getDDRoot0((DDProviderDataObject)dataObject);
            }
        }
        catch (DataObjectNotFoundException e) {
            return null;
        }
        EjbJarProxy ejbJarProxy = null;
        Map<Object, EjbJarProxy> map = this.ddMap;
        synchronized (map) {
            ejbJarProxy = this.getFromCache(fo);
            if (ejbJarProxy != null) {
                return ejbJarProxy;
            }
        }
        fo.addFileChangeListener((FileChangeListener)new DDFileChangeListener());
        ejbJarProxy = DDUtils.createEjbJarProxy(fo);
        map = this.ddMap;
        synchronized (map) {
            EjbJarProxy cached = this.getFromCache(fo);
            if (cached != null) {
                return cached;
            }
            this.putToCache(fo, ejbJarProxy);
        }
        return ejbJarProxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized EjbJar getDDRoot0(DDProviderDataObject ddProviderDataObject) throws IOException {
        EjbJarProxy ejbJarProxy = null;
        Map<Object, EjbJarProxy> map = this.ddMap;
        synchronized (map) {
            ejbJarProxy = this.getFromCache(ddProviderDataObject);
            if (ejbJarProxy == null) {
                ejbJarProxy = DDUtils.createEjbJarProxy(ddProviderDataObject.createReader());
                this.putToCache(ddProviderDataObject, ejbJarProxy);
            }
        }
        return ejbJarProxy;
    }

    public EjbJar getDDRootCopy(FileObject fo) throws IOException {
        return (EjbJar)this.getDDRoot(fo).clone();
    }

    private EjbJarProxy getFromCache(Object o) {
        return this.ddMap.get(o);
    }

    private void putToCache(Object o, EjbJarProxy ejbJarProxy) {
        this.ddMap.put(o, ejbJarProxy);
    }

    public EjbJar getDDRoot(InputSource inputSource) throws IOException, SAXException {
        ErrorHandler errorHandler = new ErrorHandler();
        DocumentBuilder parser = DDProvider.createParser(errorHandler);
        parser.setEntityResolver(DDResolver.getInstance());
        Document document = parser.parse(inputSource);
        SAXParseException error = errorHandler.getError();
        String version = DDProvider.extractVersion(document);
        EjbJar original = DDProvider.createEjbJar(version, document);
        EjbJarProxy ejbJarProxy = new EjbJarProxy(original, version);
        ejbJarProxy.setError(error);
        if (error != null) {
            ejbJarProxy.setStatus(1);
        } else {
            ejbJarProxy.setStatus(0);
        }
        return ejbJarProxy;
    }

    public BaseBean getBaseBean(CommonDDBean bean) {
        if (bean instanceof BaseBean) {
            return (BaseBean)bean;
        }
        if (bean instanceof EjbJarProxy) {
            return (BaseBean)((EjbJarProxy)bean).getOriginal();
        }
        return null;
    }

    private static EjbJar createEjbJar(String version, Document document) {
        if ("3.2".equals(version)) {
            return new org.netbeans.modules.j2ee.dd.impl.ejb.model_3_2.EjbJar(document, 1);
        }
        if ("3.1".equals(version)) {
            return new org.netbeans.modules.j2ee.dd.impl.ejb.model_3_1.EjbJar(document, 1);
        }
        if ("3.0".equals(version)) {
            return new org.netbeans.modules.j2ee.dd.impl.ejb.model_3_0.EjbJar(document, 1);
        }
        if ("2.1".equals(version)) {
            return new org.netbeans.modules.j2ee.dd.impl.ejb.model_2_1.EjbJar(document, 1);
        }
        return null;
    }

    private static String extractVersion(Document document) {
        String id = null;
        DocumentType dt = document.getDoctype();
        if (dt != null) {
            id = dt.getPublicId();
        } else {
            String schemaLocation = document.getDocumentElement().getAttribute("xsi:schemaLocation");
            if (schemaLocation != null) {
                id = schemaLocation.substring(schemaLocation.lastIndexOf(" ") + 1);
            }
        }
        if (id != null) {
            if (EJB_32_DOCTYPE.equals(id)) {
                return "3.2";
            }
            if (EJB_31_DOCTYPE.equals(id)) {
                return "3.1";
            }
            if (EJB_30_DOCTYPE.equals(id)) {
                return "3.0";
            }
            if (EJB_21_DOCTYPE.equals(id)) {
                return "2.1";
            }
        }
        return "3.2";
    }

    private static DocumentBuilder createParser(ErrorHandler errorHandler) throws SAXException {
        DocumentBuilder parser = null;
        try {
            DocumentBuilderFactory fact = DocumentBuilderFactory.newInstance();
            parser = fact.newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            throw new SAXException(ex.getMessage());
        }
        parser.setErrorHandler(errorHandler);
        return parser;
    }

    private class DDFileChangeListener
    extends FileChangeAdapter {
        private DDFileChangeListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fileChanged(FileEvent evt) {
            FileObject fo = evt.getFile();
            try {
                Map map = DDProvider.this.ddMap;
                synchronized (map) {
                    EjbJarProxy ejbJarProxy = DDProvider.this.getFromCache(fo);
                    if (ejbJarProxy != null) {
                        try (InputStream inputStream = fo.getInputStream();){
                            String encoding = EncodingUtil.detectEncoding((InputStream)new BufferedInputStream(inputStream));
                            if (encoding == null) {
                                encoding = "UTF8";
                            }
                            DDUtils.merge(ejbJarProxy, new InputStreamReader(inputStream, encoding));
                        }
                    }
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private static class ErrorHandler
    implements org.xml.sax.ErrorHandler {
        private int errorType = -1;
        SAXParseException error;

        private ErrorHandler() {
        }

        @Override
        public void warning(SAXParseException sAXParseException) throws SAXException {
            if (this.errorType < 0) {
                this.errorType = 0;
                this.error = sAXParseException;
            }
        }

        @Override
        public void error(SAXParseException sAXParseException) throws SAXException {
            if (this.errorType < 1) {
                this.errorType = 1;
                this.error = sAXParseException;
            }
        }

        @Override
        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            this.errorType = 2;
            throw sAXParseException;
        }

        public int getErrorType() {
            return this.errorType;
        }

        public SAXParseException getError() {
            return this.error;
        }
    }

    private static class DDResolver
    implements EntityResolver {
        static DDResolver resolver;

        private DDResolver() {
        }

        static synchronized DDResolver getInstance() {
            if (resolver == null) {
                resolver = new DDResolver();
            }
            return resolver;
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) {
            String resource;
            if (DDProvider.EJB_32_DOCTYPE.equals(systemId)) {
                resource = "/org/netbeans/modules/j2ee/dd/impl/resources/ejb-jar_3_2.xsd";
            } else if (DDProvider.EJB_31_DOCTYPE.equals(systemId)) {
                resource = "/org/netbeans/modules/j2ee/dd/impl/resources/ejb-jar_3_1.xsd";
            } else if (DDProvider.EJB_30_DOCTYPE.equals(systemId)) {
                resource = "/org/netbeans/modules/j2ee/dd/impl/resources/ejb-jar_3_0.xsd";
            } else if (DDProvider.EJB_21_DOCTYPE.equals(systemId)) {
                resource = "/org/netbeans/modules/j2ee/dd/impl/resources/ejb-jar_2_1.xsd";
            } else {
                return null;
            }
            URL url = this.getClass().getResource(resource);
            return new InputSource(url.toString());
        }
    }
}

