/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.polyglot.EngineAccessor;
import com.oracle.truffle.polyglot.PolyglotContextImpl;
import com.oracle.truffle.polyglot.PolyglotEngineImpl;
import com.oracle.truffle.polyglot.PolyglotImpl;
import com.oracle.truffle.polyglot.PolyglotLanguage;
import com.oracle.truffle.polyglot.PolyglotLanguageContext;

abstract class HostToGuestRootNode
extends RootNode {
    protected static final int ARGUMENT_OFFSET = 2;
    @CompilerDirectives.CompilationFinal
    private boolean seenEnter;
    @CompilerDirectives.CompilationFinal
    private boolean seenNonEnter;
    @CompilerDirectives.CompilationFinal
    private volatile PolyglotLanguage.ContextProfile profile;
    private final PolyglotEngineImpl engine;
    private final BranchProfile error = BranchProfile.create();

    HostToGuestRootNode() {
        this((PolyglotLanguageContext)null);
    }

    HostToGuestRootNode(PolyglotLanguageContext languageContext) {
        super(languageContext != null ? languageContext.getLanguageInstance().spi : null);
        this.engine = (PolyglotEngineImpl)EngineAccessor.NODES.getPolyglotEngine(this);
        assert (this.engine != null) : "all host to guest root nodes need to be initialized when entered";
    }

    protected abstract Class<?> getReceiverType();

    protected boolean needsEnter() {
        return true;
    }

    protected boolean needsExceptionWrapping() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Object execute(VirtualFrame frame) {
        PolyglotContextImpl prev;
        boolean needsEnter;
        Object[] args = frame.getArguments();
        PolyglotLanguageContext languageContext = this.profileContext(args[0]);
        assert (languageContext != null);
        PolyglotContextImpl context = languageContext.context;
        boolean bl = needsEnter = this.needsEnter() && languageContext != null && this.engine.needsEnter(context);
        if (needsEnter) {
            if (!this.seenEnter) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.seenEnter = true;
            }
            prev = this.engine.enter(context);
        } else {
            if (!this.seenNonEnter) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.seenNonEnter = true;
            }
            prev = null;
        }
        try {
            Object[] arguments = frame.getArguments();
            Object receiver = this.getReceiverType().cast(arguments[1]);
            Object result = this.executeImpl(languageContext, receiver, arguments);
            assert (!(result instanceof TruffleObject));
            Object object = result;
            if (needsEnter) {
                this.engine.leave(prev, context);
            }
            return object;
        }
        catch (Throwable throwable) {
            try {
                if (needsEnter) {
                    this.engine.leave(prev, context);
                }
                throw throwable;
            }
            catch (Throwable e) {
                if (this.needsExceptionWrapping()) {
                    this.error.enter();
                    throw PolyglotImpl.guestToHostException(languageContext, e);
                }
                throw e;
            }
        }
    }

    private PolyglotLanguageContext profileContext(Object languageContext) {
        PolyglotLanguage.ContextProfile localProfile = this.profile;
        if (localProfile == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.profile = localProfile = ((PolyglotLanguageContext)languageContext).language.profile;
        }
        return localProfile.profile(languageContext);
    }

    protected abstract Object executeImpl(PolyglotLanguageContext var1, Object var2, Object[] var3);

    protected static CallTarget createTarget(HostToGuestRootNode node) {
        return Truffle.getRuntime().createCallTarget(node);
    }

    static <T> T installHostCodeCache(PolyglotLanguageContext languageContext, Object key, T value, Class<T> expectedType) {
        T result = expectedType.cast(languageContext.getLanguageInstance().hostInteropCodeCache.putIfAbsent(key, value));
        if (result != null) {
            return result;
        }
        return value;
    }

    static <T> T lookupHostCodeCache(PolyglotLanguageContext languageContext, Object key, Class<T> expectedType) {
        return expectedType.cast(languageContext.getLanguageInstance().hostInteropCodeCache.get(key));
    }
}

