/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seplatform;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.netbeans.spi.java.platform.JavaPlatformFactory;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;

public class SdkManJavaPlatformDetector
implements Runnable {
    static final File SDKMAN_JAVA_DIR = new File(System.getProperty("user.home"), ".sdkman/candidates/java");

    @Override
    public void run() {
        if (SDKMAN_JAVA_DIR.isDirectory()) {
            File[] platformDirs = SDKMAN_JAVA_DIR.listFiles(f -> f.isDirectory() && !"current".equals(f.getName()));
            Collection providers = Lookup.getDefault().lookupAll(JavaPlatformFactory.Provider.class);
            for (JavaPlatformFactory.Provider provider : providers) {
                JavaPlatformFactory platformFactory = provider.forType("j2se");
                if (platformFactory == null) continue;
                for (File platformDir : platformDirs) {
                    try {
                        FileObject installFolder = FileUtil.toFileObject((File)platformDir);
                        platformFactory.create(installFolder, SdkManJavaPlatformDetector.getDisplayName(installFolder), true);
                    }
                    catch (IOException iOException) {
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private static String getDisplayName(FileObject installDir) {
        return "JDK " + installDir.getNameExt();
    }
}

