/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.oracle;

import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.cloud.oracle.DatabaseNode;
import org.netbeans.modules.cloud.oracle.OCIItem;
import org.netbeans.modules.cloud.oracle.OCIManager;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;

public class CompartmentNode
extends AbstractNode {
    private static final String COMPARTMENT_ICON = "org/netbeans/modules/cloud/oracle/resources/compartment.svg";

    public CompartmentNode(OCIItem compartment) {
        super(Children.create((ChildFactory)new CompartmentChildFactory(compartment), (boolean)true));
        this.setName(compartment.getName());
        this.setDisplayName(compartment.getName());
        this.setIconBaseWithExtension(COMPARTMENT_ICON);
    }

    public static class CompartmentChildFactory
    extends ChildFactory<OCIItem>
    implements ChangeListener {
        private final String compartmentId;

        public CompartmentChildFactory(OCIItem compartment) {
            this.compartmentId = compartment.getId();
        }

        protected boolean createKeys(List<OCIItem> toPopulate) {
            toPopulate.addAll(OCIManager.getDefault().getDatabases(this.compartmentId));
            return true;
        }

        @Override
        public void stateChanged(ChangeEvent e) {
        }

        protected Node createNodeForKey(OCIItem key) {
            DatabaseNode node = new DatabaseNode(key);
            return node;
        }
    }
}

