/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.derby;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.derby.DerbyOptions;
import org.netbeans.modules.derby.JDKDerbyHelper;
import org.netbeans.modules.derby.api.DerbyDatabases;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class DerbyActivator {
    private static final Logger LOGGER = Logger.getLogger(DerbyActivator.class.getName());
    private static final String FIRST_RUN = "first_run";
    private static final JDKDerbyHelper helper = JDKDerbyHelper.forDefault();

    public static synchronized void activate() {
        boolean firstTime = NbPreferences.forModule(DerbyActivator.class).getBoolean(FIRST_RUN, Boolean.TRUE);
        Logger.getLogger(DerbyActivator.class.getName()).finest("Is DerbyActivator.activate() called for the 1st time? " + firstTime);
        if (firstTime) {
            NbPreferences.forModule(DerbyActivator.class).putBoolean(FIRST_RUN, Boolean.FALSE);
            DerbyActivator.doActivate();
        }
    }

    private static void doActivate() {
        if (!helper.canBundleDerby()) {
            LOGGER.fine("Default platform cannot bundle Derby");
            return;
        }
        ProgressHandle handle = ProgressHandleFactory.createSystemHandle((String)NbBundle.getMessage(DerbyActivator.class, (String)"MSG_RegisterJavaDB"));
        handle.start();
        try {
            if (DerbyActivator.registerDerby()) {
                DerbyActivator.registerSampleDatabase();
            }
        }
        finally {
            handle.finish();
        }
    }

    private static boolean registerDerby() {
        String derbyLocation = helper.findDerbyLocation();
        if (derbyLocation != null) {
            LOGGER.log(Level.FINE, "Registering Derby at {0}", derbyLocation);
            return DerbyOptions.getDefault().trySetLocation(derbyLocation);
        }
        return false;
    }

    private static void registerSampleDatabase() {
        try {
            DerbyDatabases.createSampleDatabase();
        }
        catch (DatabaseException e) {
            LOGGER.log(Level.WARNING, null, e);
        }
        catch (IOException e) {
            LOGGER.log(Level.INFO, "Failed to create sample database", e);
        }
    }
}

