/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.jaxws.nodes;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.websvc.api.jaxws.client.JAXWSClientSupport;
import org.netbeans.modules.websvc.api.jaxws.project.config.Client;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.api.jaxws.project.config.Service;
import org.netbeans.modules.websvc.core.AbstractProjectWebServiceViewImpl;
import org.netbeans.modules.websvc.core.ProjectWebServiceView;
import org.netbeans.modules.websvc.core.jaxws.nodes.JaxWsClientNode;
import org.netbeans.modules.websvc.core.jaxws.nodes.JaxWsNode;
import org.netbeans.modules.websvc.jaxws.api.JAXWSSupport;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.WeakListeners;

final class ProjectJaxWsWebServiceView
extends AbstractProjectWebServiceViewImpl
implements PropertyChangeListener {
    private JaxWsModel jaxWsModel;
    private JAXWSSupport jaxwsSupport;
    private JAXWSClientSupport jaxwsClientSupport;
    private PropertyChangeListener weakModelListener;

    ProjectJaxWsWebServiceView(Project p) {
        super(p);
        this.jaxWsModel = (JaxWsModel)p.getLookup().lookup(JaxWsModel.class);
        this.weakModelListener = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.jaxWsModel);
        FileObject projectDir = p.getProjectDirectory();
        this.jaxwsSupport = JAXWSSupport.getJAXWSSupport((FileObject)projectDir);
        this.jaxwsClientSupport = JAXWSClientSupport.getJaxWsClientSupport((FileObject)projectDir);
    }

    @Override
    public Node[] createView(ProjectWebServiceView.ViewType viewType) {
        switch (viewType) {
            case SERVICE: {
                return this.createServiceNodes();
            }
            case CLIENT: {
                return this.createClientNodes();
            }
        }
        return new Node[0];
    }

    private Node[] createServiceNodes() {
        SourceGroup[] groups;
        Service[] services = this.jaxWsModel.getServices();
        if (services == null || services.length <= 0) {
            return new Node[0];
        }
        Sources sources = (Sources)this.getProject().getLookup().lookup(Sources.class);
        ArrayList<FileObject> roots = new ArrayList<FileObject>();
        if (sources != null && (groups = sources.getSourceGroups("java")) != null) {
            for (SourceGroup sourceGroup : groups) {
                roots.add(sourceGroup.getRootFolder());
            }
        }
        if (roots.isEmpty()) {
            return new Node[0];
        }
        ArrayList<JaxWsNode> nodes = new ArrayList<JaxWsNode>();
        block1: for (SourceGroup sourceGroup : services) {
            String implClass = sourceGroup.getImplementationClass();
            if (implClass == null) continue;
            for (FileObject srcRoot : roots) {
                FileObject implClassFo = srcRoot.getFileObject(implClass.replace('.', '/') + ".java");
                if (implClassFo == null) continue;
                nodes.add(new JaxWsNode(this.jaxWsModel, (Service)sourceGroup, srcRoot, implClassFo));
                continue block1;
            }
        }
        return nodes.toArray(new Node[nodes.size()]);
    }

    private Node[] createClientNodes() {
        ArrayList<JaxWsClientNode> nodes = new ArrayList<JaxWsClientNode>();
        Client[] clients = this.jaxWsModel.getClients();
        if (clients != null && clients.length > 0) {
            for (Client client : clients) {
                nodes.add(new JaxWsClientNode(this.jaxWsModel, client, this.getProject().getProjectDirectory()));
            }
        }
        return nodes.toArray(new Node[nodes.size()]);
    }

    @Override
    public boolean isViewEmpty(ProjectWebServiceView.ViewType viewType) {
        switch (viewType) {
            case SERVICE: {
                return this.jaxWsModel == null || this.jaxwsSupport == null || this.jaxWsModel.getServices().length == 0;
            }
            case CLIENT: {
                return this.jaxWsModel == null || this.jaxwsClientSupport == null || this.jaxWsModel.getClients().length == 0;
            }
        }
        return true;
    }

    @Override
    public void addNotify() {
        if (this.jaxWsModel != null) {
            this.jaxWsModel.addPropertyChangeListener(this.weakModelListener);
        }
    }

    @Override
    public void removeNotify() {
        if (this.jaxWsModel != null) {
            this.jaxWsModel.removePropertyChangeListener(this.weakModelListener);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Object oldValue = evt.getOldValue();
        Object newValue = evt.getNewValue();
        if (oldValue instanceof Service || newValue instanceof Service) {
            this.fireChange(ProjectWebServiceView.ViewType.SERVICE);
        }
        if (oldValue instanceof Client || newValue instanceof Client) {
            this.fireChange(ProjectWebServiceView.ViewType.CLIENT);
        }
    }
}

