/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.editor.module;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;
import javax.swing.text.Document;
import org.netbeans.modules.csl.api.ColoringAttributes;
import org.netbeans.modules.csl.api.CompletionProposal;
import org.netbeans.modules.csl.api.DeclarationFinder;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.StructureItem;
import org.netbeans.modules.css.editor.module.spi.Browser;
import org.netbeans.modules.css.editor.module.spi.CompletionContext;
import org.netbeans.modules.css.editor.module.spi.CssEditorModule;
import org.netbeans.modules.css.editor.module.spi.EditorFeatureContext;
import org.netbeans.modules.css.editor.module.spi.FeatureCancel;
import org.netbeans.modules.css.editor.module.spi.FeatureContext;
import org.netbeans.modules.css.editor.module.spi.FutureParamTask;
import org.netbeans.modules.css.editor.module.spi.HelpResolver;
import org.netbeans.modules.css.editor.module.spi.PropertySupportResolver;
import org.netbeans.modules.css.editor.module.spi.SemanticAnalyzer;
import org.netbeans.modules.css.editor.module.spi.SemanticAnalyzerResult;
import org.netbeans.modules.css.lib.api.Node;
import org.netbeans.modules.css.lib.api.NodeVisitor;
import org.netbeans.modules.css.lib.api.properties.PropertyDefinition;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.Pair;

public class CssModuleSupport {
    private static final Logger LOGGER = Logger.getLogger(CssModuleSupport.class.getSimpleName());

    public static Collection<? extends CssEditorModule> getModules() {
        return Lookup.getDefault().lookupAll(CssEditorModule.class);
    }

    public static SemanticAnalyzerResult analyzeDeclaration(Node declarationNode) {
        SemanticAnalyzerResult result = SemanticAnalyzerResult.UNKNOWN;
        for (CssEditorModule cssEditorModule : CssModuleSupport.getModules()) {
            SemanticAnalyzer semanticAnalyzer = cssEditorModule.getSemanticAnalyzer();
            if (semanticAnalyzer == null) continue;
            SemanticAnalyzerResult local = semanticAnalyzer.analyzeDeclaration(declarationNode);
            assert (local != null);
            switch (local.getType()) {
                case VALID: {
                    result = local;
                    break;
                }
                case ERRONEOUS: {
                    return local;
                }
            }
        }
        return result;
    }

    public static Map<OffsetRange, Set<ColoringAttributes>> getSemanticHighlights(FeatureContext context, FeatureCancel cancel) {
        HashMap<OffsetRange, Set<ColoringAttributes>> all = new HashMap<OffsetRange, Set<ColoringAttributes>>();
        final ArrayList visitors = new ArrayList();
        for (CssEditorModule cssEditorModule : CssModuleSupport.getModules()) {
            NodeVisitor visitor = cssEditorModule.getSemanticHighlightingNodeVisitor(context, all);
            if (visitor == null) continue;
            visitors.add(visitor);
        }
        if (cancel.isCancelled()) {
            return Collections.emptyMap();
        }
        cancel.attachCancelAction(new Runnable(){

            @Override
            public void run() {
                for (NodeVisitor visitor : visitors) {
                    visitor.cancel();
                }
            }
        });
        NodeVisitor.visitChildren((Node)context.getParseTreeRoot(), visitors);
        return all;
    }

    public static Set<OffsetRange> getMarkOccurrences(EditorFeatureContext context, FeatureCancel cancel) {
        HashSet<OffsetRange> all = new HashSet<OffsetRange>();
        final ArrayList visitors = new ArrayList();
        for (CssEditorModule cssEditorModule : CssModuleSupport.getModules()) {
            NodeVisitor visitor = cssEditorModule.getMarkOccurrencesNodeVisitor(context, all);
            if (visitor == null) continue;
            visitors.add(visitor);
        }
        if (cancel.isCancelled()) {
            return Collections.emptySet();
        }
        cancel.attachCancelAction(new Runnable(){

            @Override
            public void run() {
                for (NodeVisitor visitor : visitors) {
                    visitor.cancel();
                }
            }
        });
        NodeVisitor.visitChildren((Node)context.getParseTreeRoot(), visitors);
        return all;
    }

    public static Map<String, List<OffsetRange>> getFolds(FeatureContext context, FeatureCancel cancel) {
        HashMap<String, List<OffsetRange>> all = new HashMap<String, List<OffsetRange>>();
        final ArrayList visitors = new ArrayList();
        for (CssEditorModule cssEditorModule : CssModuleSupport.getModules()) {
            NodeVisitor visitor = cssEditorModule.getFoldsNodeVisitor(context, all);
            if (visitor == null) continue;
            visitors.add(visitor);
        }
        if (cancel.isCancelled()) {
            return Collections.emptyMap();
        }
        cancel.attachCancelAction(new Runnable(){

            @Override
            public void run() {
                for (NodeVisitor visitor : visitors) {
                    visitor.cancel();
                }
            }
        });
        NodeVisitor.visitChildren((Node)context.getParseTreeRoot(), visitors);
        return all;
    }

    public static Pair<OffsetRange, FutureParamTask<DeclarationFinder.DeclarationLocation, EditorFeatureContext>> getDeclarationLocation(final Document document, final int caretOffset, final FeatureCancel cancel) {
        final AtomicReference result = new AtomicReference();
        document.render(new Runnable(){

            @Override
            public void run() {
                for (CssEditorModule cssEditorModule : CssModuleSupport.getModules()) {
                    if (cancel.isCancelled()) {
                        return;
                    }
                    Pair<OffsetRange, FutureParamTask<DeclarationFinder.DeclarationLocation, EditorFeatureContext>> declarationLocation = cssEditorModule.getDeclaration(document, caretOffset);
                    if (declarationLocation == null) continue;
                    result.set(declarationLocation);
                    return;
                }
            }
        });
        return (Pair)result.get();
    }

    public static List<StructureItem> getStructureItems(FeatureContext context, FeatureCancel cancel) {
        ArrayList<StructureItem> all = new ArrayList<StructureItem>();
        final ArrayList visitors = new ArrayList();
        for (CssEditorModule cssEditorModule : CssModuleSupport.getModules()) {
            NodeVisitor visitor = cssEditorModule.getStructureItemsNodeVisitor(context, all);
            if (visitor == null) continue;
            visitors.add(visitor);
        }
        if (cancel.isCancelled()) {
            return Collections.emptyList();
        }
        cancel.attachCancelAction(new Runnable(){

            @Override
            public void run() {
                for (NodeVisitor visitor : visitors) {
                    visitor.cancel();
                }
            }
        });
        NodeVisitor.visitChildren((Node)context.getParseTreeRoot(), visitors);
        return all;
    }

    public static CssEditorModule getModuleForInstantRename(EditorFeatureContext context) {
        HashSet all = new HashSet();
        for (CssEditorModule cssEditorModule : CssModuleSupport.getModules()) {
            if (!cssEditorModule.isInstantRenameAllowed(context)) continue;
            return cssEditorModule;
        }
        return null;
    }

    public static Set<OffsetRange> getInstantRenameRegions(EditorFeatureContext context, CssEditorModule module) {
        HashSet<OffsetRange> all = new HashSet<OffsetRange>();
        assert (module.isInstantRenameAllowed(context));
        NodeVisitor visitor = module.getInstantRenamerVisitor(context, all);
        assert (visitor != null);
        visitor.visitChildren(context.getParseTreeRoot());
        return all;
    }

    public static List<CompletionProposal> getCompletionProposals(CompletionContext context) {
        ArrayList<CompletionProposal> all = new ArrayList<CompletionProposal>();
        for (CssEditorModule cssEditorModule : CssModuleSupport.getModules()) {
            all.addAll(cssEditorModule.getCompletionProposals(context));
        }
        return all;
    }

    public static Collection<String> getPseudoClasses(EditorFeatureContext context) {
        HashSet<String> all = new HashSet<String>();
        for (CssEditorModule cssEditorModule : CssModuleSupport.getModules()) {
            Collection<String> vals = cssEditorModule.getPseudoClasses(context);
            if (vals == null) continue;
            all.addAll(vals);
        }
        return all;
    }

    public static Collection<String> getPseudoElements(EditorFeatureContext context) {
        HashSet<String> all = new HashSet<String>();
        for (CssEditorModule cssEditorModule : CssModuleSupport.getModules()) {
            Collection<String> vals = cssEditorModule.getPseudoElements(context);
            if (vals == null) continue;
            all.addAll(vals);
        }
        return all;
    }

    public static SortedSet<Browser> getBrowsers(FileObject file) {
        TreeSet<Browser> all = new TreeSet<Browser>(new Comparator<Browser>(){

            @Override
            public int compare(Browser t, Browser t1) {
                return t.getName().compareTo(t1.getName());
            }
        });
        for (CssEditorModule cssEditorModule : CssModuleSupport.getModules()) {
            Collection<Browser> extraBrowsers = cssEditorModule.getExtraBrowsers(file);
            if (extraBrowsers == null) continue;
            all.addAll(extraBrowsers);
        }
        return all;
    }

    public static boolean isPropertySupported(String propertyName, Browser browser) {
        for (CssEditorModule cssEditorModule : CssModuleSupport.getModules()) {
            PropertySupportResolver resolver;
            PropertySupportResolver.Factory factory = cssEditorModule.getPropertySupportResolverFactory();
            if (factory == null || (resolver = factory.createPropertySupportResolver(browser)) == null || !resolver.isPropertySupported(propertyName)) continue;
            return true;
        }
        return false;
    }

    public static HelpResolver getHelpResolver() {
        return new HelpResolver(){

            @Override
            public String getHelp(FileObject context, PropertyDefinition property) {
                StringBuilder sb = new StringBuilder();
                for (HelpResolver resolver : CssModuleSupport.getSortedHelpResolvers(context)) {
                    String help = resolver.getHelp(context, property);
                    if (help == null) continue;
                    sb.append(help);
                }
                return sb.toString();
            }

            @Override
            public URL resolveLink(FileObject context, PropertyDefinition property, String link) {
                for (HelpResolver resolver : CssModuleSupport.getSortedHelpResolvers(context)) {
                    URL url = resolver.resolveLink(context, property, link);
                    if (url == null) continue;
                    return url;
                }
                return null;
            }

            @Override
            public int getPriority() {
                return 0;
            }
        };
    }

    private static Collection<HelpResolver> getSortedHelpResolvers(FileObject file) {
        ArrayList<HelpResolver> list = new ArrayList<HelpResolver>();
        for (CssEditorModule cssEditorModule : CssModuleSupport.getModules()) {
            Collection<HelpResolver> resolvers = cssEditorModule.getHelpResolvers(file);
            if (resolvers == null) continue;
            list.addAll(resolvers);
        }
        Collections.sort(list, new Comparator<HelpResolver>(){

            @Override
            public int compare(HelpResolver t1, HelpResolver t2) {
                int i1 = t1.getPriority();
                int i2 = t2.getPriority();
                return Integer.valueOf(i1).compareTo(i2);
            }
        });
        return list;
    }
}

