/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.core.api.support.progress;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.j2ee.core.utilities.ProgressPanel;
import org.openide.util.Mutex;
import org.openide.util.Parameters;
import org.openide.util.RequestProcessor;

public final class ProgressSupport {
    private static final Logger LOGGER = Logger.getLogger(ProgressSupport.class.getName());

    private ProgressSupport() {
    }

    public static void invoke(Collection<? extends Action> actions) {
        ProgressSupport.invoke(actions, false);
    }

    public static boolean invoke(Collection<? extends Action> actions, boolean cancellable) {
        Parameters.notNull((CharSequence)"actions", actions);
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("This method must be called in the event thread.");
        }
        return new ActionInvoker(new ArrayList<Action>(actions), cancellable).invoke();
    }

    public static abstract class BackgroundAction
    extends Action {
        private final boolean cancellable;

        public BackgroundAction() {
            this(false);
        }

        public BackgroundAction(boolean cancellable) {
            this.cancellable = cancellable;
        }

        @Override
        public final boolean isBackground() {
            return true;
        }

        @Override
        protected final boolean isCancellable() {
            return this.cancellable;
        }
    }

    public static abstract class EventThreadAction
    extends Action {
        private final boolean cancellable;

        public EventThreadAction() {
            this(false);
        }

        public EventThreadAction(boolean cancellable) {
            this.cancellable = cancellable;
        }

        @Override
        public final boolean isBackground() {
            return false;
        }

        @Override
        protected final boolean isCancellable() {
            return this.cancellable;
        }
    }

    public static abstract class Action {
        protected abstract boolean isBackground();

        protected boolean isEnabled() {
            return true;
        }

        protected abstract void run(Context var1);

        protected boolean isCancellable() {
            return false;
        }

        protected boolean cancel() {
            return true;
        }
    }

    public static final class Context {
        private final ProgressPanel panel;
        private final ProgressHandle handle;

        private Context(ProgressPanel panel, ProgressHandle handle) {
            this.panel = panel;
            this.handle = handle;
        }

        public void switchToDeterminate(int workunits) {
            this.handle.switchToDeterminate(workunits);
        }

        public void progress(final String message) {
            Mutex.EVENT.readAccess(new Runnable(){

                @Override
                public void run() {
                    panel.setText(message);
                }
            });
            this.handle.progress(message);
        }

        public void progress(int workunit) {
            this.handle.progress(workunit);
        }

        ProgressPanel getPanel() {
            return this.panel;
        }
    }

    private static final class ActionInvoker
    implements ActionListener {
        private final RequestProcessor rp = new RequestProcessor("ProgressSupport", 1);
        private final List<Action> actions;
        private final boolean cancellable;
        private volatile Context actionContext;
        private AtomicInteger nextActionIndex = new AtomicInteger();
        private volatile Action currentAction;
        private volatile boolean cancelled;

        public ActionInvoker(List<Action> actions, boolean cancellable) {
            this.actions = actions;
            this.cancellable = cancellable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean invoke() {
            assert (SwingUtilities.isEventDispatchThread());
            final ProgressPanel progressPanel = new ProgressPanel();
            progressPanel.setCancelVisible(this.cancellable);
            progressPanel.addCancelActionListener(this);
            ProgressHandle progressHandle = ProgressHandleFactory.createHandle(null);
            JComponent progressComponent = ProgressHandleFactory.createProgressComponent((ProgressHandle)progressHandle);
            progressHandle.start();
            progressHandle.switchToIndeterminate();
            this.actionContext = new Context(progressPanel, progressHandle);
            final AtomicReference<Throwable> exceptionRef = new AtomicReference<Throwable>();
            RequestProcessor.Task task = this.rp.create(new Runnable(){

                @Override
                public void run() {
                    try {
                        this.invokeNextActionsOfSameKind();
                    }
                    catch (Throwable t) {
                        try {
                            exceptionRef.set(t);
                        }
                        catch (Throwable throwable) {
                            SwingUtilities.invokeLater(new Runnable(this){
                                final /* synthetic */ 1 this$1;
                                {
                                    this.this$1 = this$1;
                                }

                                @Override
                                public void run() {
                                    this.this$1.progressPanel.close();
                                }
                            });
                            throw throwable;
                        }
                        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                    }
                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                }
            });
            try {
                boolean runInEDT = true;
                while (this.nextActionIndex.get() < this.actions.size() && !this.cancelled) {
                    if (runInEDT) {
                        try {
                            this.invokeNextActionsOfSameKind();
                        }
                        catch (Throwable t) {
                            exceptionRef.set(t);
                        }
                    } else {
                        task.schedule(0);
                        progressPanel.open(progressComponent);
                        task.waitFinished();
                    }
                    Throwable exception = (Throwable)exceptionRef.get();
                    if (exception != null) {
                        if (exception instanceof RuntimeException) {
                            throw (RuntimeException)exception;
                        }
                        RuntimeException re = new RuntimeException(exception.getMessage());
                        re.initCause(exception);
                        throw re;
                    }
                    runInEDT = !runInEDT;
                }
            }
            finally {
                progressHandle.finish();
            }
            return !this.cancelled;
        }

        private void invokeNextActionsOfSameKind() {
            int currentActionIndex;
            boolean isBackground;
            boolean bl = isBackground = !SwingUtilities.isEventDispatchThread();
            while (!this.cancelled && (currentActionIndex = this.nextActionIndex.get()) < this.actions.size()) {
                this.currentAction = this.actions.get(currentActionIndex);
                if (!this.currentAction.isEnabled()) {
                    this.nextActionIndex.incrementAndGet();
                    LOGGER.log(Level.FINE, "Skipping " + this.currentAction);
                    continue;
                }
                if (this.currentAction.isBackground() != isBackground) break;
                LOGGER.log(Level.FINE, "Running " + this.currentAction);
                if (isBackground) {
                    final boolean cancelEnabled = this.currentAction.isCancellable();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            actionContext.getPanel().setCancelEnabled(cancelEnabled);
                        }
                    });
                }
                this.currentAction.run(this.actionContext);
                this.nextActionIndex.incrementAndGet();
            }
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (this.cancelled) {
                return;
            }
            Action action = this.currentAction;
            if (action == null) {
                return;
            }
            if (!(action.isEnabled() && action.isBackground() && action.isCancellable())) {
                return;
            }
            this.cancelled = action.cancel();
            if (this.cancelled) {
                this.actionContext.getPanel().setCancelEnabled(false);
            }
        }
    }
}

