/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class ListUserGroupMembershipsRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private String userId;
    private String groupId;
    private String page;
    private Integer limit;

    @ConstructorProperties(value={"compartmentId", "userId", "groupId", "page", "limit"})
    ListUserGroupMembershipsRequest(String compartmentId, String userId, String groupId, String page, Integer limit) {
        this.compartmentId = compartmentId;
        this.userId = userId;
        this.groupId = groupId;
        this.page = page;
        this.limit = limit;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).userId(this.userId).groupId(this.groupId).page(this.page).limit(this.limit);
    }

    public String toString() {
        return "ListUserGroupMembershipsRequest(super=" + super.toString() + ", compartmentId=" + this.getCompartmentId() + ", userId=" + this.getUserId() + ", groupId=" + this.getGroupId() + ", page=" + this.getPage() + ", limit=" + this.getLimit() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListUserGroupMembershipsRequest)) {
            return false;
        }
        ListUserGroupMembershipsRequest other = (ListUserGroupMembershipsRequest)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$limit = this.getLimit();
        Integer other$limit = other.getLimit();
        if (this$limit == null ? other$limit != null : !((Object)this$limit).equals(other$limit)) {
            return false;
        }
        String this$compartmentId = this.getCompartmentId();
        String other$compartmentId = other.getCompartmentId();
        if (this$compartmentId == null ? other$compartmentId != null : !this$compartmentId.equals(other$compartmentId)) {
            return false;
        }
        String this$userId = this.getUserId();
        String other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$page = this.getPage();
        String other$page = other.getPage();
        return !(this$page == null ? other$page != null : !this$page.equals(other$page));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ListUserGroupMembershipsRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $limit = this.getLimit();
        result = result * 59 + ($limit == null ? 43 : ((Object)$limit).hashCode());
        String $compartmentId = this.getCompartmentId();
        result = result * 59 + ($compartmentId == null ? 43 : $compartmentId.hashCode());
        String $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $page = this.getPage();
        result = result * 59 + ($page == null ? 43 : $page.hashCode());
        return result;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getPage() {
        return this.page;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public static class Builder
    implements BmcRequest.Builder<ListUserGroupMembershipsRequest, Void> {
        private String compartmentId;
        private String userId;
        private String groupId;
        private String page;
        private Integer limit;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListUserGroupMembershipsRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.userId(o.getUserId());
            this.groupId(o.getGroupId());
            this.page(o.getPage());
            this.limit(o.getLimit());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListUserGroupMembershipsRequest build() {
            ListUserGroupMembershipsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public ListUserGroupMembershipsRequest buildWithoutInvocationCallback() {
            return new ListUserGroupMembershipsRequest(this.compartmentId, this.userId, this.groupId, this.page, this.limit);
        }

        public String toString() {
            return "ListUserGroupMembershipsRequest.Builder(compartmentId=" + this.compartmentId + ", userId=" + this.userId + ", groupId=" + this.groupId + ", page=" + this.page + ", limit=" + this.limit + ")";
        }
    }
}

