/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.database.model.DatabaseSoftwareImage;
import com.oracle.bmc.database.requests.UpdateDatabaseSoftwareImageRequest;
import com.oracle.bmc.database.responses.UpdateDatabaseSoftwareImageResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateDatabaseSoftwareImageConverter {
    private static final Logger LOG = LoggerFactory.getLogger(UpdateDatabaseSoftwareImageConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static UpdateDatabaseSoftwareImageRequest interceptRequest(UpdateDatabaseSoftwareImageRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, UpdateDatabaseSoftwareImageRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getDatabaseSoftwareImageId(), (String)"databaseSoftwareImageId must not be blank", (Object[])new Object[0]);
        Validate.notNull((Object)request.getUpdateDatabaseSoftwareImageDetails(), (String)"updateDatabaseSoftwareImageDetails is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20160918").path("databaseSoftwareImages").path(HttpUtils.encodePathSegment((String)request.getDatabaseSoftwareImageId()));
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getIfMatch() != null) {
            ib.header("if-match", (Object)request.getIfMatch());
        }
        if (client.getClientConfigurator() != null) {
            client.getClientConfigurator().customizeRequest((BmcRequest)request, ib);
        }
        return ib;
    }

    public static Function<Response, UpdateDatabaseSoftwareImageResponse> fromResponse() {
        Function<Response, UpdateDatabaseSoftwareImageResponse> transformer = new Function<Response, UpdateDatabaseSoftwareImageResponse>(){

            public UpdateDatabaseSoftwareImageResponse apply(Response rawResponse) {
                Optional opcRequestIdHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.database.responses.UpdateDatabaseSoftwareImageResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(DatabaseSoftwareImage.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                UpdateDatabaseSoftwareImageResponse.Builder builder = UpdateDatabaseSoftwareImageResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.databaseSoftwareImage((DatabaseSoftwareImage)response.getItem());
                Optional etagHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"etag");
                if (etagHeader.isPresent()) {
                    builder.etag((String)HeaderUtils.toValue((String)"etag", (String)((String)((List)etagHeader.get()).get(0)), String.class));
                }
                if ((opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id")).isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                UpdateDatabaseSoftwareImageResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

