/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.auth.internal;

import com.google.common.base.Optional;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import com.oracle.bmc.auth.SessionKeySupplier;
import com.oracle.bmc.auth.internal.AuthUtils;
import java.security.interfaces.RSAPublicKey;
import java.text.ParseException;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SecurityTokenAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(SecurityTokenAdapter.class);
    private final JWTClaimsSet jwt;
    private final SessionKeySupplier sessionKeySupplier;
    private final String securityToken;

    SecurityTokenAdapter(String securityToken, SessionKeySupplier sessionKeySupplier) {
        this.securityToken = securityToken;
        this.jwt = securityToken == null || securityToken.isEmpty() ? null : this.parse(securityToken);
        this.sessionKeySupplier = sessionKeySupplier;
    }

    private JWTClaimsSet parse(String token) {
        try {
            SignedJWT signedJWT = SignedJWT.parse((String)token);
            if (signedJWT.getSignature().toString().isEmpty()) {
                throw new IllegalArgumentException("The token doesn't have a signature");
            }
            return signedJWT.getJWTClaimsSet();
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("The token does not conform to signed JWT format. " + e.getMessage());
        }
    }

    boolean isValid() {
        if (this.jwt == null) {
            LOG.debug("Security token is not valid.");
            return false;
        }
        try {
            Date exp = this.jwt.getExpirationTime();
            if (exp != null && exp.after(new Date())) {
                Optional<RSAPublicKey> jwkRsa;
                LOG.debug("Security token is not expired");
                String jwk = this.jwt.getStringClaim("jwk");
                if (jwk != null && (jwkRsa = AuthUtils.toPublicKeyFromJson(jwk)).isPresent() && this.isEqualPublicKey((RSAPublicKey)jwkRsa.get(), (RSAPublicKey)this.sessionKeySupplier.getKeyPair().getPublic())) {
                    LOG.debug("Security token is still valid. Public key matches with the JWK.");
                    return true;
                }
            }
        }
        catch (IllegalArgumentException e) {
            LOG.debug("JWT parsing failed");
            return false;
        }
        catch (ParseException e) {
            LOG.debug("JWT parsing failed");
            return false;
        }
        return false;
    }

    private boolean isEqualPublicKey(RSAPublicKey a, RSAPublicKey b) {
        if (a == null || b == null) {
            throw new IllegalArgumentException("Public key cannot be null");
        }
        String encodedKey1 = AuthUtils.base64EncodeNoChunking(a);
        String encodedKey2 = AuthUtils.base64EncodeNoChunking(b);
        return encodedKey1.equals(encodedKey2);
    }

    public String getStringClaim(String key) {
        if (this.jwt == null) {
            LOG.debug("Security token is not valid.");
            return null;
        }
        try {
            return this.jwt.getStringClaim(key);
        }
        catch (ParseException e) {
            throw new IllegalStateException("JWT parsing failed");
        }
    }

    public String getSecurityToken() {
        return this.securityToken;
    }
}

