/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientRuntime {
    private static final Logger LOG = LoggerFactory.getLogger(ClientRuntime.class);
    private static String clientUserAgent;
    private final String userAgent;
    private final String clientInfo;
    private static final String ENV_VAR_USER_AGENT = "OCI_SDK_APPEND_USER_AGENT";

    private ClientRuntime() {
        String os = System.getProperty("os.name");
        String osVersion = System.getProperty("os.version");
        String javaVersion = System.getProperty("java.version");
        String javaVmName = System.getProperty("java.vm.name");
        String javaVmVersion = System.getProperty("java.vm.version");
        String sdkVersion = this.sdkVersion();
        String userAgentFromEnvVar = System.getenv(ENV_VAR_USER_AGENT);
        String ociSdkAppendUserAgent = StringUtils.isBlank((CharSequence)userAgentFromEnvVar) ? "" : " " + userAgentFromEnvVar.trim();
        String clientInfoFormat = "Oracle-JavaSDK/%s";
        this.clientInfo = String.format("Oracle-JavaSDK/%s", sdkVersion);
        String additionalUserAgentFromClient = clientUserAgent != null && !clientUserAgent.trim().isEmpty() ? " " + clientUserAgent.trim() : "";
        String agentFormat = "%s (%s/%s; Java/%s; %s/%s)%s%s";
        this.userAgent = String.format("%s (%s/%s; Java/%s; %s/%s)%s%s", this.clientInfo, os, osVersion, javaVersion, javaVmName, javaVmVersion, additionalUserAgentFromClient, ociSdkAppendUserAgent);
        LOG.info("Using SDK: {}", (Object)this.clientInfo);
        LOG.info("User agent set to: {}", (Object)this.userAgent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String sdkVersion() {
        InputStream propertyStream = this.getClass().getClassLoader().getResourceAsStream("com/oracle/bmc/sdk.properties");
        Properties properties = new Properties();
        try {
            properties.load(propertyStream);
        }
        catch (Exception e) {
            LOG.error("Failed to load sdk.properties", (Throwable)e);
            String string = "Unknown";
            return string;
        }
        finally {
            try {
                propertyStream.close();
            }
            catch (IOException e) {
                LOG.warn("Failed to close property stream correctly", (Throwable)e);
            }
        }
        return properties.getProperty("sdk.version");
    }

    public static ClientRuntime getRuntime() {
        return RuntimeInstance.INSTANCE;
    }

    public static void setClientUserAgent(String clientUserAgent) {
        ClientRuntime.clientUserAgent = clientUserAgent;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public String getClientInfo() {
        return this.clientInfo;
    }

    private static class RuntimeInstance {
        private static final ClientRuntime INSTANCE = new ClientRuntime();

        private RuntimeInstance() {
        }
    }
}

