/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.jdk;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.modules.java.hints.jdk.Bundle;
import org.netbeans.modules.java.hints.suggestions.ExpandEnhancedForLoop;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.JavaFix;

public class ConvertVarToExplicitType {
    public static ErrorDescription convertVarToExplicitType(HintContext ctx) {
        if (!ConvertVarToExplicitType.isLocalVarType(ctx)) {
            return null;
        }
        TreePath treePath = ctx.getPath();
        if (ctx.getInfo().getTreeUtilities().hasError(treePath.getLeaf(), new String[0])) {
            return null;
        }
        if (!ConvertVarToExplicitType.isValidType(ctx)) {
            return null;
        }
        return ErrorDescriptionFactory.forTree((HintContext)ctx, (TreePath)ctx.getPath(), (String)Bundle.MSG_ConvertibleToExplicitType(), (Fix[])new Fix[]{new JavaFixImpl(ctx.getInfo(), ctx.getPath()).toEditorFix()});
    }

    private static boolean isLocalVarType(HintContext ctx) {
        CompilationInfo info = ctx.getInfo();
        TreePath treePath = ctx.getPath();
        if (!ConvertVarToExplicitType.isVariableValidForVarHint(ctx)) {
            return false;
        }
        return info.getTreeUtilities().isVarType(treePath);
    }

    protected static boolean isVariableValidForVarHint(HintContext ctx) {
        CompilationInfo info = ctx.getInfo();
        TreePath treePath = ctx.getPath();
        if (info.getSourceVersion().compareTo(SourceVersion.RELEASE_9) < 1) {
            return false;
        }
        if (treePath.getLeaf().getKind() == Tree.Kind.ENHANCED_FOR_LOOP) {
            EnhancedForLoopTree efl = (EnhancedForLoopTree)treePath.getLeaf();
            TypeMirror expressionType = ctx.getInfo().getTrees().getTypeMirror(new TreePath(treePath, efl.getExpression()));
            if (!Utilities.isValidType(expressionType)) {
                return false;
            }
        } else {
            Element treePathELement = info.getTrees().getElement(treePath);
            if (treePathELement != null && treePathELement.getKind() != ElementKind.LOCAL_VARIABLE && treePathELement.getKind() != ElementKind.RESOURCE_VARIABLE) {
                return false;
            }
        }
        return true;
    }

    private static boolean isValidType(HintContext ctx) {
        TreePath treePath = ctx.getPath();
        TreePath initTreePath = (TreePath)ctx.getVariables().get("$init");
        TreePath expressionTreePath = (TreePath)ctx.getVariables().get("$expression");
        if (initTreePath != null) {
            DeclaredType dt;
            TypeMirror variableTypeMirror = ctx.getInfo().getTrees().getElement(treePath).asType();
            if (Utilities.isAnonymousType(variableTypeMirror)) {
                return false;
            }
            if (variableTypeMirror.getKind() == TypeKind.DECLARED && (dt = (DeclaredType)variableTypeMirror).getTypeArguments().size() > 0) {
                for (TypeMirror typeMirror : dt.getTypeArguments()) {
                    if (!Utilities.isAnonymousType(typeMirror)) continue;
                    return false;
                }
            }
            return Utilities.isValidType(variableTypeMirror) && variableTypeMirror.getKind() != TypeKind.INTERSECTION;
        }
        if (expressionTreePath != null) {
            ExecutableElement iterator = ExpandEnhancedForLoop.findIterable(ctx.getInfo());
            return iterator != null;
        }
        return false;
    }

    private static final class JavaFixImpl
    extends JavaFix {
        public JavaFixImpl(CompilationInfo info, TreePath tp) {
            super(info, tp);
        }

        protected String getText() {
            return Bundle.FIX_convertVarToExplicitType();
        }

        protected void performRewrite(JavaFix.TransformationContext tc) throws Exception {
            WorkingCopy wc = tc.getWorkingCopy();
            CompilationUnitTree cut = wc.getCompilationUnit();
            TreePath statementPath = tc.getPath();
            TreeMaker make = wc.getTreeMaker();
            if (statementPath.getLeaf().getKind() == Tree.Kind.VARIABLE) {
                VariableTree oldVariableTree = (VariableTree)statementPath.getLeaf();
                TypeMirror type = wc.getTrees().getTypeMirror(statementPath);
                VariableTree newVariableTree = make.Variable(oldVariableTree.getModifiers(), (CharSequence)oldVariableTree.getName(), make.Type(type), oldVariableTree.getInitializer());
                wc.rewrite((Tree)oldVariableTree, (Tree)newVariableTree);
            } else if (statementPath.getLeaf().getKind() == Tree.Kind.ENHANCED_FOR_LOOP) {
                EnhancedForLoopTree elfTree = (EnhancedForLoopTree)statementPath.getLeaf();
                ExpressionTree expTree = elfTree.getExpression();
                VariableTree vtt = elfTree.getVariable();
                String elfTreeVariable = elfTree.getVariable().getType().toString();
                if (expTree == null) {
                    return;
                }
                VariableTree newVariableTree = make.Variable(vtt.getModifiers(), (CharSequence)vtt.getName(), make.Type(elfTreeVariable), null);
                StatementTree statement = ((EnhancedForLoopTree)statementPath.getLeaf()).getStatement();
                EnhancedForLoopTree newElfTree = make.EnhancedForLoop(newVariableTree, expTree, statement);
                wc.rewrite((Tree)elfTree, (Tree)newElfTree);
            }
        }
    }
}

