/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.api.jaxws.wsdlmodel;

import com.sun.tools.ws.processor.model.Model;
import com.sun.tools.ws.processor.modeler.wsdl.WSDLModeler;
import com.sun.tools.ws.wscompile.AbortException;
import com.sun.tools.ws.wscompile.BadCommandLineException;
import com.sun.tools.ws.wscompile.ErrorReceiver;
import com.sun.tools.ws.wscompile.WsimportOptions;
import com.sun.tools.ws.wsdl.parser.InternalizationLogic;
import com.sun.tools.ws.wsdl.parser.MetadataFinder;
import com.sun.tools.ws.wsdl.parser.WSDLInternalizationLogic;
import com.sun.xml.ws.util.JAXWSUtils;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.xml.resolver.NbCatalogManager;
import org.apache.xml.resolver.tools.NbCatalogResolver;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlChangeListener;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlErrorHandler;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModel;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModelListener;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

public class WsdlModeler {
    private WsdlModel wsdlModel;
    private WSDLModeler ideWSDLModeler;
    private URL wsdlUrl;
    private URL[] bindings;
    private URL catalog;
    private EntityResolver entityResolver;
    private Set<String> bindingFiles;
    private String packageName;
    private final List<WsdlModelListener> modelListeners;
    private List<WsdlChangeListener> wsdlChangeListeners;
    RequestProcessor.Task task;
    int listenersSize;
    protected Properties properties;
    private Throwable creationException;

    WsdlModeler(URL wsdlUrl) {
        this.wsdlUrl = wsdlUrl;
        this.modelListeners = Collections.synchronizedList(new ArrayList());
        this.wsdlChangeListeners = new ArrayList<WsdlChangeListener>();
        this.task = new RequestProcessor("WsdlModeler-request-processor").create(new Runnable(){

            @Override
            public void run() {
                WsdlModeler.this.generateWsdlModel();
                WsdlModeler.this.fireModelCreated(WsdlModeler.this.wsdlModel);
            }
        }, true);
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setJAXBBindings(URL[] bindings) {
        this.bindings = bindings;
    }

    public URL[] getJAXBBindings() {
        return this.bindings;
    }

    public void setCatalog(URL catalog) {
        this.catalog = catalog;
    }

    public URL getCatalog() {
        return this.catalog;
    }

    void setWsdlUrl(URL url) {
        this.wsdlUrl = url;
    }

    public URL getWsdlUrl() {
        return this.wsdlUrl;
    }

    public Throwable getCreationException() {
        return this.creationException;
    }

    public WsdlModel getWsdlModel() {
        return this.wsdlModel;
    }

    public WsdlModel getAndWaitForWsdlModel() {
        return this.getAndWaitForWsdlModel(false);
    }

    public WsdlModel getAndWaitForWsdlModel(boolean forceReload) {
        if (forceReload || this.getWsdlModel() == null) {
            this.generateWsdlModel();
        }
        return this.wsdlModel;
    }

    public void generateWsdlModel(WsdlModelListener listener, final WsdlErrorHandler errorHandler) {
        RequestProcessor.Task task1 = RequestProcessor.getDefault().create(new Runnable(){

            @Override
            public void run() {
                WsdlModeler.this.generateWsdlModel(errorHandler);
                WsdlModeler.this.fireModelCreated(WsdlModeler.this.wsdlModel);
            }
        }, true);
        this.addWsdlModelListener(listener);
        task1.run();
    }

    public void generateWsdlModel(WsdlModelListener listener) {
        this.generateWsdlModel(listener, false);
    }

    public void generateWsdlModel(WsdlModelListener listener, boolean forceReload) {
        if (forceReload) {
            try {
                this.task.waitFinished(10000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.addWsdlModelListener(listener);
            this.task.schedule(100);
        } else {
            this.addWsdlModelListener(listener);
            this.task.schedule(100);
        }
    }

    private void generateWsdlModel() {
        this.generateWsdlModel(new CatchFirstErrorHandler());
    }

    private void generateWsdlModel(WsdlErrorHandler errorHandler) {
        WsimportOptions options = new WsimportOptions();
        this.properties = new Properties();
        this.bindingFiles = new HashSet<String>();
        if (this.bindings != null) {
            for (int i = 0; i < this.bindings.length; ++i) {
                try {
                    options.addBindings(JAXWSUtils.absolutize((String)this.bindings[i].toExternalForm()));
                    continue;
                }
                catch (BadCommandLineException ex) {
                    Logger.getLogger(this.getClass().getName()).log(Level.FINE, "WsdlModeler.generateWsdlModel", ex);
                }
            }
        }
        try {
            if (this.wsdlUrl.toExternalForm().startsWith("http://") || this.wsdlUrl.toExternalForm().startsWith("https://")) {
                InputSource source = new InputSource(this.wsdlUrl.toExternalForm());
                options.addWSDL(source);
            } else {
                options.addWSDL(new File(this.wsdlUrl.getFile()));
            }
            options.compatibilityMode = 2;
            if (this.packageName != null) {
                options.defaultPackage = this.packageName;
            }
            if (this.catalog != null) {
                NbCatalogManager manager = new NbCatalogManager(null);
                manager.setCatalogFiles(this.catalog.toExternalForm());
                manager.setUseStaticCatalog(false);
                manager.setVerbosity(4);
                options.entityResolver = this.entityResolver = new NbCatalogResolver(manager);
            }
            options.parseBindings((ErrorReceiver)new IdeErrorReceiver(errorHandler));
            IdeErrorReceiver ideErrorReceiver = new IdeErrorReceiver(errorHandler);
            MetadataFinder finder = new MetadataFinder((InternalizationLogic)new WSDLInternalizationLogic(), options, (ErrorReceiver)ideErrorReceiver);
            finder.parseWSDL();
            this.ideWSDLModeler = new WSDLModeler(options, (ErrorReceiver)ideErrorReceiver, finder);
            Model tmpModel = this.ideWSDLModeler.buildModel();
            if (tmpModel != null) {
                WsdlModel oldWsdlModel = this.wsdlModel;
                this.wsdlModel = new WsdlModel(tmpModel);
                this.fireWsdlModelChanged(oldWsdlModel, this.wsdlModel);
                this.creationException = null;
            } else {
                WsdlModel oldWsdlModel = this.wsdlModel;
                this.wsdlModel = null;
                if (oldWsdlModel != null) {
                    this.fireWsdlModelChanged(oldWsdlModel, null);
                }
                SAXParseException parseError = null;
                if (errorHandler instanceof CatchFirstErrorHandler) {
                    parseError = ((CatchFirstErrorHandler)errorHandler).getFirstError();
                    this.creationException = parseError;
                }
                if (parseError == null) {
                    this.creationException = new Exception(NbBundle.getMessage(WsdlModeler.class, (String)"ERR_CannotGenerateModel", (Object)this.wsdlUrl.toExternalForm()));
                }
                Logger.getLogger(this.getClass().getName()).log(Level.FINE, "WsdlModeler.generateWsdlModel", this.creationException);
            }
        }
        catch (Throwable ex) {
            this.wsdlModel = null;
            SAXParseException parseError = null;
            if (errorHandler instanceof CatchFirstErrorHandler) {
                parseError = ((CatchFirstErrorHandler)errorHandler).getFirstError();
                this.creationException = parseError;
            }
            if (parseError == null) {
                this.creationException = ex;
            }
            Logger.getLogger(this.getClass().getName()).log(Level.FINE, "WsdlModeler.generateWsdlModel", ex);
        }
    }

    private synchronized void addWsdlModelListener(WsdlModelListener listener) {
        if (listener != null) {
            this.modelListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireModelCreated(WsdlModel model) {
        Object object = this.modelListeners;
        synchronized (object) {
            for (WsdlModelListener l : this.modelListeners) {
                l.modelCreated(model);
            }
        }
        object = this;
        synchronized (object) {
            this.modelListeners.clear();
        }
    }

    public synchronized void addWsdlChangeListener(WsdlChangeListener wsdlChangeListener) {
        this.wsdlChangeListeners.add(wsdlChangeListener);
    }

    public synchronized void removeWsdlChangeListener(WsdlChangeListener wsdlChangeListener) {
        this.wsdlChangeListeners.remove(wsdlChangeListener);
    }

    private void fireWsdlModelChanged(WsdlModel oldWsdlModel, WsdlModel newWsdlModel) {
        for (WsdlChangeListener wsdlChangeListener : this.wsdlChangeListeners) {
            wsdlChangeListener.wsdlModelChanged(oldWsdlModel, newWsdlModel);
        }
    }

    private static class CatchFirstErrorHandler
    implements WsdlErrorHandler {
        private SAXParseException firstError;

        private CatchFirstErrorHandler() {
        }

        @Override
        public void warning(SAXParseException ex) throws WsdlErrorHandler.AbortException {
        }

        @Override
        public void info(SAXParseException ex) {
        }

        @Override
        public void fatalError(SAXParseException ex) throws WsdlErrorHandler.AbortException {
            if (this.firstError == null) {
                this.firstError = ex;
            }
        }

        @Override
        public void error(SAXParseException ex) throws WsdlErrorHandler.AbortException {
            if (this.firstError == null) {
                this.firstError = ex;
            }
        }

        public SAXParseException getFirstError() {
            return this.firstError;
        }
    }

    private static class IdeErrorReceiver
    extends ErrorReceiver {
        private WsdlErrorHandler errorHandler;

        IdeErrorReceiver(WsdlErrorHandler errorHandler) {
            this.errorHandler = errorHandler;
        }

        public void error(Exception excptn) {
            super.error(excptn);
        }

        public void warning(SAXParseException ex) throws AbortException {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.FINE, "WsdlModeler.generateWsdlModel", ex);
            if (this.errorHandler != null) {
                try {
                    this.errorHandler.warning(ex);
                }
                catch (WsdlErrorHandler.AbortException abort) {
                    AbortException newEx = new AbortException();
                    newEx.initCause((Throwable)abort);
                    throw newEx;
                }
            }
        }

        public void info(SAXParseException ex) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.FINE, "WsdlModeler.generateWsdlModel", ex);
            if (this.errorHandler != null) {
                this.errorHandler.info(ex);
            }
        }

        public void fatalError(SAXParseException ex) throws AbortException {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.FINE, "WsdlModeler.generateWsdlModel", ex);
            if (this.errorHandler != null) {
                try {
                    this.errorHandler.fatalError(ex);
                }
                catch (WsdlErrorHandler.AbortException abort) {
                    AbortException newEx = new AbortException();
                    newEx.initCause((Throwable)abort);
                    throw newEx;
                }
            }
        }

        public void error(SAXParseException ex) throws AbortException {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.FINE, "WsdlModeler.generateWsdlModel", ex);
            if (this.errorHandler != null) {
                try {
                    this.errorHandler.error(ex);
                }
                catch (WsdlErrorHandler.AbortException abort) {
                    AbortException newEx = new AbortException();
                    newEx.initCause((Throwable)abort);
                    throw newEx;
                }
            }
        }

        public void debug(SAXParseException ex) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.FINE, "WsdlModeler.generateWsdlModel", ex);
            if (this.errorHandler != null) {
                this.errorHandler.info(ex);
            }
        }
    }
}

