/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.verification;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.csl.api.Error;
import org.netbeans.modules.csl.spi.support.CancelSupport;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.ArrayCreation;
import org.netbeans.modules.php.editor.parser.astnodes.ArrayElement;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.ListVariable;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;
import org.netbeans.modules.php.editor.verification.Bundle;
import org.netbeans.modules.php.editor.verification.PHPRuleContext;
import org.netbeans.modules.php.editor.verification.UnhandledErrorRule;
import org.netbeans.modules.php.editor.verification.VerificationError;
import org.openide.filesystems.FileObject;

public class IncorrectListUnhandledError
extends UnhandledErrorRule {
    public String getDisplayName() {
        return Bundle.IncorrectListUnhandledError_displayName();
    }

    @Override
    public void invoke(PHPRuleContext context, List<Error> result) {
        FileObject fileObject;
        PHPParseResult phpParseResult = (PHPParseResult)context.parserResult;
        if (phpParseResult.getProgram() != null && (fileObject = phpParseResult.getSnapshot().getSource().getFileObject()) != null) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            CheckVisitor checkVisitor = new CheckVisitor(fileObject);
            phpParseResult.getProgram().accept(checkVisitor);
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            result.addAll(checkVisitor.getErrors());
        }
    }

    private static final class IncorrectList
    extends VerificationError {
        private static final String KEY = "Php.List.Syntax.Mixed";

        IncorrectList(FileObject fileObject, int startOffset, int endOffset) {
            super(fileObject, startOffset, endOffset);
        }

        public String getDisplayName() {
            return Bundle.IncorrectListUnhandledError_displayName();
        }

        public String getDescription() {
            return Bundle.IncorrectList_description();
        }

        public String getKey() {
            return KEY;
        }
    }

    private static final class CheckVisitor
    extends DefaultVisitor {
        private final List<VerificationError> errors = new ArrayList<VerificationError>();
        private final FileObject fileObject;

        CheckVisitor(FileObject fileObject) {
            assert (fileObject != null);
            this.fileObject = fileObject;
        }

        List<VerificationError> getErrors() {
            return Collections.unmodifiableList(this.errors);
        }

        @Override
        public void visit(ListVariable node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            ListVariable.SyntaxType type = node.getSyntaxType();
            List<ArrayElement> elements = node.getElements();
            this.checkMixedList(elements, null, type, true);
        }

        private void checkMixedList(List<ArrayElement> elements, Expression key, ListVariable.SyntaxType firstSyntaxType, boolean root) {
            Expression firstKey = key;
            boolean first = root;
            for (ArrayElement element : elements) {
                if (CancelSupport.getDefault().isCancelled()) {
                    return;
                }
                if (first) {
                    first = false;
                } else if (firstKey != null && element.getKey() == null || firstKey == null && element.getKey() != null) {
                    this.createError(element);
                    break;
                }
                firstKey = element.getKey();
                Expression value = element.getValue();
                if (value instanceof ListVariable) {
                    ListVariable listVariable = (ListVariable)value;
                    if (firstSyntaxType != listVariable.getSyntaxType()) {
                        this.createError(listVariable);
                        break;
                    }
                    this.checkMixedList(listVariable.getElements(), firstKey, firstSyntaxType, false);
                    continue;
                }
                if (!(value instanceof ArrayCreation)) continue;
                ArrayCreation arrayCreation = (ArrayCreation)value;
                if (firstSyntaxType != this.getType(arrayCreation.getType())) {
                    this.createError(arrayCreation);
                    break;
                }
                this.checkMixedList(arrayCreation.getElements(), firstKey, firstSyntaxType, false);
            }
        }

        private ListVariable.SyntaxType getType(ArrayCreation.Type type) {
            return type == ArrayCreation.Type.NEW ? ListVariable.SyntaxType.NEW : ListVariable.SyntaxType.OLD;
        }

        private void createError(ASTNode node) {
            this.createError(node.getStartOffset(), node.getEndOffset());
        }

        private void createError(int startOffset, int endOffset) {
            this.errors.add(new IncorrectList(this.fileObject, startOffset, endOffset));
        }
    }
}

