/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.polyglot;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Objects;
import org.graalvm.polyglot.Engine;
import org.graalvm.polyglot.SourceSection;
import org.graalvm.polyglot.impl.AbstractPolyglotImpl;
import org.graalvm.polyglot.io.ByteSequence;

public final class Source {
    private static volatile AbstractPolyglotImpl.AbstractSourceImpl IMPL;
    final Object impl;
    private static final Source EMPTY;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static AbstractPolyglotImpl.AbstractSourceImpl getImpl() {
        if (IMPL != null) return IMPL;
        Class<Engine> clazz = Engine.class;
        synchronized (Engine.class) {
            if (IMPL != null) return IMPL;
            IMPL = Engine.getImpl().getSourceImpl();
            SourceSection.IMPL = Engine.getImpl().getSourceSectionImpl();
            // ** MonitorExit[var0] (shouldn't be in output)
            return IMPL;
        }
    }

    Source(Object impl) {
        this.impl = impl;
    }

    public String getLanguage() {
        return Source.getImpl().getLanguage(this.impl);
    }

    public String getName() {
        return Source.getImpl().getName(this.impl);
    }

    public String getPath() {
        return Source.getImpl().getPath(this.impl);
    }

    public URL getURL() {
        return Source.getImpl().getURL(this.impl);
    }

    public URI getURI() {
        return Source.getImpl().getURI(this.impl);
    }

    public boolean isInteractive() {
        return Source.getImpl().isInteractive(this.impl);
    }

    public boolean isInternal() {
        return Source.getImpl().isInternal(this.impl);
    }

    public Reader getReader() {
        return Source.getImpl().getReader(this.impl);
    }

    @Deprecated
    public InputStream getInputStream() {
        return Source.getImpl().getInputStream(this.impl);
    }

    public int getLength() {
        return Source.getImpl().getLength(this.impl);
    }

    public CharSequence getCharacters() {
        return Source.getImpl().getCharacters(this.impl);
    }

    public String getMimeType() {
        return Source.getImpl().getMimeType(this.impl);
    }

    public CharSequence getCharacters(int lineNumber) {
        return Source.getImpl().getCharacters(this.impl, lineNumber);
    }

    public ByteSequence getBytes() {
        return Source.getImpl().getBytes(this.impl);
    }

    public boolean hasCharacters() {
        return Source.getImpl().hasCharacters(this.impl);
    }

    public boolean hasBytes() {
        return Source.getImpl().hasBytes(this.impl);
    }

    public int getLineCount() {
        return Source.getImpl().getLineCount(this.impl);
    }

    public int getLineNumber(int offset) throws IllegalArgumentException {
        return Source.getImpl().getLineNumber(this.impl, offset);
    }

    public int getColumnNumber(int offset) throws IllegalArgumentException {
        return Source.getImpl().getColumnNumber(this.impl, offset);
    }

    public int getLineStartOffset(int lineNumber) throws IllegalArgumentException {
        return Source.getImpl().getLineStartOffset(this.impl, lineNumber);
    }

    public int getLineLength(int lineNumber) throws IllegalArgumentException {
        return Source.getImpl().getLineLength(this.impl, lineNumber);
    }

    public String toString() {
        return Source.getImpl().toString(this.impl);
    }

    public int hashCode() {
        return Source.getImpl().hashCode(this.impl);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Source)) {
            return false;
        }
        Object otherImpl = ((Source)obj).impl;
        return Source.getImpl().equals(this.impl, otherImpl);
    }

    public static Builder newBuilder(String language, CharSequence characters, String name) {
        Source source = EMPTY;
        source.getClass();
        return source.new Builder(language, characters).name(name);
    }

    public static Builder newBuilder(String language, ByteSequence bytes, String name) {
        Source source = EMPTY;
        source.getClass();
        return source.new Builder(language, bytes).name(name);
    }

    public static Builder newBuilder(String language, File file) {
        Source source = EMPTY;
        source.getClass();
        return source.new Builder(language, file);
    }

    public static Builder newBuilder(String language, URL url) {
        Source source = EMPTY;
        source.getClass();
        return source.new Builder(language, url);
    }

    public static Builder newBuilder(String language, Reader source, String name) {
        Source source2 = EMPTY;
        source2.getClass();
        return source2.new Builder(language, source).name(name);
    }

    public static Source create(String language, CharSequence source) {
        return Source.newBuilder(language, source, "Unnamed").buildLiteral();
    }

    public static String findLanguage(File file) throws IOException {
        return Source.getImpl().findLanguage(file);
    }

    public static String findLanguage(URL url) throws IOException {
        return Source.getImpl().findLanguage(url);
    }

    public static String findMimeType(File file) throws IOException {
        return Source.getImpl().findMimeType(file);
    }

    public static String findMimeType(URL url) throws IOException {
        return Source.getImpl().findMimeType(url);
    }

    public static String findLanguage(String mimeType) {
        return Source.getImpl().findLanguage(mimeType);
    }

    static <E extends Exception> RuntimeException silenceException(Class<E> type, Exception ex) throws E {
        throw ex;
    }

    private static void validateMimeType(String mimeType) {
        if (mimeType == null) {
            return;
        }
        int index = mimeType.indexOf(47);
        if (index == -1 || index == 0 || index == mimeType.length() - 1) {
            throw Source.invalidMimeType(mimeType);
        }
        if (mimeType.indexOf(47, index + 1) != -1) {
            throw Source.invalidMimeType(mimeType);
        }
    }

    private static IllegalArgumentException invalidMimeType(String mimeType) {
        return new IllegalArgumentException(String.format("Invalid MIME type '%s' provided. A MIME type consists of a type and a subtype separated by '/'.", mimeType));
    }

    static {
        EMPTY = new Source(null);
    }

    public class Builder {
        private final String language;
        private final Object origin;
        private URI uri;
        private String name;
        private boolean interactive;
        private boolean internal;
        private boolean cached = true;
        private Object content;
        private String mimeType;
        private Charset fileEncoding;

        Builder(String language, Object origin) {
            Objects.requireNonNull(language);
            Objects.requireNonNull(origin);
            this.language = language;
            this.origin = origin;
        }

        public Builder name(String newName) {
            this.name = newName;
            return this;
        }

        public Builder content(String code) {
            return this.content((CharSequence)code);
        }

        public Builder content(CharSequence characters) {
            Objects.requireNonNull(characters);
            this.content = characters;
            return this;
        }

        public Builder content(ByteSequence bytes) {
            Objects.requireNonNull(bytes);
            this.content = bytes;
            return this;
        }

        public Builder mimeType(String mimeType) {
            Source.validateMimeType(mimeType);
            this.mimeType = mimeType;
            return this;
        }

        public Builder interactive(boolean interactive) {
            this.interactive = interactive;
            return this;
        }

        public Builder internal(boolean internal) {
            this.internal = internal;
            return this;
        }

        public Builder cached(boolean cached) {
            this.cached = cached;
            return this;
        }

        public Builder uri(URI newUri) {
            Objects.requireNonNull(newUri);
            this.uri = newUri;
            return this;
        }

        public Builder encoding(Charset encoding) {
            this.fileEncoding = encoding;
            return this;
        }

        public Source build() throws IOException {
            Source source = Source.getImpl().build(this.language, this.origin, this.uri, this.name, this.mimeType, this.content, this.interactive, this.internal, this.cached, this.fileEncoding);
            if (source.hasBytes()) {
                this.content = source.getBytes();
            } else {
                assert (source.hasCharacters());
                this.content = source.getCharacters();
            }
            return source;
        }

        public Source buildLiteral() {
            try {
                return this.build();
            }
            catch (IOException e) {
                throw new AssertionError("No error expected.", e);
            }
        }
    }
}

