/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.js.lang.JavaScriptLanguage;
import com.oracle.truffle.js.runtime.GraalJSException;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSErrorType;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.builtins.JSError;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.Undefined;

public final class JSException
extends GraalJSException {
    private static final long serialVersionUID = -2139936643139844157L;
    private final JSErrorType type;
    private DynamicObject exceptionObj;
    private JSRealm realm;
    private boolean useCallerRealm;
    private final boolean isIncompleteSource;

    private JSException(JSErrorType type, String message, Throwable cause, Node originatingNode, JSRealm realm, int stackTraceLimit) {
        super(message, cause, originatingNode, stackTraceLimit);
        CompilerAsserts.neverPartOfCompilation((String)"JSException constructor");
        this.type = type;
        this.exceptionObj = null;
        this.realm = realm;
        this.isIncompleteSource = false;
    }

    private JSException(JSErrorType type, String message, Node originatingNode, DynamicObject exceptionObj, JSRealm realm, int stackTraceLimit) {
        super(message, originatingNode, stackTraceLimit);
        CompilerAsserts.neverPartOfCompilation((String)"JSException constructor");
        this.type = type;
        this.exceptionObj = exceptionObj;
        this.realm = realm;
        this.isIncompleteSource = false;
    }

    private JSException(JSErrorType type, String message, SourceSection sourceLocation, JSRealm realm, int stackTraceLimit, boolean isIncompleteSource) {
        super(message, sourceLocation, stackTraceLimit);
        CompilerAsserts.neverPartOfCompilation((String)"JSException constructor");
        this.type = type;
        this.exceptionObj = null;
        this.realm = realm;
        this.isIncompleteSource = isIncompleteSource;
    }

    @CompilerDirectives.TruffleBoundary
    public static JSException createCapture(JSErrorType type, String message, DynamicObject exceptionObj, JSRealm realm, int stackTraceLimit, DynamicObject skipFramesUpTo) {
        return JSException.fillInStackTrace(new JSException(type, message, null, exceptionObj, realm, stackTraceLimit), skipFramesUpTo, true);
    }

    @CompilerDirectives.TruffleBoundary
    public static JSException createCapture(JSErrorType type, String message, DynamicObject exceptionObj, JSRealm realm) {
        return JSException.createCapture(type, message, exceptionObj, realm, JSException.getStackTraceLimit(realm), Undefined.instance);
    }

    public static JSException create(JSErrorType type, String message, DynamicObject exceptionObj, JSRealm realm) {
        return JSException.create(type, message, null, exceptionObj, realm);
    }

    @CompilerDirectives.TruffleBoundary
    public static JSException create(JSErrorType type, String message, Node originatingNode, DynamicObject exceptionObj, JSRealm realm) {
        return JSException.fillInStackTrace(new JSException(type, message, originatingNode, exceptionObj, realm, JSException.getStackTraceLimit(realm)), Undefined.instance, false);
    }

    public static JSException create(JSErrorType type, String message) {
        return JSException.create(type, message, null);
    }

    public static JSException create(JSErrorType type, String message, Node originatingNode) {
        JSRealm realm = JavaScriptLanguage.getCurrentJSRealm();
        return JSException.fillInStackTrace(new JSException(type, message, originatingNode, null, realm, JSException.getStackTraceLimit(realm)), Undefined.instance, false);
    }

    public static JSException create(JSErrorType type, String message, Throwable cause, Node originatingNode) {
        JSRealm realm = JavaScriptLanguage.getCurrentJSRealm();
        return JSException.fillInStackTrace(new JSException(type, message, cause, originatingNode, realm, JSException.getStackTraceLimit(realm)), Undefined.instance, false);
    }

    public static JSException create(JSErrorType type, String message, SourceSection sourceLocation, boolean isIncompleteSource) {
        JSRealm realm = JavaScriptLanguage.getCurrentJSRealm();
        return JSException.fillInStackTrace(new JSException(type, message, sourceLocation, realm, JSException.getStackTraceLimit(realm), isIncompleteSource), Undefined.instance, false);
    }

    public static int getStackTraceLimit(JSRealm realm) {
        DynamicObject errorConstructor = realm.getErrorConstructor(JSErrorType.Error);
        Object stackTraceLimit = JSObject.get(errorConstructor, (Object)"stackTraceLimit");
        return Math.max(0, (int)JSRuntime.toInteger(stackTraceLimit));
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public String getMessage() {
        String message = this.getRawMessage();
        return message == null || message.isEmpty() ? this.type.name() : this.type.name() + ": " + message;
    }

    public String getRawMessage() {
        return super.getMessage();
    }

    public JSErrorType getErrorType() {
        return this.type;
    }

    public DynamicObject getErrorObject() {
        return this.exceptionObj;
    }

    public void setErrorObject(DynamicObject exceptionObj) {
        this.exceptionObj = exceptionObj;
    }

    @Override
    public Object getExceptionObject() {
        if (this.exceptionObj == null) {
            JSRealm innerRealm = this.realm != null ? this.realm : JavaScriptLanguage.getCurrentJSRealm();
            String message = this.getRawMessage();
            this.exceptionObj = JSError.createFromJSException(this, innerRealm, message == null ? "" : message);
        }
        return super.getExceptionObject();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public Object getErrorObjectEager(JSContext context) {
        if (this.exceptionObj == null) {
            JSRealm innerRealm = this.realm == null ? context.getRealm() : this.realm;
            String message = this.getRawMessage();
            this.exceptionObj = JSError.createFromJSException(this, innerRealm, message == null ? "" : message);
        }
        return this.exceptionObj;
    }

    public JSException setRealm(JSRealm realm) {
        if (this.realm == null) {
            if (this.useCallerRealm) {
                this.useCallerRealm = false;
            } else {
                this.realm = realm;
            }
        }
        return this;
    }

    public JSRealm getRealm() {
        return this.realm;
    }

    public JSException useCallerRealm() {
        this.useCallerRealm = true;
        this.realm = null;
        return this;
    }

    public boolean isSyntaxError() {
        return this.type == JSErrorType.SyntaxError;
    }

    public boolean isIncompleteSource() {
        return this.isIncompleteSource;
    }
}

