/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.access.HasHiddenKeyCacheNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=HasHiddenKeyCacheNode.class)
public final class HasHiddenKeyCacheNodeGen
extends HasHiddenKeyCacheNode
implements Introspection.Provider {
    @CompilerDirectives.CompilationFinal
    private volatile int state_;
    @CompilerDirectives.CompilationFinal
    private volatile int exclude_;
    @CompilerDirectives.CompilationFinal
    private CachedData cached_cache;

    private HasHiddenKeyCacheNodeGen(HiddenKey key) {
        super(key);
    }

    @Override
    @ExplodeLoop
    public boolean executeHasHiddenKey(Object arg0Value) {
        int state = this.state_;
        if ((state & 3) != 0 && JSTypes.isDynamicObject(arg0Value)) {
            DynamicObject arg0Value_ = (DynamicObject)arg0Value;
            if ((state & 1) != 0) {
                CachedData s1_ = this.cached_cache;
                while (s1_ != null) {
                    if (!Assumption.isValidAssumption((Assumption)s1_.assumption0_)) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        this.removeCached_(s1_);
                        return this.executeAndSpecialize(arg0Value_);
                    }
                    if (s1_.cachedShape_.check(arg0Value_)) {
                        return HasHiddenKeyCacheNode.doCached(arg0Value_, s1_.cachedShape_, s1_.hasOwnProperty_, s1_.cacheLimit_);
                    }
                    s1_ = s1_.next_;
                }
            }
            if ((state & 2) != 0 && JSGuards.isJSObject(arg0Value_)) {
                return this.doUncached(arg0Value_);
            }
        }
        if ((state & 4) != 0 && !JSGuards.isJSObject(arg0Value)) {
            return HasHiddenKeyCacheNode.doNonObject(arg0Value);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value);
    }

    private boolean executeAndSpecialize(Object arg0Value) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        int exclude = this.exclude_;
        try {
            if (JSTypes.isDynamicObject(arg0Value)) {
                DynamicObject arg0Value_ = (DynamicObject)arg0Value;
                if (exclude == 0) {
                    int cacheLimit__;
                    Assumption assumption0;
                    Shape cachedShape__;
                    int count1_ = 0;
                    CachedData s1_ = this.cached_cache;
                    if ((state & 1) != 0) {
                        while (s1_ != null && (!s1_.cachedShape_.check(arg0Value_) || s1_.assumption0_ != null && !Assumption.isValidAssumption((Assumption)s1_.assumption0_))) {
                            s1_ = s1_.next_;
                            ++count1_;
                        }
                    }
                    if (s1_ == null && (cachedShape__ = arg0Value_.getShape()).check(arg0Value_) && Assumption.isValidAssumption((Assumption)(assumption0 = cachedShape__.getValidAssumption())) && count1_ < (cacheLimit__ = this.getPropertyCacheLimit())) {
                        s1_ = new CachedData(this.cached_cache);
                        s1_.cachedShape_ = cachedShape__;
                        s1_.hasOwnProperty_ = this.doUncached(arg0Value_);
                        s1_.cacheLimit_ = cacheLimit__;
                        s1_.assumption0_ = assumption0;
                        this.cached_cache = s1_;
                        this.state_ = state |= 1;
                    }
                    if (s1_ != null) {
                        lock.unlock();
                        hasLock = false;
                        boolean bl = HasHiddenKeyCacheNode.doCached(arg0Value_, s1_.cachedShape_, s1_.hasOwnProperty_, s1_.cacheLimit_);
                        return bl;
                    }
                }
                if (JSGuards.isJSObject(arg0Value_)) {
                    this.exclude_ = exclude |= 1;
                    this.cached_cache = null;
                    state &= 0xFFFFFFFE;
                    this.state_ = state |= 2;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = this.doUncached(arg0Value_);
                    return bl;
                }
            }
            if (!JSGuards.isJSObject(arg0Value)) {
                this.state_ = state |= 4;
                lock.unlock();
                hasLock = false;
                boolean bl = HasHiddenKeyCacheNode.doNonObject(arg0Value);
                return bl;
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{null}, new Object[]{arg0Value});
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        CachedData s1_;
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0 && ((s1_ = this.cached_cache) == null || s1_.next_ == null)) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeCached_(Object s1_) {
        Lock lock = this.getLock();
        lock.lock();
        try {
            CachedData prev = null;
            CachedData cur = this.cached_cache;
            while (cur != null) {
                if (cur == s1_) {
                    if (prev == null) {
                        this.cached_cache = cur.next_;
                        break;
                    }
                    prev.next_ = cur.next_;
                    break;
                }
                prev = cur;
                cur = cur.next_;
            }
            if (this.cached_cache == null) {
                this.state_ &= 0xFFFFFFFE;
            }
        }
        finally {
            lock.unlock();
        }
    }

    public Introspection getIntrospectionData() {
        Object[] data = new Object[4];
        data[0] = 0;
        int state = this.state_;
        int exclude = this.exclude_;
        Object[] s = new Object[3];
        s[0] = "doCached";
        if ((state & 1) != 0) {
            s[1] = (byte)1;
            ArrayList<List<Object>> cached = new ArrayList<List<Object>>();
            CachedData s1_ = this.cached_cache;
            while (s1_ != null) {
                cached.add(Arrays.asList(s1_.cachedShape_, s1_.hasOwnProperty_, s1_.cacheLimit_));
                s1_ = s1_.next_;
            }
            s[2] = cached;
        } else {
            s[1] = exclude != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
        }
        data[1] = s;
        s = new Object[3];
        s[0] = "doUncached";
        s[1] = (state & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[2] = s;
        s = new Object[3];
        s[0] = "doNonObject";
        s[1] = (state & 4) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[3] = s;
        return Introspection.Provider.create((Object[])data);
    }

    public static HasHiddenKeyCacheNode create(HiddenKey key) {
        return new HasHiddenKeyCacheNodeGen(key);
    }

    @GeneratedBy(value=HasHiddenKeyCacheNode.class)
    private static final class CachedData {
        @CompilerDirectives.CompilationFinal
        CachedData next_;
        @CompilerDirectives.CompilationFinal
        Shape cachedShape_;
        @CompilerDirectives.CompilationFinal
        boolean hasOwnProperty_;
        @CompilerDirectives.CompilationFinal
        int cacheLimit_;
        @CompilerDirectives.CompilationFinal
        Assumption assumption0_;

        CachedData(CachedData next_) {
            this.next_ = next_;
        }
    }
}

