/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.js.builtins.NumberFunctionBuiltins;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.runtime.JSContext;

@GeneratedBy(value=NumberFunctionBuiltins.class)
public final class NumberFunctionBuiltinsFactory {

    @GeneratedBy(value=NumberFunctionBuiltins.JSNumberIsSafeIntegerNode.class)
    public static final class JSNumberIsSafeIntegerNodeGen
    extends NumberFunctionBuiltins.JSNumberIsSafeIntegerNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private JSNumberIsSafeIntegerNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = this.state_;
            if ((state & 6) == 0 && (state & 7) != 0) {
                return this.execute_int0(frameValue, state);
            }
            if ((state & 5) == 0 && (state & 7) != 0) {
                return this.execute_double1(frameValue, state);
            }
            return this.execute_generic2(frameValue, state);
        }

        private Object execute_int0(VirtualFrame frameValue, int state) {
            int arguments0Value_;
            try {
                arguments0Value_ = this.arguments0_.executeInt(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 1) != 0);
            return this.isSafeIntegerInt(arguments0Value_);
        }

        private Object execute_double1(VirtualFrame frameValue, int state) {
            double arguments0Value_;
            int arguments0Value_int = 0;
            long arguments0Value_long = 0L;
            try {
                if ((state & 0x70) == 0 && (state & 7) != 0) {
                    arguments0Value_long = this.arguments0_.executeLong(frameValue);
                    arguments0Value_ = JSTypes.longToDouble(arguments0Value_long);
                } else if ((state & 0x68) == 0 && (state & 7) != 0) {
                    arguments0Value_int = this.arguments0_.executeInt(frameValue);
                    arguments0Value_ = JSTypes.intToDouble(arguments0Value_int);
                } else if ((state & 0x58) == 0 && (state & 7) != 0) {
                    arguments0Value_ = this.arguments0_.executeDouble(frameValue);
                } else {
                    Object arguments0Value__ = this.arguments0_.execute(frameValue);
                    arguments0Value_ = JSTypesGen.expectImplicitDouble((state & 0x78) >>> 3, arguments0Value__);
                }
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 2) != 0);
            return this.isSafeIntegerDouble(arguments0Value_);
        }

        private Object execute_generic2(VirtualFrame frameValue, int state) {
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            if ((state & 1) != 0 && arguments0Value_ instanceof Integer) {
                int arguments0Value__ = (Integer)arguments0Value_;
                return this.isSafeIntegerInt(arguments0Value__);
            }
            if ((state & 2) != 0 && JSTypesGen.isImplicitDouble((state & 0x78) >>> 3, arguments0Value_)) {
                double arguments0Value__ = JSTypesGen.asImplicitDouble((state & 0x78) >>> 3, arguments0Value_);
                return this.isSafeIntegerDouble(arguments0Value__);
            }
            if ((state & 4) != 0 && !JSGuards.isNumber(arguments0Value_)) {
                return this.isSafeIntegerNotANumber(arguments0Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_);
        }

        @Override
        public boolean executeBoolean(VirtualFrame frameValue) {
            int state = this.state_;
            if ((state & 6) == 0 && (state & 7) != 0) {
                return this.executeBoolean_int3(frameValue, state);
            }
            if ((state & 5) == 0 && (state & 7) != 0) {
                return this.executeBoolean_double4(frameValue, state);
            }
            return this.executeBoolean_generic5(frameValue, state);
        }

        private boolean executeBoolean_int3(VirtualFrame frameValue, int state) {
            int arguments0Value_;
            try {
                arguments0Value_ = this.arguments0_.executeInt(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 1) != 0);
            return this.isSafeIntegerInt(arguments0Value_);
        }

        private boolean executeBoolean_double4(VirtualFrame frameValue, int state) {
            double arguments0Value_;
            int arguments0Value_int = 0;
            long arguments0Value_long = 0L;
            try {
                if ((state & 0x70) == 0 && (state & 7) != 0) {
                    arguments0Value_long = this.arguments0_.executeLong(frameValue);
                    arguments0Value_ = JSTypes.longToDouble(arguments0Value_long);
                } else if ((state & 0x68) == 0 && (state & 7) != 0) {
                    arguments0Value_int = this.arguments0_.executeInt(frameValue);
                    arguments0Value_ = JSTypes.intToDouble(arguments0Value_int);
                } else if ((state & 0x58) == 0 && (state & 7) != 0) {
                    arguments0Value_ = this.arguments0_.executeDouble(frameValue);
                } else {
                    Object arguments0Value__ = this.arguments0_.execute(frameValue);
                    arguments0Value_ = JSTypesGen.expectImplicitDouble((state & 0x78) >>> 3, arguments0Value__);
                }
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 2) != 0);
            return this.isSafeIntegerDouble(arguments0Value_);
        }

        private boolean executeBoolean_generic5(VirtualFrame frameValue, int state) {
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            if ((state & 1) != 0 && arguments0Value_ instanceof Integer) {
                int arguments0Value__ = (Integer)arguments0Value_;
                return this.isSafeIntegerInt(arguments0Value__);
            }
            if ((state & 2) != 0 && JSTypesGen.isImplicitDouble((state & 0x78) >>> 3, arguments0Value_)) {
                double arguments0Value__ = JSTypesGen.asImplicitDouble((state & 0x78) >>> 3, arguments0Value_);
                return this.isSafeIntegerDouble(arguments0Value__);
            }
            if ((state & 4) != 0 && !JSGuards.isNumber(arguments0Value_)) {
                return this.isSafeIntegerNotANumber(arguments0Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.executeBoolean(frameValue);
        }

        private boolean executeAndSpecialize(Object arguments0Value) {
            int state = this.state_;
            if (arguments0Value instanceof Integer) {
                int arguments0Value_ = (Integer)arguments0Value;
                this.state_ = state |= 1;
                return this.isSafeIntegerInt(arguments0Value_);
            }
            int doubleCast0 = JSTypesGen.specializeImplicitDouble(arguments0Value);
            if (doubleCast0 != 0) {
                double arguments0Value_ = JSTypesGen.asImplicitDouble(doubleCast0, arguments0Value);
                state |= doubleCast0 << 3;
                this.state_ = state |= 2;
                return this.isSafeIntegerDouble(arguments0Value_);
            }
            if (!JSGuards.isNumber(arguments0Value)) {
                this.state_ = state |= 4;
                return this.isSafeIntegerNotANumber(arguments0Value);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if ((state & 7) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & 7 & (state & 7) - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[4];
            data[0] = 0;
            int state = this.state_;
            Object[] s = new Object[3];
            s[0] = "isSafeIntegerInt";
            s[1] = (state & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[1] = s;
            s = new Object[3];
            s[0] = "isSafeIntegerDouble";
            s[1] = (state & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[2] = s;
            s = new Object[3];
            s[0] = "isSafeIntegerNotANumber";
            s[1] = (state & 4) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[3] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static NumberFunctionBuiltins.JSNumberIsSafeIntegerNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new JSNumberIsSafeIntegerNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=NumberFunctionBuiltins.JSNumberIsIntegerNode.class)
    public static final class JSNumberIsIntegerNodeGen
    extends NumberFunctionBuiltins.JSNumberIsIntegerNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private JSNumberIsIntegerNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = this.state_;
            if ((state & 6) == 0 && (state & 7) != 0) {
                return this.execute_int0(frameValue, state);
            }
            if ((state & 5) == 0 && (state & 7) != 0) {
                return this.execute_double1(frameValue, state);
            }
            return this.execute_generic2(frameValue, state);
        }

        private Object execute_int0(VirtualFrame frameValue, int state) {
            int arguments0Value_;
            try {
                arguments0Value_ = this.arguments0_.executeInt(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 1) != 0);
            return this.isInteger(arguments0Value_);
        }

        private Object execute_double1(VirtualFrame frameValue, int state) {
            double arguments0Value_;
            int arguments0Value_int = 0;
            long arguments0Value_long = 0L;
            try {
                if ((state & 0x70) == 0 && (state & 7) != 0) {
                    arguments0Value_long = this.arguments0_.executeLong(frameValue);
                    arguments0Value_ = JSTypes.longToDouble(arguments0Value_long);
                } else if ((state & 0x68) == 0 && (state & 7) != 0) {
                    arguments0Value_int = this.arguments0_.executeInt(frameValue);
                    arguments0Value_ = JSTypes.intToDouble(arguments0Value_int);
                } else if ((state & 0x58) == 0 && (state & 7) != 0) {
                    arguments0Value_ = this.arguments0_.executeDouble(frameValue);
                } else {
                    Object arguments0Value__ = this.arguments0_.execute(frameValue);
                    arguments0Value_ = JSTypesGen.expectImplicitDouble((state & 0x78) >>> 3, arguments0Value__);
                }
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 2) != 0);
            return this.isInteger(arguments0Value_);
        }

        private Object execute_generic2(VirtualFrame frameValue, int state) {
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            if ((state & 1) != 0 && arguments0Value_ instanceof Integer) {
                int arguments0Value__ = (Integer)arguments0Value_;
                return this.isInteger(arguments0Value__);
            }
            if ((state & 2) != 0 && JSTypesGen.isImplicitDouble((state & 0x78) >>> 3, arguments0Value_)) {
                double arguments0Value__ = JSTypesGen.asImplicitDouble((state & 0x78) >>> 3, arguments0Value_);
                return this.isInteger(arguments0Value__);
            }
            if ((state & 4) != 0 && !JSGuards.isNumber(arguments0Value_)) {
                return this.isInteger(arguments0Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_);
        }

        @Override
        public boolean executeBoolean(VirtualFrame frameValue) {
            int state = this.state_;
            if ((state & 6) == 0 && (state & 7) != 0) {
                return this.executeBoolean_int3(frameValue, state);
            }
            if ((state & 5) == 0 && (state & 7) != 0) {
                return this.executeBoolean_double4(frameValue, state);
            }
            return this.executeBoolean_generic5(frameValue, state);
        }

        private boolean executeBoolean_int3(VirtualFrame frameValue, int state) {
            int arguments0Value_;
            try {
                arguments0Value_ = this.arguments0_.executeInt(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 1) != 0);
            return this.isInteger(arguments0Value_);
        }

        private boolean executeBoolean_double4(VirtualFrame frameValue, int state) {
            double arguments0Value_;
            int arguments0Value_int = 0;
            long arguments0Value_long = 0L;
            try {
                if ((state & 0x70) == 0 && (state & 7) != 0) {
                    arguments0Value_long = this.arguments0_.executeLong(frameValue);
                    arguments0Value_ = JSTypes.longToDouble(arguments0Value_long);
                } else if ((state & 0x68) == 0 && (state & 7) != 0) {
                    arguments0Value_int = this.arguments0_.executeInt(frameValue);
                    arguments0Value_ = JSTypes.intToDouble(arguments0Value_int);
                } else if ((state & 0x58) == 0 && (state & 7) != 0) {
                    arguments0Value_ = this.arguments0_.executeDouble(frameValue);
                } else {
                    Object arguments0Value__ = this.arguments0_.execute(frameValue);
                    arguments0Value_ = JSTypesGen.expectImplicitDouble((state & 0x78) >>> 3, arguments0Value__);
                }
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 2) != 0);
            return this.isInteger(arguments0Value_);
        }

        private boolean executeBoolean_generic5(VirtualFrame frameValue, int state) {
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            if ((state & 1) != 0 && arguments0Value_ instanceof Integer) {
                int arguments0Value__ = (Integer)arguments0Value_;
                return this.isInteger(arguments0Value__);
            }
            if ((state & 2) != 0 && JSTypesGen.isImplicitDouble((state & 0x78) >>> 3, arguments0Value_)) {
                double arguments0Value__ = JSTypesGen.asImplicitDouble((state & 0x78) >>> 3, arguments0Value_);
                return this.isInteger(arguments0Value__);
            }
            if ((state & 4) != 0 && !JSGuards.isNumber(arguments0Value_)) {
                return this.isInteger(arguments0Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.executeBoolean(frameValue);
        }

        private boolean executeAndSpecialize(Object arguments0Value) {
            int state = this.state_;
            if (arguments0Value instanceof Integer) {
                int arguments0Value_ = (Integer)arguments0Value;
                this.state_ = state |= 1;
                return this.isInteger(arguments0Value_);
            }
            int doubleCast0 = JSTypesGen.specializeImplicitDouble(arguments0Value);
            if (doubleCast0 != 0) {
                double arguments0Value_ = JSTypesGen.asImplicitDouble(doubleCast0, arguments0Value);
                state |= doubleCast0 << 3;
                this.state_ = state |= 2;
                return this.isInteger(arguments0Value_);
            }
            if (!JSGuards.isNumber(arguments0Value)) {
                this.state_ = state |= 4;
                return this.isInteger(arguments0Value);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if ((state & 7) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & 7 & (state & 7) - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[4];
            data[0] = 0;
            int state = this.state_;
            Object[] s = new Object[3];
            s[0] = "isInteger";
            s[1] = (state & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[1] = s;
            s = new Object[3];
            s[0] = "isInteger";
            s[1] = (state & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[2] = s;
            s = new Object[3];
            s[0] = "isInteger";
            s[1] = (state & 4) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[3] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static NumberFunctionBuiltins.JSNumberIsIntegerNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new JSNumberIsIntegerNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=NumberFunctionBuiltins.JSNumberIsFiniteNode.class)
    public static final class JSNumberIsFiniteNodeGen
    extends NumberFunctionBuiltins.JSNumberIsFiniteNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private JSNumberIsFiniteNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = this.state_;
            if ((state & 6) == 0 && (state & 7) != 0) {
                return this.execute_int0(frameValue, state);
            }
            if ((state & 5) == 0 && (state & 7) != 0) {
                return this.execute_double1(frameValue, state);
            }
            return this.execute_generic2(frameValue, state);
        }

        private Object execute_int0(VirtualFrame frameValue, int state) {
            int arguments0Value_;
            try {
                arguments0Value_ = this.arguments0_.executeInt(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 1) != 0);
            return this.isFinite(arguments0Value_);
        }

        private Object execute_double1(VirtualFrame frameValue, int state) {
            double arguments0Value_;
            int arguments0Value_int = 0;
            long arguments0Value_long = 0L;
            try {
                if ((state & 0x70) == 0 && (state & 7) != 0) {
                    arguments0Value_long = this.arguments0_.executeLong(frameValue);
                    arguments0Value_ = JSTypes.longToDouble(arguments0Value_long);
                } else if ((state & 0x68) == 0 && (state & 7) != 0) {
                    arguments0Value_int = this.arguments0_.executeInt(frameValue);
                    arguments0Value_ = JSTypes.intToDouble(arguments0Value_int);
                } else if ((state & 0x58) == 0 && (state & 7) != 0) {
                    arguments0Value_ = this.arguments0_.executeDouble(frameValue);
                } else {
                    Object arguments0Value__ = this.arguments0_.execute(frameValue);
                    arguments0Value_ = JSTypesGen.expectImplicitDouble((state & 0x78) >>> 3, arguments0Value__);
                }
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 2) != 0);
            return this.isFinite(arguments0Value_);
        }

        private Object execute_generic2(VirtualFrame frameValue, int state) {
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            if ((state & 1) != 0 && arguments0Value_ instanceof Integer) {
                int arguments0Value__ = (Integer)arguments0Value_;
                return this.isFinite(arguments0Value__);
            }
            if ((state & 2) != 0 && JSTypesGen.isImplicitDouble((state & 0x78) >>> 3, arguments0Value_)) {
                double arguments0Value__ = JSTypesGen.asImplicitDouble((state & 0x78) >>> 3, arguments0Value_);
                return this.isFinite(arguments0Value__);
            }
            if ((state & 4) != 0 && !JSGuards.isNumber(arguments0Value_)) {
                return this.isFinite(arguments0Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_);
        }

        @Override
        public boolean executeBoolean(VirtualFrame frameValue) {
            int state = this.state_;
            if ((state & 6) == 0 && (state & 7) != 0) {
                return this.executeBoolean_int3(frameValue, state);
            }
            if ((state & 5) == 0 && (state & 7) != 0) {
                return this.executeBoolean_double4(frameValue, state);
            }
            return this.executeBoolean_generic5(frameValue, state);
        }

        private boolean executeBoolean_int3(VirtualFrame frameValue, int state) {
            int arguments0Value_;
            try {
                arguments0Value_ = this.arguments0_.executeInt(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 1) != 0);
            return this.isFinite(arguments0Value_);
        }

        private boolean executeBoolean_double4(VirtualFrame frameValue, int state) {
            double arguments0Value_;
            int arguments0Value_int = 0;
            long arguments0Value_long = 0L;
            try {
                if ((state & 0x70) == 0 && (state & 7) != 0) {
                    arguments0Value_long = this.arguments0_.executeLong(frameValue);
                    arguments0Value_ = JSTypes.longToDouble(arguments0Value_long);
                } else if ((state & 0x68) == 0 && (state & 7) != 0) {
                    arguments0Value_int = this.arguments0_.executeInt(frameValue);
                    arguments0Value_ = JSTypes.intToDouble(arguments0Value_int);
                } else if ((state & 0x58) == 0 && (state & 7) != 0) {
                    arguments0Value_ = this.arguments0_.executeDouble(frameValue);
                } else {
                    Object arguments0Value__ = this.arguments0_.execute(frameValue);
                    arguments0Value_ = JSTypesGen.expectImplicitDouble((state & 0x78) >>> 3, arguments0Value__);
                }
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 2) != 0);
            return this.isFinite(arguments0Value_);
        }

        private boolean executeBoolean_generic5(VirtualFrame frameValue, int state) {
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            if ((state & 1) != 0 && arguments0Value_ instanceof Integer) {
                int arguments0Value__ = (Integer)arguments0Value_;
                return this.isFinite(arguments0Value__);
            }
            if ((state & 2) != 0 && JSTypesGen.isImplicitDouble((state & 0x78) >>> 3, arguments0Value_)) {
                double arguments0Value__ = JSTypesGen.asImplicitDouble((state & 0x78) >>> 3, arguments0Value_);
                return this.isFinite(arguments0Value__);
            }
            if ((state & 4) != 0 && !JSGuards.isNumber(arguments0Value_)) {
                return this.isFinite(arguments0Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.executeBoolean(frameValue);
        }

        private boolean executeAndSpecialize(Object arguments0Value) {
            int state = this.state_;
            if (arguments0Value instanceof Integer) {
                int arguments0Value_ = (Integer)arguments0Value;
                this.state_ = state |= 1;
                return this.isFinite(arguments0Value_);
            }
            int doubleCast0 = JSTypesGen.specializeImplicitDouble(arguments0Value);
            if (doubleCast0 != 0) {
                double arguments0Value_ = JSTypesGen.asImplicitDouble(doubleCast0, arguments0Value);
                state |= doubleCast0 << 3;
                this.state_ = state |= 2;
                return this.isFinite(arguments0Value_);
            }
            if (!JSGuards.isNumber(arguments0Value)) {
                this.state_ = state |= 4;
                return this.isFinite(arguments0Value);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if ((state & 7) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & 7 & (state & 7) - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[4];
            data[0] = 0;
            int state = this.state_;
            Object[] s = new Object[3];
            s[0] = "isFinite";
            s[1] = (state & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[1] = s;
            s = new Object[3];
            s[0] = "isFinite";
            s[1] = (state & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[2] = s;
            s = new Object[3];
            s[0] = "isFinite";
            s[1] = (state & 4) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[3] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static NumberFunctionBuiltins.JSNumberIsFiniteNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new JSNumberIsFiniteNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=NumberFunctionBuiltins.JSNumberIsNaNNode.class)
    public static final class JSNumberIsNaNNodeGen
    extends NumberFunctionBuiltins.JSNumberIsNaNNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private JSNumberIsNaNNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = this.state_;
            if ((state & 1) == 0 && (state & 3) != 0) {
                return this.execute_double0(frameValue, state);
            }
            return this.execute_generic1(frameValue, state);
        }

        private Object execute_double0(VirtualFrame frameValue, int state) {
            double arguments0Value_;
            int arguments0Value_int = 0;
            long arguments0Value_long = 0L;
            try {
                if ((state & 0x38) == 0 && (state & 3) != 0) {
                    arguments0Value_long = this.arguments0_.executeLong(frameValue);
                    arguments0Value_ = JSTypes.longToDouble(arguments0Value_long);
                } else if ((state & 0x34) == 0 && (state & 3) != 0) {
                    arguments0Value_int = this.arguments0_.executeInt(frameValue);
                    arguments0Value_ = JSTypes.intToDouble(arguments0Value_int);
                } else if ((state & 0x2C) == 0 && (state & 3) != 0) {
                    arguments0Value_ = this.arguments0_.executeDouble(frameValue);
                } else {
                    Object arguments0Value__ = this.arguments0_.execute(frameValue);
                    arguments0Value_ = JSTypesGen.expectImplicitDouble((state & 0x3C) >>> 2, arguments0Value__);
                }
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 2) != 0);
            return this.isNaNDouble(arguments0Value_);
        }

        private Object execute_generic1(VirtualFrame frameValue, int state) {
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            if ((state & 1) != 0 && !this.isDouble(arguments0Value_)) {
                return this.isNaNNotDouble(arguments0Value_);
            }
            if ((state & 2) != 0 && JSTypesGen.isImplicitDouble((state & 0x3C) >>> 2, arguments0Value_)) {
                double arguments0Value__ = JSTypesGen.asImplicitDouble((state & 0x3C) >>> 2, arguments0Value_);
                return this.isNaNDouble(arguments0Value__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_);
        }

        @Override
        public boolean executeBoolean(VirtualFrame frameValue) {
            int state = this.state_;
            if ((state & 1) == 0 && (state & 3) != 0) {
                return this.executeBoolean_double2(frameValue, state);
            }
            return this.executeBoolean_generic3(frameValue, state);
        }

        private boolean executeBoolean_double2(VirtualFrame frameValue, int state) {
            double arguments0Value_;
            int arguments0Value_int = 0;
            long arguments0Value_long = 0L;
            try {
                if ((state & 0x38) == 0 && (state & 3) != 0) {
                    arguments0Value_long = this.arguments0_.executeLong(frameValue);
                    arguments0Value_ = JSTypes.longToDouble(arguments0Value_long);
                } else if ((state & 0x34) == 0 && (state & 3) != 0) {
                    arguments0Value_int = this.arguments0_.executeInt(frameValue);
                    arguments0Value_ = JSTypes.intToDouble(arguments0Value_int);
                } else if ((state & 0x2C) == 0 && (state & 3) != 0) {
                    arguments0Value_ = this.arguments0_.executeDouble(frameValue);
                } else {
                    Object arguments0Value__ = this.arguments0_.execute(frameValue);
                    arguments0Value_ = JSTypesGen.expectImplicitDouble((state & 0x3C) >>> 2, arguments0Value__);
                }
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 2) != 0);
            return this.isNaNDouble(arguments0Value_);
        }

        private boolean executeBoolean_generic3(VirtualFrame frameValue, int state) {
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            if ((state & 1) != 0 && !this.isDouble(arguments0Value_)) {
                return this.isNaNNotDouble(arguments0Value_);
            }
            if ((state & 2) != 0 && JSTypesGen.isImplicitDouble((state & 0x3C) >>> 2, arguments0Value_)) {
                double arguments0Value__ = JSTypesGen.asImplicitDouble((state & 0x3C) >>> 2, arguments0Value_);
                return this.isNaNDouble(arguments0Value__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.executeBoolean(frameValue);
        }

        private boolean executeAndSpecialize(Object arguments0Value) {
            int state = this.state_;
            if (!this.isDouble(arguments0Value)) {
                this.state_ = state |= 1;
                return this.isNaNNotDouble(arguments0Value);
            }
            int doubleCast0 = JSTypesGen.specializeImplicitDouble(arguments0Value);
            if (doubleCast0 != 0) {
                double arguments0Value_ = JSTypesGen.asImplicitDouble(doubleCast0, arguments0Value);
                state |= doubleCast0 << 2;
                this.state_ = state |= 2;
                return this.isNaNDouble(arguments0Value_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if ((state & 3) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & 3 & (state & 3) - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[3];
            data[0] = 0;
            int state = this.state_;
            Object[] s = new Object[3];
            s[0] = "isNaNNotDouble";
            s[1] = (state & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[1] = s;
            s = new Object[3];
            s[0] = "isNaNDouble";
            s[1] = (state & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[2] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static NumberFunctionBuiltins.JSNumberIsNaNNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new JSNumberIsNaNNodeGen(context, builtin, arguments);
        }
    }
}

