/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.js.parser.ir;

import com.oracle.js.parser.ir.Assignment;
import com.oracle.js.parser.ir.Expression;
import com.oracle.js.parser.ir.FunctionNode;
import com.oracle.js.parser.ir.IdentNode;
import com.oracle.js.parser.ir.LexicalContext;
import com.oracle.js.parser.ir.Node;
import com.oracle.js.parser.ir.Statement;
import com.oracle.js.parser.ir.visitor.NodeVisitor;
import com.oracle.js.parser.ir.visitor.TranslatorNodeVisitor;

public final class VarNode
extends Statement
implements Assignment<IdentNode> {
    private final IdentNode name;
    private final Expression init;
    private final int flags;
    private final int sourceOrder;
    public static final int IS_LET = 1;
    public static final int IS_CONST = 2;
    public static final int IS_LAST_FUNCTION_DECLARATION = 4;
    public static final int IS_EXPORT = 8;
    public static final int IS_DESTRUCTURING = 16;

    public VarNode(int n, long l, int n2, IdentNode identNode, Expression expression) {
        this(n, l, n2, identNode, expression, 0);
    }

    private VarNode(VarNode varNode, IdentNode identNode, Expression expression, int n) {
        super(varNode);
        this.sourceOrder = -1;
        this.name = expression == null ? identNode : identNode.setIsInitializedHere();
        this.init = expression;
        this.flags = n;
    }

    public VarNode(int n, long l, int n2, IdentNode identNode, Expression expression, int n3) {
        this(n, l, -1, n2, identNode, expression, n3);
    }

    public VarNode(int n, long l, int n2, int n3, IdentNode identNode, Expression expression, int n4) {
        super(n, l, n3);
        this.sourceOrder = n2;
        this.name = expression == null ? identNode : identNode.setIsInitializedHere();
        this.init = expression;
        this.flags = n4;
    }

    @Override
    public int getSourceOrder() {
        return this.sourceOrder == -1 ? super.getSourceOrder() : this.sourceOrder;
    }

    @Override
    public boolean isAssignment() {
        return this.hasInit();
    }

    @Override
    public IdentNode getAssignmentDest() {
        return this.isAssignment() ? this.name : null;
    }

    @Override
    public Expression getAssignmentSource() {
        return this.isAssignment() ? this.getInit() : null;
    }

    public boolean isBlockScoped() {
        return this.getFlag(1) || this.getFlag(2);
    }

    public boolean isLet() {
        return this.getFlag(1);
    }

    public boolean isConst() {
        return this.getFlag(2);
    }

    public int getSymbolFlags() {
        if (this.isLet()) {
            return 18;
        }
        if (this.isConst()) {
            return 34;
        }
        return 2;
    }

    public boolean hasInit() {
        return this.init != null;
    }

    @Override
    public Node accept(NodeVisitor<? extends LexicalContext> nodeVisitor) {
        if (nodeVisitor.enterVarNode(this)) {
            Expression expression = this.init == null ? null : (Expression)this.init.accept(nodeVisitor);
            IdentNode identNode = (IdentNode)this.name.accept(nodeVisitor);
            VarNode varNode = this.name != identNode || this.init != expression ? new VarNode(this, identNode, expression, this.flags) : this;
            return nodeVisitor.leaveVarNode(varNode);
        }
        return this;
    }

    @Override
    public <R> R accept(TranslatorNodeVisitor<? extends LexicalContext, R> translatorNodeVisitor) {
        return translatorNodeVisitor.enterVarNode(this);
    }

    @Override
    public void toString(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append(this.tokenType().getName()).append(' ');
        this.name.toString(stringBuilder, bl);
        if (this.init != null) {
            stringBuilder.append(" = ");
            this.init.toString(stringBuilder, bl);
        }
    }

    public Expression getInit() {
        return this.init;
    }

    public VarNode setInit(Expression expression) {
        if (this.init == expression) {
            return this;
        }
        return new VarNode(this, this.name, expression, this.flags);
    }

    public IdentNode getName() {
        return this.name;
    }

    public VarNode setName(IdentNode identNode) {
        if (this.name == identNode) {
            return this;
        }
        return new VarNode(this, identNode, this.init, this.flags);
    }

    private VarNode setFlags(int n) {
        if (this.flags == n) {
            return this;
        }
        return new VarNode(this, this.name, this.init, n);
    }

    public boolean getFlag(int n) {
        return (this.flags & n) == n;
    }

    public VarNode setFlag(int n) {
        return this.setFlags(this.flags | n);
    }

    public boolean isFunctionDeclaration() {
        return this.init instanceof FunctionNode && ((FunctionNode)this.init).isDeclared();
    }

    public boolean isExport() {
        return this.getFlag(8);
    }

    public boolean isDestructuring() {
        return this.getFlag(16);
    }
}

