/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.js.parser.ir;

import com.oracle.js.parser.ir.BreakableStatement;
import com.oracle.js.parser.ir.CaseNode;
import com.oracle.js.parser.ir.Expression;
import com.oracle.js.parser.ir.Label;
import com.oracle.js.parser.ir.LexicalContext;
import com.oracle.js.parser.ir.Node;
import com.oracle.js.parser.ir.Symbol;
import com.oracle.js.parser.ir.visitor.NodeVisitor;
import com.oracle.js.parser.ir.visitor.TranslatorNodeVisitor;
import java.util.Collections;
import java.util.List;

public final class SwitchNode
extends BreakableStatement {
    private final Expression expression;
    private final List<CaseNode> cases;
    private final int defaultCaseIndex;
    private Symbol tag;

    public SwitchNode(int n, long l, int n2, Expression expression, List<CaseNode> list, CaseNode caseNode) {
        super(n, l, n2, new Label("switch_break"));
        this.expression = expression;
        this.cases = list;
        this.defaultCaseIndex = caseNode == null ? -1 : list.indexOf(caseNode);
    }

    private SwitchNode(SwitchNode switchNode, Expression expression, List<CaseNode> list, int n) {
        super(switchNode);
        this.expression = expression;
        this.cases = list;
        this.defaultCaseIndex = n;
        this.tag = switchNode.getTag();
    }

    @Override
    public boolean isTerminal() {
        if (!this.cases.isEmpty() && this.defaultCaseIndex != -1) {
            for (CaseNode caseNode : this.cases) {
                if (caseNode.isTerminal()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public Node accept(LexicalContext lexicalContext, NodeVisitor<? extends LexicalContext> nodeVisitor) {
        if (nodeVisitor.enterSwitchNode(this)) {
            return nodeVisitor.leaveSwitchNode(this.setExpression(lexicalContext, (Expression)this.expression.accept(nodeVisitor)).setCases(lexicalContext, Node.accept(nodeVisitor, this.cases), this.defaultCaseIndex));
        }
        return this;
    }

    @Override
    public <R> R accept(LexicalContext lexicalContext, TranslatorNodeVisitor<? extends LexicalContext, R> translatorNodeVisitor) {
        return translatorNodeVisitor.enterSwitchNode(this);
    }

    @Override
    public void toString(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append("switch (");
        this.expression.toString(stringBuilder, bl);
        stringBuilder.append(')');
    }

    public CaseNode getDefaultCase() {
        return this.defaultCaseIndex == -1 ? null : this.cases.get(this.defaultCaseIndex);
    }

    public List<CaseNode> getCases() {
        return Collections.unmodifiableList(this.cases);
    }

    private SwitchNode setCases(LexicalContext lexicalContext, List<CaseNode> list, int n) {
        if (this.cases == list) {
            return this;
        }
        return Node.replaceInLexicalContext(lexicalContext, this, new SwitchNode(this, this.expression, list, n));
    }

    public Expression getExpression() {
        return this.expression;
    }

    public SwitchNode setExpression(LexicalContext lexicalContext, Expression expression) {
        if (this.expression == expression) {
            return this;
        }
        return Node.replaceInLexicalContext(lexicalContext, this, new SwitchNode(this, expression, this.cases, this.defaultCaseIndex));
    }

    public Symbol getTag() {
        return this.tag;
    }

    public void setTag(Symbol symbol) {
        this.tag = symbol;
    }
}

