/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.js.parser.ir;

import com.oracle.js.parser.Source;
import com.oracle.js.parser.ir.Block;
import com.oracle.js.parser.ir.BreakableNode;
import com.oracle.js.parser.ir.Flags;
import com.oracle.js.parser.ir.FunctionNode;
import com.oracle.js.parser.ir.LabelNode;
import com.oracle.js.parser.ir.LexicalContextNode;
import com.oracle.js.parser.ir.LoopNode;
import com.oracle.js.parser.ir.SwitchNode;
import java.io.File;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class LexicalContext {
    private LexicalContextNode[] stack = new LexicalContextNode[16];
    private int[] flags = new int[16];
    private int sp;

    public int getFlags(LexicalContextNode lexicalContextNode) {
        for (int i = this.sp - 1; i >= 0; --i) {
            if (this.stack[i] != lexicalContextNode) continue;
            return this.flags[i];
        }
        throw new AssertionError((Object)"flag node not on context stack");
    }

    public Block getFunctionBody(FunctionNode functionNode) {
        for (int i = this.sp - 1; i >= 0; --i) {
            if (this.stack[i] != functionNode) continue;
            return (Block)this.stack[i + 1];
        }
        throw new AssertionError((Object)(functionNode.getName() + " not on context stack"));
    }

    public Iterator<LexicalContextNode> getAllNodes() {
        return new NodeIterator<LexicalContextNode>(LexicalContextNode.class);
    }

    public FunctionNode getOutermostFunction() {
        return (FunctionNode)this.stack[0];
    }

    public <T extends LexicalContextNode> T push(T t) {
        assert (!this.contains(t));
        if (this.sp == this.stack.length) {
            LexicalContextNode[] lexicalContextNodeArray = new LexicalContextNode[this.sp * 2];
            System.arraycopy(this.stack, 0, lexicalContextNodeArray, 0, this.sp);
            this.stack = lexicalContextNodeArray;
            int[] nArray = new int[this.sp * 2];
            System.arraycopy(this.flags, 0, nArray, 0, this.sp);
            this.flags = nArray;
        }
        this.stack[this.sp] = t;
        this.flags[this.sp] = 0;
        ++this.sp;
        return t;
    }

    public boolean isEmpty() {
        return this.sp == 0;
    }

    public int size() {
        return this.sp;
    }

    public <T extends LexicalContextNode> T pop(T t) {
        --this.sp;
        LexicalContextNode lexicalContextNode = this.stack[this.sp];
        this.stack[this.sp] = null;
        if (lexicalContextNode instanceof Flags) {
            return ((Flags)((Object)lexicalContextNode)).setFlag(this, this.flags[this.sp]);
        }
        return (T)lexicalContextNode;
    }

    public LexicalContextNode peek() {
        return this.stack[this.sp - 1];
    }

    public boolean contains(LexicalContextNode lexicalContextNode) {
        for (int i = 0; i < this.sp; ++i) {
            if (this.stack[i] != lexicalContextNode) continue;
            return true;
        }
        return false;
    }

    public LexicalContextNode replace(LexicalContextNode lexicalContextNode, LexicalContextNode lexicalContextNode2) {
        for (int i = this.sp - 1; i >= 0; --i) {
            if (this.stack[i] != lexicalContextNode) continue;
            assert (i == this.sp - 1) : "violation of contract - we always expect to find the replacement node on top of the lexical context stack: " + lexicalContextNode2 + " has " + this.stack[i + 1].getClass() + " above it";
            this.stack[i] = lexicalContextNode2;
            break;
        }
        return lexicalContextNode2;
    }

    public Iterator<Block> getBlocks() {
        return new NodeIterator<Block>(Block.class);
    }

    public Iterator<FunctionNode> getFunctions() {
        return new NodeIterator<FunctionNode>(FunctionNode.class);
    }

    public Block getParentBlock() {
        NodeIterator<Block> nodeIterator = new NodeIterator<Block>(Block.class, this.getCurrentFunction());
        nodeIterator.next();
        return nodeIterator.hasNext() ? (Block)nodeIterator.next() : null;
    }

    public LabelNode getCurrentBlockLabelNode() {
        assert (this.stack[this.sp - 1] instanceof Block);
        if (this.sp < 2) {
            return null;
        }
        LexicalContextNode lexicalContextNode = this.stack[this.sp - 2];
        return lexicalContextNode instanceof LabelNode ? (LabelNode)lexicalContextNode : null;
    }

    public Iterator<Block> getAncestorBlocks(Block block) {
        Iterator<Block> iterator = this.getBlocks();
        while (iterator.hasNext()) {
            Block block2 = iterator.next();
            if (block != block2) continue;
            return iterator;
        }
        throw new AssertionError((Object)"Block is not on the current lexical context stack");
    }

    public Iterator<Block> getBlocks(final Block block) {
        final Iterator<Block> iterator = this.getAncestorBlocks(block);
        return new Iterator<Block>(){
            boolean blockReturned = false;

            @Override
            public boolean hasNext() {
                return iterator.hasNext() || !this.blockReturned;
            }

            @Override
            public Block next() {
                if (this.blockReturned) {
                    return (Block)iterator.next();
                }
                this.blockReturned = true;
                return block;
            }
        };
    }

    public FunctionNode getFunction(Block block) {
        NodeIterator<LexicalContextNode> nodeIterator = new NodeIterator<LexicalContextNode>(LexicalContextNode.class);
        while (nodeIterator.hasNext()) {
            LexicalContextNode lexicalContextNode = (LexicalContextNode)nodeIterator.next();
            if (lexicalContextNode != block) continue;
            while (nodeIterator.hasNext()) {
                LexicalContextNode lexicalContextNode2 = (LexicalContextNode)nodeIterator.next();
                if (!(lexicalContextNode2 instanceof FunctionNode)) continue;
                return (FunctionNode)lexicalContextNode2;
            }
        }
        assert (false);
        return null;
    }

    public Block getCurrentBlock() {
        return this.getBlocks().next();
    }

    public FunctionNode getCurrentFunction() {
        for (int i = this.sp - 1; i >= 0; --i) {
            if (!(this.stack[i] instanceof FunctionNode)) continue;
            return (FunctionNode)this.stack[i];
        }
        return null;
    }

    public boolean isFunctionBody() {
        return this.getParentBlock() == null;
    }

    public FunctionNode getParentFunction(FunctionNode functionNode) {
        NodeIterator<FunctionNode> nodeIterator = new NodeIterator<FunctionNode>(FunctionNode.class);
        while (nodeIterator.hasNext()) {
            FunctionNode functionNode2 = (FunctionNode)nodeIterator.next();
            if (functionNode2 != functionNode) continue;
            return nodeIterator.hasNext() ? (FunctionNode)nodeIterator.next() : null;
        }
        assert (false);
        return null;
    }

    private BreakableNode getBreakable() {
        NodeIterator<BreakableNode> nodeIterator = new NodeIterator<BreakableNode>(BreakableNode.class, this.getCurrentFunction());
        while (nodeIterator.hasNext()) {
            BreakableNode breakableNode = (BreakableNode)nodeIterator.next();
            if (!breakableNode.isBreakableWithoutLabel()) continue;
            return breakableNode;
        }
        return null;
    }

    public boolean inLoop() {
        return this.getCurrentLoop() != null;
    }

    public LoopNode getCurrentLoop() {
        NodeIterator<LoopNode> nodeIterator = new NodeIterator<LoopNode>(LoopNode.class, this.getCurrentFunction());
        return nodeIterator.hasNext() ? (LoopNode)nodeIterator.next() : null;
    }

    public BreakableNode getBreakable(String string) {
        if (string != null) {
            LabelNode labelNode = this.findLabel(string);
            if (labelNode != null) {
                BreakableNode breakableNode = null;
                NodeIterator<BreakableNode> nodeIterator = new NodeIterator<BreakableNode>(BreakableNode.class, labelNode);
                while (nodeIterator.hasNext()) {
                    breakableNode = (BreakableNode)nodeIterator.next();
                }
                return breakableNode;
            }
            return null;
        }
        return this.getBreakable();
    }

    private LoopNode getContinueTo() {
        return this.getCurrentLoop();
    }

    public LoopNode getContinueTo(String string) {
        if (string != null) {
            LabelNode labelNode = this.findLabel(string);
            if (labelNode != null) {
                LoopNode loopNode = null;
                NodeIterator<LoopNode> nodeIterator = new NodeIterator<LoopNode>(LoopNode.class, labelNode);
                while (nodeIterator.hasNext()) {
                    loopNode = (LoopNode)nodeIterator.next();
                }
                return loopNode;
            }
            return null;
        }
        return this.getContinueTo();
    }

    public LabelNode findLabel(String string) {
        NodeIterator<LabelNode> nodeIterator = new NodeIterator<LabelNode>(LabelNode.class, this.getCurrentFunction());
        while (nodeIterator.hasNext()) {
            LabelNode labelNode = (LabelNode)nodeIterator.next();
            if (!labelNode.getLabelName().equals(string)) continue;
            return labelNode;
        }
        return null;
    }

    public boolean inUnprotectedSwitchContext() {
        LexicalContextNode lexicalContextNode;
        for (int i = this.sp - 1; i > 0 && !((lexicalContextNode = this.stack[i]) instanceof Block); --i) {
            if (!(lexicalContextNode instanceof SwitchNode)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[ ");
        for (int i = 0; i < this.sp; ++i) {
            LexicalContextNode lexicalContextNode = this.stack[i];
            stringBuilder.append(lexicalContextNode.getClass().getSimpleName());
            stringBuilder.append('@');
            stringBuilder.append(LexicalContext.id(lexicalContextNode));
            stringBuilder.append(':');
            if (lexicalContextNode instanceof FunctionNode) {
                FunctionNode functionNode = (FunctionNode)lexicalContextNode;
                Source source = functionNode.getSource();
                String string = source.toString();
                if (string.contains(File.pathSeparator)) {
                    string = string.substring(string.lastIndexOf(File.pathSeparator));
                }
                stringBuilder.append(string);
                stringBuilder.append(' ');
                stringBuilder.append(functionNode.getLineNumber());
            }
            stringBuilder.append(' ');
        }
        stringBuilder.append(" ==> ]");
        return stringBuilder.toString();
    }

    private static String id(Object object) {
        return String.format("0x%08x", System.identityHashCode(object));
    }

    private class NodeIterator<T extends LexicalContextNode>
    implements Iterator<T> {
        private int index;
        private T next;
        private final Class<T> clazz;
        private LexicalContextNode until;

        NodeIterator(Class<T> clazz) {
            this(clazz, null);
        }

        NodeIterator(Class<T> clazz, LexicalContextNode lexicalContextNode) {
            this.index = LexicalContext.this.sp - 1;
            this.clazz = clazz;
            this.until = lexicalContextNode;
            this.next = this.findNext();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public T next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            T t = this.next;
            this.next = this.findNext();
            return t;
        }

        private T findNext() {
            for (int i = this.index; i >= 0; --i) {
                LexicalContextNode lexicalContextNode = LexicalContext.this.stack[i];
                if (lexicalContextNode == this.until) {
                    return null;
                }
                if (!this.clazz.isAssignableFrom(lexicalContextNode.getClass())) continue;
                this.index = i - 1;
                return (T)lexicalContextNode;
            }
            return null;
        }
    }
}

