/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.js.parser.ir;

import com.oracle.js.parser.ir.ExportClauseNode;
import com.oracle.js.parser.ir.Expression;
import com.oracle.js.parser.ir.FromNode;
import com.oracle.js.parser.ir.LexicalContext;
import com.oracle.js.parser.ir.Node;
import com.oracle.js.parser.ir.VarNode;
import com.oracle.js.parser.ir.visitor.NodeVisitor;
import com.oracle.js.parser.ir.visitor.TranslatorNodeVisitor;

public class ExportNode
extends Node {
    private final ExportClauseNode exportClause;
    private final FromNode from;
    private final VarNode var;
    private final Expression expression;
    private final boolean isDefault;

    public ExportNode(long l, int n, int n2, ExportClauseNode exportClauseNode) {
        this(l, n, n2, exportClauseNode, null, null, null, false);
    }

    public ExportNode(long l, int n, int n2, FromNode fromNode) {
        this(l, n, n2, null, fromNode, null, null, false);
    }

    public ExportNode(long l, int n, int n2, ExportClauseNode exportClauseNode, FromNode fromNode) {
        this(l, n, n2, exportClauseNode, fromNode, null, null, false);
    }

    public ExportNode(long l, int n, int n2, Expression expression, boolean bl) {
        this(l, n, n2, null, null, null, expression, bl);
    }

    public ExportNode(long l, int n, int n2, VarNode varNode) {
        this(l, n, n2, null, null, varNode, null, false);
    }

    private ExportNode(long l, int n, int n2, ExportClauseNode exportClauseNode, FromNode fromNode, VarNode varNode, Expression expression, boolean bl) {
        super(l, n, n2);
        this.exportClause = exportClauseNode;
        this.from = fromNode;
        this.var = varNode;
        this.expression = expression;
        this.isDefault = bl;
    }

    private ExportNode(ExportNode exportNode, ExportClauseNode exportClauseNode, FromNode fromNode, VarNode varNode, Expression expression) {
        super(exportNode);
        this.isDefault = exportNode.isDefault;
        this.exportClause = exportClauseNode;
        this.from = fromNode;
        this.var = varNode;
        this.expression = expression;
    }

    public ExportClauseNode getExportClause() {
        return this.exportClause;
    }

    public FromNode getFrom() {
        return this.from;
    }

    public VarNode getVar() {
        return this.var;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public ExportNode setExportClause(ExportClauseNode exportClauseNode) {
        if (this.exportClause == exportClauseNode) {
            return this;
        }
        return new ExportNode(this, exportClauseNode, this.from, this.var, this.expression);
    }

    public ExportNode setFrom(FromNode fromNode) {
        if (this.from == fromNode) {
            return this;
        }
        return new ExportNode(this, this.exportClause, fromNode, this.var, this.expression);
    }

    public ExportNode setVar(VarNode varNode) {
        if (this.var == varNode) {
            return this;
        }
        return new ExportNode(this, this.exportClause, this.from, varNode, this.expression);
    }

    public ExportNode setExpression(Expression expression) {
        if (this.expression == expression) {
            return this;
        }
        return new ExportNode(this, this.exportClause, this.from, this.var, expression);
    }

    @Override
    public Node accept(NodeVisitor<? extends LexicalContext> nodeVisitor) {
        if (nodeVisitor.enterExportNode(this)) {
            ExportClauseNode exportClauseNode = this.exportClause == null ? null : (ExportClauseNode)this.exportClause.accept(nodeVisitor);
            FromNode fromNode = this.from == null ? null : (FromNode)this.from.accept(nodeVisitor);
            VarNode varNode = this.var == null ? null : (VarNode)this.var.accept(nodeVisitor);
            Expression expression = this.expression == null ? null : (Expression)this.expression.accept(nodeVisitor);
            return nodeVisitor.leaveExportNode(this.setExportClause(exportClauseNode).setFrom(fromNode).setVar(varNode).setExpression(expression));
        }
        return this;
    }

    @Override
    public <R> R accept(TranslatorNodeVisitor<? extends LexicalContext, R> translatorNodeVisitor) {
        return translatorNodeVisitor.enterExportNode(this);
    }

    @Override
    public void toString(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append("export ");
        if (this.isDefault) {
            stringBuilder.append("default ");
        }
        if (this.expression != null) {
            this.expression.toString(stringBuilder, bl);
            if (this.expression.isAssignment()) {
                stringBuilder.append(';');
            }
        } else {
            if (this.exportClause == null) {
                stringBuilder.append("* ");
            } else {
                this.exportClause.toString(stringBuilder, bl);
            }
            if (this.from != null) {
                this.from.toString(stringBuilder, bl);
            }
            stringBuilder.append(';');
        }
    }
}

