/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.js.parser;

public class TokenStream {
    private static final int INITIAL_SIZE = 256;
    private long[] buffer = new long[256];
    private int count = 0;
    private int in = 0;
    private int out = 0;
    private int base = 0;

    private int next(int n) {
        int n2 = n + 1;
        if (n2 >= this.buffer.length) {
            n2 = 0;
        }
        return n2;
    }

    private int index(int n) {
        int n2 = n - (this.base - this.out);
        if (n2 >= this.buffer.length) {
            n2 -= this.buffer.length;
        }
        return n2;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public boolean isFull() {
        return this.count == this.buffer.length;
    }

    public int count() {
        return this.count;
    }

    public int first() {
        return this.base;
    }

    public int last() {
        return this.base + this.count - 1;
    }

    public void removeLast() {
        if (this.count != 0) {
            --this.count;
            --this.in;
            if (this.in < 0) {
                this.in = this.buffer.length - 1;
            }
        }
    }

    public void put(long l) {
        if (this.count == this.buffer.length) {
            this.grow();
        }
        this.buffer[this.in] = l;
        ++this.count;
        this.in = this.next(this.in);
    }

    public long get(int n) {
        return this.buffer[this.index(n)];
    }

    public void commit(int n) {
        this.out = this.index(n);
        this.count -= n - this.base;
        this.base = n;
    }

    public void grow() {
        long[] lArray = new long[this.buffer.length * 2];
        if (this.in > this.out) {
            System.arraycopy(this.buffer, this.out, lArray, 0, this.count);
        } else {
            int n = this.buffer.length - this.out;
            System.arraycopy(this.buffer, this.out, lArray, 0, n);
            System.arraycopy(this.buffer, 0, lArray, n, this.count - n);
        }
        this.out = 0;
        this.in = this.count;
        this.buffer = lArray;
    }

    void reset() {
        this.base = 0;
        this.count = 0;
        this.out = 0;
        this.in = 0;
    }
}

