/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.util;

import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.modules.db.util.DriverListUtil;
import org.openide.util.NbBundle;

public class JdbcUrl
extends HashMap<String, String> {
    private JDBCDriver driver;
    private String url;
    private ArrayList<String> urlComponents;
    private ArrayList<String> staticComponents;
    private HashSet<String> supportedTokens = new HashSet();
    private HashSet<String> requiredTokens = new HashSet();
    private boolean parseUrl;
    public static final String TOKEN_DB = "<DB>";
    public static final String TOKEN_HOST = "<HOST>";
    public static final String TOKEN_PORT = "<PORT>";
    public static final String TOKEN_SERVERNAME = "<SERVERNAME>";
    public static final String TOKEN_ADDITIONAL = "<ADDITIONAL>";
    public static final String TOKEN_TNSNAME = "<TNSNAME>";
    public static final String TOKEN_SID = "<SID>";
    public static final String TOKEN_SERVICENAME = "<SERVICE>";
    public static final String TOKEN_DSN = "<DSN>";
    public static final String TOKEN_INSTANCE = "<INSTANCE>";
    private static final String OPTIONAL_START = "[";
    private static final String OPTIONAL_END = "]";
    private String name;
    private String displayName;
    private final String className;
    private String urlTemplate;
    private final String type;
    private String sampleUser;
    private String samplePassword;
    private String sampleUrl;

    public JdbcUrl(String name, String displayName, String className, String type, String urlTemplate, boolean parseUrl) {
        this.name = name;
        this.displayName = displayName;
        this.className = className;
        this.type = type;
        this.urlTemplate = urlTemplate;
        this.parseUrl = parseUrl;
        if (parseUrl) {
            this.extractUrlComponents();
        }
    }

    public JdbcUrl(String name, String displayName, String className, String type, String urlTemplate) {
        this(name, displayName, className, type, urlTemplate, false);
    }

    public JdbcUrl(JDBCDriver driver, String type, String urlTemplate) {
        this(driver.getName(), driver.getDisplayName(), driver.getClassName(), type, urlTemplate);
        this.driver = driver;
    }

    public JdbcUrl(JDBCDriver driver, String urlTemplate, boolean parseUrl) {
        this(driver.getName(), driver.getDisplayName(), driver.getClassName(), null, urlTemplate, parseUrl);
        this.driver = driver;
    }

    public JdbcUrl(JdbcUrl template, JDBCDriver driver) {
        this(template.getName(), template.displayName, template.getClassName(), template.getType(), template.getUrlTemplate(), template.isParseUrl());
        this.samplePassword = template.getSamplePassword();
        this.sampleUser = template.getSampleUser();
        this.sampleUrl = template.getSampleUrl();
        this.driver = driver;
    }

    public JdbcUrl(JDBCDriver driver) {
        this(driver, null, null);
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getClassName() {
        return this.className;
    }

    public String getUrlTemplate() {
        return this.urlTemplate;
    }

    public boolean isParseUrl() {
        return this.parseUrl;
    }

    public void setDriver(JDBCDriver driver) {
        this.driver = driver;
        this.name = driver.getName();
        this.displayName = driver.getDisplayName();
    }

    public JDBCDriver getDriver() {
        return this.driver;
    }

    public String getDisplayName() {
        String nameAndType = this.isEmpty(this.getType()) ? this.displayName : this.displayName + " (" + this.getType() + ")";
        if (this.driver != null && this.driver.getDisplayName() != null && !this.driver.getDisplayName().equals(this.displayName)) {
            if (nameAndType.startsWith(this.driver.getDisplayName())) {
                return nameAndType;
            }
            return NbBundle.getMessage(DriverListUtil.class, (String)"JDBC_URL_DRIVER_NAME", (Object)nameAndType, (Object)this.driver.getDisplayName());
        }
        return nameAndType;
    }

    public boolean supportsToken(String token) {
        return this.supportedTokens.contains(token);
    }

    public boolean requiresToken(String token) {
        return this.requiredTokens.contains(token);
    }

    private boolean hasAllRequiredTokens() {
        Set keySet = this.keySet();
        for (String token : this.requiredTokens) {
            if (keySet.contains(token)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int hash = 3;
        hash = 23 * hash + Objects.hashCode(this.urlTemplate);
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JdbcUrl other = (JdbcUrl)obj;
        if (!Objects.equals(this.driver, other.driver)) {
            return false;
        }
        if (this.parseUrl != other.parseUrl) {
            return false;
        }
        if (!Objects.equals(this.name, other.name)) {
            return false;
        }
        if (!Objects.equals(this.displayName, other.displayName)) {
            return false;
        }
        if (!Objects.equals(this.className, other.className)) {
            return false;
        }
        if (!Objects.equals(this.urlTemplate, other.urlTemplate)) {
            return false;
        }
        return Objects.equals(this.type, other.type);
    }

    protected boolean isEmpty(String str) {
        return str == null || str.equals("");
    }

    private MalformedURLException createMalformedURLException() {
        return new MalformedURLException(NbBundle.getMessage(JdbcUrl.class, (String)"ERR_InvalidURL", (Object)this.getUrlTemplate()));
    }

    private boolean isOptionalStart(String component) {
        return component.equals(OPTIONAL_START);
    }

    private boolean isOptionalStart(char ch) {
        return ch == '[';
    }

    private boolean isOptionalEnd(String component) {
        return component.equals(OPTIONAL_END);
    }

    private boolean isOptionalEnd(char ch) {
        return ch == ']';
    }

    private boolean isToken(String component) {
        return component.startsWith("<") && component.endsWith(">");
    }

    private boolean isTokenStart(char ch) {
        return ch == '<';
    }

    private boolean isTokenEnd(char ch) {
        return ch == '>';
    }

    public String getUrl() {
        if (!this.isParseUrl()) {
            return this.url;
        }
        if (!this.hasAllRequiredTokens()) {
            return "";
        }
        int length = this.urlComponents.size();
        UrlSection section = new UrlSection();
        for (int i = 0; i < length; ++i) {
            String component = this.urlComponents.get(i);
            if (this.isOptionalStart(component)) {
                section.setOptionalChild(new OptionalSection());
                section = section.getOptionalChild();
                continue;
            }
            if (this.isOptionalEnd(component)) {
                UrlSection parent = ((OptionalSection)section).getParent();
                parent.addText(section.getText());
                section = parent;
                continue;
            }
            if (this.supportedTokens.contains(component)) {
                section.setValue((String)this.get(component));
                continue;
            }
            section.addText(component);
        }
        return section.getText();
    }

    public void setUrl(String url) throws MalformedURLException {
        if (!this.isParseUrl()) {
            this.url = url;
            return;
        }
        this.clear();
        UrlBuffer buf = new UrlBuffer(url);
        int numComponents = this.urlComponents.size();
        for (int compIndex = 0; compIndex < numComponents; ++compIndex) {
            String component = this.urlComponents.get(compIndex);
            if (this.isToken(component)) {
                String value = this.getTokenValue(buf);
                if (this.isEmpty(value)) {
                    throw this.createMalformedURLException();
                }
                this.put(component, value);
                continue;
            }
            if (this.isOptionalStart(component)) {
                compIndex = this.readOptionalValue(buf, compIndex + 1);
                continue;
            }
            String substring = buf.urlSubString();
            if (substring == null || !substring.startsWith(component)) {
                throw this.createMalformedURLException();
            }
            this.skipStaticText(buf, component);
        }
    }

    private void extractUrlComponents() {
        this.urlComponents = new ArrayList();
        int length = this.urlTemplate.length();
        boolean isToken = false;
        int optionalLevel = 0;
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            char ch = this.urlTemplate.charAt(i);
            if (this.isTokenStart(ch)) {
                assert (!isToken);
                buf = this.addComponent(buf);
                buf.append(ch);
                isToken = true;
                continue;
            }
            if (this.isTokenEnd(ch)) {
                assert (isToken);
                buf.append(ch);
                String token = buf.toString();
                if (optionalLevel == 0) {
                    this.requiredTokens.add(token);
                }
                this.supportedTokens.add(token);
                buf = this.addComponent(buf);
                isToken = false;
                continue;
            }
            if (this.isOptionalStart(ch)) {
                ++optionalLevel;
                buf = this.addComponent(buf);
                this.urlComponents.add(OPTIONAL_START);
                continue;
            }
            if (this.isOptionalEnd(ch)) {
                --optionalLevel;
                buf = this.addComponent(buf);
                this.urlComponents.add(OPTIONAL_END);
                continue;
            }
            buf.append(ch);
        }
        this.setStaticComponents();
        this.validateUrlComponents();
    }

    private void setStaticComponents() {
        this.staticComponents = new ArrayList();
        for (String component : this.urlComponents) {
            if (this.isToken(component) || this.isOptionalStart(component) || this.isOptionalEnd(component)) continue;
            this.staticComponents.add(component);
        }
    }

    private StringBuffer addComponent(StringBuffer text) {
        if (text.length() > 0) {
            this.urlComponents.add(text.toString());
            return new StringBuffer();
        }
        return text;
    }

    private void validateUrlComponents() {
        int length = this.urlComponents.size();
        int optionalCount = 0;
        for (int i = 0; i < length; ++i) {
            String component = this.urlComponents.get(i);
            if (component.startsWith("<")) {
                assert (this.isToken(component));
                if (i + 1 != length) assert (!this.isToken(this.urlComponents.get(i + 1)));
                continue;
            }
            if (this.isOptionalStart(component)) {
                ++optionalCount;
                continue;
            }
            if (!this.isOptionalEnd(component)) continue;
            --optionalCount;
        }
        assert (optionalCount == 0);
    }

    private int readOptionalValue(UrlBuffer buf, int componentIndex) throws MalformedURLException {
        int numComponents = this.urlComponents.size();
        boolean valueExpected = false;
        while (componentIndex < numComponents) {
            String component = this.urlComponents.get(componentIndex);
            if (this.isOptionalEnd(component)) {
                return componentIndex;
            }
            if (this.isOptionalStart(component)) {
                componentIndex = this.readOptionalValue(buf, componentIndex + 1);
            } else if (this.isToken(component)) {
                String value = this.getTokenValue(buf);
                if (!this.isEmpty(value)) {
                    this.put(component, value);
                } else if (valueExpected) {
                    throw this.createMalformedURLException();
                }
            } else {
                int optCount = 0;
                String substring = buf.urlSubString();
                if (substring == null || !substring.startsWith(component)) {
                    do {
                        if (this.isOptionalStart(component = this.urlComponents.get(++componentIndex))) {
                            ++optCount;
                        }
                        if (!this.isOptionalEnd(component) || optCount <= 0) continue;
                        --optCount;
                        component = this.urlComponents.get(++componentIndex);
                    } while (!this.isOptionalEnd(component) || optCount > 0);
                    return componentIndex;
                }
                valueExpected = true;
                this.skipStaticText(buf, component);
            }
            ++componentIndex;
        }
        throw this.createMalformedURLException();
    }

    private String getTokenValue(UrlBuffer buf) {
        if (buf.isEOF()) {
            return null;
        }
        int index = this.findStaticText(buf);
        String value = null;
        if (index < 0) {
            value = buf.urlSubString();
            buf.incrementIndex(value.length());
            return value;
        }
        value = buf.urlSubString().substring(0, index);
        buf.incrementIndex(index);
        return value;
    }

    private int findStaticText(UrlBuffer urlbuf) {
        if (urlbuf.isEOF()) {
            return -1;
        }
        int index = -1;
        String staticStr = urlbuf.currentStatic();
        while (index < 0 && staticStr != null) {
            index = urlbuf.urlSubString().indexOf(staticStr);
            if (index >= 0) continue;
            staticStr = urlbuf.nextStatic();
        }
        return index;
    }

    private void skipStaticText(UrlBuffer buf, String staticComponent) {
        assert (buf.currentStatic() != null);
        assert (buf.currentStatic().equals(staticComponent));
        buf.nextStatic();
        buf.incrementIndex(staticComponent.length());
    }

    @Override
    public String toString() {
        return "JdbcUrl[name='" + this.name + "',displayName='" + this.displayName + "',className='" + this.className + "',type='" + this.type + "',urlTemplate='" + this.urlTemplate + "'parseUrl,=" + this.parseUrl + OPTIONAL_END;
    }

    public String getSampleUser() {
        return this.sampleUser;
    }

    public String getSamplePassword() {
        return this.samplePassword;
    }

    public String getSampleUrl() {
        return this.sampleUrl;
    }

    void setSampleUser(String sampleUser) {
        this.sampleUser = sampleUser;
    }

    void setSamplePassword(String samplePassword) {
        this.samplePassword = samplePassword;
    }

    void setSampleUrl(String sampleUrl) {
        this.sampleUrl = sampleUrl;
    }

    private class OptionalSection
    extends UrlSection {
        private boolean hasValue;
        UrlSection parent;

        private OptionalSection() {
        }

        public void setParent(UrlSection parent) {
            this.parent = parent;
        }

        private UrlSection getParent() {
            return this.parent;
        }

        @Override
        public void setValue(String value) {
            if (!JdbcUrl.this.isEmpty(value)) {
                this.hasValue = true;
                super.setValue(value);
            }
        }

        @Override
        public String getText() {
            if (this.hasValue) {
                return super.getText();
            }
            return "";
        }
    }

    private class UrlSection {
        StringBuffer textBuf = new StringBuffer();
        OptionalSection optionalChild;

        private UrlSection() {
        }

        public String getText() {
            return this.textBuf.toString();
        }

        public void addText(String text) {
            if (text != null) {
                this.textBuf.append(text);
            }
        }

        public void setOptionalChild(OptionalSection child) {
            this.optionalChild = child;
            child.setParent(this);
        }

        public OptionalSection getOptionalChild() {
            return this.optionalChild;
        }

        public void setValue(String text) {
            this.addText(text);
        }
    }

    private class UrlBuffer {
        int index = 0;
        int staticsIndex = 0;
        int length;
        String url;

        private UrlBuffer(String url) {
            this.url = url;
            this.length = url.length();
        }

        private String getFullUrl() {
            return this.url;
        }

        private String urlSubString() {
            if (this.index < this.length) {
                return this.url.substring(this.index);
            }
            return null;
        }

        private void incrementIndex(int index) {
            this.index += index;
        }

        private boolean isEOF() {
            return this.index >= this.length;
        }

        private String currentStatic() {
            if (this.staticsIndex < JdbcUrl.this.staticComponents.size()) {
                return (String)JdbcUrl.this.staticComponents.get(this.staticsIndex);
            }
            return null;
        }

        private String nextStatic() {
            ++this.staticsIndex;
            return this.currentStatic();
        }
    }
}

