/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.bugzilla.core;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaAttribute;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaTaskDataHandler;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.osgi.util.NLS;

public class BugzillaUtil {
    private static final Pattern TIME_STAMP_PATTERN = Pattern.compile("[0-9]{4}-[0-9]{2}-[0-9]{2} [0-9]{2}:[0-9]{2}:[0-9]{2}", 2);

    private static boolean getParamValue(TaskRepository taskRepository, String propertyName, boolean trueIfUndefined) {
        String useParam = taskRepository.getProperty(propertyName);
        boolean result = trueIfUndefined ? useParam == null || useParam != null && useParam.equals("true") : useParam != null && useParam.equals("true");
        return result;
    }

    public static void addAttributeIfUsed(BugzillaAttribute constant, String propertyName, TaskRepository taskRepository, TaskData existingReport, boolean createWhenNull) {
        if (BugzillaUtil.getParamValue(taskRepository, propertyName, createWhenNull)) {
            BugzillaTaskDataHandler.createAttribute(existingReport, constant);
        }
    }

    public static void createAttributeWithKindDefaultIfUsed(String parsedText, BugzillaAttribute tag, TaskData repositoryTaskData, String propertyName, boolean defaultWhenNull) {
        TaskAttribute attribute = repositoryTaskData.getRoot().getMappedAttribute(tag.getKey());
        if (attribute == null) {
            attribute = BugzillaTaskDataHandler.createAttribute(repositoryTaskData, tag);
            attribute.setValue(parsedText);
        } else {
            attribute.addValue(parsedText);
        }
        if (BugzillaAttribute.QA_CONTACT.equals((Object)tag)) {
            attribute.getMetaData().setKind(null);
        } else if (BugzillaUtil.getParamValue(repositoryTaskData.getAttributeMapper().getTaskRepository(), propertyName, defaultWhenNull)) {
            attribute.getMetaData().setKind("task.common.kind.default");
        } else {
            attribute.getMetaData().setKind(null);
        }
    }

    public static boolean getTaskPropertyWithDefaultTrue(TaskRepository taskRepository, String property) {
        String useParam = taskRepository.getProperty(property);
        return useParam == null || useParam != null && useParam.equals("true");
    }

    public static String removeTimezone(String timeWithTimezone) throws CoreException {
        Matcher matcher = TIME_STAMP_PATTERN.matcher(timeWithTimezone);
        if (matcher.find()) {
            return matcher.group();
        }
        throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.bugzilla", NLS.bind((String)"{0} is not a valid time", (Object)timeWithTimezone)));
    }
}

