/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.payara.eecommon.api;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.java.classpath.GlobalPathRegistryEvent;
import org.netbeans.api.java.classpath.GlobalPathRegistryListener;
import org.netbeans.modules.payara.tooling.utils.StringPrefixTree;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Annotatable;
import org.openide.text.Annotation;
import org.openide.text.Line;
import org.openide.util.NbBundle;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;

public class LogHyperLinkSupport {
    private Map<Link, Link> links = Collections.synchronizedMap(new HashMap());
    private Annotation errAnnot;

    public Link getLink(String errorMsg, String path, int line) {
        Link newLink = new Link(errorMsg, path, line);
        Link cachedLink = this.links.get(newLink);
        if (cachedLink != null) {
            return cachedLink;
        }
        this.links.put(newLink, newLink);
        return newLink;
    }

    public void detachAnnotation() {
        if (this.errAnnot != null) {
            this.errAnnot.detach();
        }
    }

    public static class AppServerLogSupport
    extends LogHyperLinkSupport {
        private String context;
        private String prevMessage = null;
        private static final String STANDARD_CONTEXT = "StandardContext[";
        private static final int STANDARD_CONTEXT_LENGTH = "StandardContext[".length();
        private final GlobalPathRegistry globalPathReg;
        private final PathAccess pathAccess;

        public AppServerLogSupport(String catalinaWork, String webAppContext) {
            this.context = webAppContext;
            this.globalPathReg = GlobalPathRegistry.getDefault();
            this.pathAccess = new PathAccess(this.globalPathReg, catalinaWork, webAppContext);
        }

        public LineInfo analyzeLine(String logLine) {
            String path = null;
            int line = -1;
            String message = null;
            boolean error = false;
            boolean accessible = false;
            int lineLength = (logLine = logLine.trim()).length();
            if (lineLength > 0 && '/' == logLine.charAt(0)) {
                error = true;
                int colonIdx = logLine.indexOf(58);
                if (colonIdx > -1) {
                    int nextColonIdx;
                    path = logLine.substring(0, colonIdx);
                    accessible = true;
                    if (lineLength > colonIdx && (nextColonIdx = logLine.indexOf(58, colonIdx + 1)) > -1 && nextColonIdx > colonIdx) {
                        String lineNum = logLine.substring(colonIdx + 1, nextColonIdx);
                        try {
                            line = Integer.valueOf(lineNum);
                        }
                        catch (NumberFormatException ex) {
                            accessible = true;
                        }
                        if (lineLength > nextColonIdx) {
                            message = logLine.substring(nextColonIdx + 1, lineLength);
                        }
                    }
                }
            } else if (lineLength > 3 && Character.isLetter(logLine.charAt(0)) && logLine.charAt(1) == ':' && logLine.charAt(2) == '\\') {
                error = true;
                int secondColonIdx = logLine.indexOf(58, 2);
                if (secondColonIdx > -1) {
                    int thirdColonIdx;
                    path = logLine.substring(0, secondColonIdx);
                    accessible = true;
                    if (lineLength > secondColonIdx && (thirdColonIdx = logLine.indexOf(58, secondColonIdx + 1)) > -1 && thirdColonIdx > secondColonIdx) {
                        String lineNum = logLine.substring(secondColonIdx + 1, thirdColonIdx);
                        try {
                            line = Integer.valueOf(lineNum);
                        }
                        catch (NumberFormatException ex) {
                            accessible = true;
                        }
                        if (lineLength > thirdColonIdx) {
                            message = logLine.substring(thirdColonIdx + 1, lineLength);
                        }
                    }
                }
            } else if (logLine.startsWith("at ") && lineLength > 3) {
                String classWithMethod;
                int lastDotIdx;
                error = true;
                int parenthIdx = logLine.indexOf(40);
                if (parenthIdx > 2 && (lastDotIdx = (classWithMethod = logLine.substring(3, parenthIdx)).lastIndexOf(46)) > -1) {
                    int firstDolarIdx;
                    int lastParenthIdx = logLine.lastIndexOf(41);
                    int lastColonIdx = logLine.lastIndexOf(58);
                    if (lastParenthIdx > -1 && lastColonIdx > -1 && lastParenthIdx > lastColonIdx) {
                        String lineNum = logLine.substring(lastColonIdx + 1, lastParenthIdx);
                        try {
                            line = Integer.valueOf(lineNum);
                        }
                        catch (NumberFormatException ex) {
                            error = true;
                        }
                        message = this.prevMessage;
                    }
                    String className = classWithMethod.substring(0, (firstDolarIdx = classWithMethod.indexOf(36)) > -1 ? firstDolarIdx : lastDotIdx);
                    PathAccess.ClassAccess access = this.pathAccess.find(className);
                    accessible = access.accessible;
                    path = access.path;
                }
            } else {
                this.prevMessage = logLine;
                int stdContextIdx = logLine.indexOf(STANDARD_CONTEXT);
                int lBracketIdx = -1;
                if (stdContextIdx > -1) {
                    lBracketIdx = stdContextIdx + STANDARD_CONTEXT_LENGTH;
                }
                int rBracketIdx = logLine.indexOf(93);
                if (lBracketIdx > -1 && rBracketIdx > -1 && rBracketIdx > lBracketIdx) {
                    this.context = logLine.substring(lBracketIdx, rBracketIdx);
                }
            }
            return new LineInfo(path, line, message, error, accessible);
        }

        private static class PathAccess {
            private static final StringPrefixTree<ClassAccess> accessCache = new StringPrefixTree(true);
            private final GlobalPathRegistry globalPathRegistry;
            private final String serverRoot;
            private final String appContext;

            PathAccess(GlobalPathRegistry globalPathRegistry, String serverRoot, String appContext) {
                this.globalPathRegistry = globalPathRegistry;
                this.serverRoot = serverRoot;
                this.appContext = appContext;
                this.globalPathRegistry.addGlobalPathRegistryListener((GlobalPathRegistryListener)new PathRegistryListener());
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            ClassAccess find(String className) {
                ClassAccess result;
                StringPrefixTree<ClassAccess> stringPrefixTree = accessCache;
                synchronized (stringPrefixTree) {
                    result = (ClassAccess)accessCache.match((CharSequence)className);
                }
                if (result == null) {
                    boolean accessible;
                    String path = className.replace('.', '/') + ".java";
                    if (className.startsWith("org.apache.jsp.") && this.appContext != null) {
                        String contextPath = this.appContext.equals("/") ? "/_" : this.appContext;
                        path = this.serverRoot + contextPath + "/" + path;
                        accessible = new File(path).exists();
                    } else {
                        FileObject resource = this.globalPathRegistry.findResource(path);
                        accessible = resource != null;
                    }
                    StringPrefixTree<ClassAccess> stringPrefixTree2 = accessCache;
                    synchronized (stringPrefixTree2) {
                        result = (ClassAccess)accessCache.match((CharSequence)className);
                        if (result == null) {
                            result = new ClassAccess(accessible, path);
                            accessCache.add(className, (Object)result);
                        }
                    }
                }
                return result;
            }

            private static class PathRegistryListener
            implements GlobalPathRegistryListener {
                private PathRegistryListener() {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void pathsAdded(GlobalPathRegistryEvent event) {
                    StringPrefixTree stringPrefixTree = accessCache;
                    synchronized (stringPrefixTree) {
                        accessCache.clear();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void pathsRemoved(GlobalPathRegistryEvent event) {
                    StringPrefixTree stringPrefixTree = accessCache;
                    synchronized (stringPrefixTree) {
                        accessCache.clear();
                    }
                }
            }

            private static class ClassAccess {
                boolean accessible;
                String path;

                ClassAccess(boolean accessible, String path) {
                    this.accessible = accessible;
                    this.path = path;
                }
            }
        }
    }

    public class Link
    implements OutputListener {
        private String msg;
        private String path;
        private int line;
        private int hashCode = 0;

        Link(String msg, String path, int line) {
            this.msg = msg;
            this.path = path;
            this.line = line;
        }

        public int hashCode() {
            if (this.hashCode == 0) {
                int result = 17;
                result = 37 * result + this.line;
                result = 37 * result + (this.path != null ? this.path.hashCode() : 0);
                this.hashCode = result = 37 * result + (this.msg != null ? this.msg.hashCode() : 0);
            }
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof Link) {
                Link anotherLink = (Link)obj;
                if ((this.msg != null && this.msg.equals(anotherLink.msg) || this.msg == anotherLink.msg) && (this.path != null && this.path.equals(anotherLink.path) || this.path == anotherLink.path) && this.line == anotherLink.line) {
                    return true;
                }
            }
            return false;
        }

        public void outputLineAction(OutputEvent ev) {
            FileObject sourceFile = GlobalPathRegistry.getDefault().findResource(this.path);
            if (sourceFile == null) {
                sourceFile = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)new File(this.path)));
            }
            DataObject dataObject = null;
            if (sourceFile != null) {
                try {
                    dataObject = DataObject.find((FileObject)sourceFile);
                }
                catch (DataObjectNotFoundException ex) {
                    ErrorManager.getDefault().notify(1, (Throwable)ex);
                }
            }
            if (dataObject != null) {
                String errorMsg;
                Line errorLine;
                EditorCookie editorCookie = (EditorCookie)dataObject.getLookup().lookup(EditorCookie.class);
                if (editorCookie == null) {
                    return;
                }
                editorCookie.open();
                try {
                    errorLine = editorCookie.getLineSet().getCurrent(this.line - 1);
                }
                catch (IndexOutOfBoundsException ex) {
                    return;
                }
                if (LogHyperLinkSupport.this.errAnnot != null) {
                    LogHyperLinkSupport.this.errAnnot.detach();
                }
                if ((errorMsg = this.msg) == null || errorMsg.length() == 0) {
                    errorMsg = NbBundle.getMessage(Link.class, (String)"MSG_ExceptionOccurred");
                }
                LogHyperLinkSupport.this.errAnnot = new ErrorAnnotation(errorMsg);
                LogHyperLinkSupport.this.errAnnot.attach((Annotatable)errorLine);
                LogHyperLinkSupport.this.errAnnot.moveToFront();
                errorLine.show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FOCUS);
            }
        }

        public void outputLineCleared(OutputEvent ev) {
            if (LogHyperLinkSupport.this.errAnnot != null) {
                LogHyperLinkSupport.this.errAnnot.detach();
            }
            if (!LogHyperLinkSupport.this.links.isEmpty()) {
                LogHyperLinkSupport.this.links.clear();
            }
        }

        public void outputLineSelected(OutputEvent ev) {
        }
    }

    static class ErrorAnnotation
    extends Annotation {
        private String shortDesc = null;

        public ErrorAnnotation(String desc) {
            this.shortDesc = desc;
        }

        public String getAnnotationType() {
            return "org-netbeans-modules-j2ee-sunserver";
        }

        public String getShortDescription() {
            return this.shortDesc;
        }
    }

    public static class LineInfo {
        private String path;
        private int line;
        private String message;
        private boolean error;
        private boolean accessible;

        public LineInfo(String path, int line, String message, boolean error, boolean accessible) {
            this.path = path;
            this.line = line;
            this.message = message;
            this.error = error;
            this.accessible = accessible;
        }

        public String path() {
            return this.path;
        }

        public int line() {
            return this.line;
        }

        public String message() {
            return this.message;
        }

        public boolean isError() {
            return this.error;
        }

        public boolean isAccessible() {
            return this.accessible;
        }

        public String toString() {
            return "path=" + this.path + " line=" + this.line + " message=" + this.message + " isError=" + this.error + " isAccessible=" + this.accessible;
        }
    }
}

