/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.disco.archive;

import com.google.common.base.MoreObjects;
import java.io.File;
import java.io.IOException;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.netbeans.modules.java.disco.archive.CommonsUnzip;
import org.openide.windows.InputOutput;

public class JDKCommonsUnzip
extends CommonsUnzip {
    private static final File[] EMPTY_FILES = new File[0];

    @Override
    public void uncompress(File zip, File targetDir, InputOutput io) throws IOException {
        super.uncompress(zip, targetDir, io);
        File bin = JDKCommonsUnzip.findBin(targetDir);
        if (bin != null) {
            io.getOut().println("Making sure java is executable.");
            for (File exe : (File[])MoreObjects.firstNonNull((Object)bin.listFiles(), (Object)EMPTY_FILES)) {
                if (!exe.isFile()) continue;
                exe.setExecutable(true);
            }
        }
        io.getOut().println("Done.");
    }

    public static @Nullable File findBin(File outputDir) {
        for (File f : (File[])MoreObjects.firstNonNull((Object)outputDir.listFiles(), (Object)EMPTY_FILES)) {
            if (!f.isDirectory() || !f.getName().equals("bin")) continue;
            return f;
        }
        for (File f : (File[])MoreObjects.firstNonNull((Object)outputDir.listFiles(), (Object)EMPTY_FILES)) {
            File sub;
            if (!f.isDirectory() || (sub = JDKCommonsUnzip.findBin(f)) == null) continue;
            return sub;
        }
        return null;
    }
}

