/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cpplite.debugger;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.extexecution.base.ExplicitProcessParameters;
import org.openide.util.Exceptions;

public final class CPPLiteDebuggerConfig {
    private final List<String> executable;
    private final ExplicitProcessParameters processParameters;
    @NullAllowed
    private final Long processId;
    private final String debugger;

    public CPPLiteDebuggerConfig(List<String> executable, ExplicitProcessParameters processParameters, @NullAllowed Long processId, String debugger) {
        this.processParameters = processParameters;
        this.processId = processId;
        this.debugger = debugger;
        if (processParameters.isArgReplacement()) {
            this.executable = new ArrayList<String>();
            this.executable.add(executable.get(0));
            if (processParameters.getArguments() != null) {
                this.executable.addAll(processParameters.getArguments());
            }
        } else if (processParameters.getArguments() != null) {
            this.executable = new ArrayList<String>();
            this.executable.addAll(executable);
            this.executable.addAll(processParameters.getArguments());
        } else {
            this.executable = executable;
        }
        if (processParameters.getLauncherArguments() != null) {
            Exceptions.printStackTrace((Throwable)new IllegalStateException("Launcher arguments " + processParameters.getLauncherArguments() + " can not be accepted by CPPLite debugger"));
        }
    }

    public String getDisplayName() {
        return !this.executable.isEmpty() ? this.executable.get(0) : "<empty>";
    }

    public List<String> getExecutable() {
        return this.executable;
    }

    public ExplicitProcessParameters getProcessParameters() {
        return this.processParameters;
    }

    public boolean isAttach() {
        return this.processId != null;
    }

    public long getAttachProcessId() {
        if (this.processId == null) {
            throw new IllegalStateException("No process to attach to.");
        }
        return this.processId;
    }

    public String getDebugger() {
        return this.debugger;
    }
}

