/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf.codecoverage;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.ToolTipManager;
import org.openide.awt.GraphicsUtils;

public class CoverageBar
extends JComponent {
    private static final Color NOT_COVERED_LIGHT = new Color(255, 160, 160);
    private static final Color NOT_COVERED_DARK = new Color(180, 50, 50);
    private static final Color COVERED_LIGHT = new Color(160, 255, 160);
    private static final Color COVERED_DARK = new Color(30, 180, 30);
    private boolean emphasize;
    private boolean selected;
    private float coveragePercentage;
    private int totalLines;
    private int executedLines;
    private int partialLines;
    private int inferredLines;
    private BufferedImage textImage;
    private BufferedImage dropShadowImage;
    private static final Color TEXT_BLUR_COLOR = Color.WHITE;
    private static final Color TEXT_COLOR = Color.WHITE;
    private static final int KERNEL_SIZE = 3;
    private static final float BLUR_FACTOR = 0.1f;
    private static final int SHIFT_X = 0;
    private static final int SHIFT_Y = 1;
    private ConvolveOp blur;

    public CoverageBar() {
        this.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if ((e.getChangeFlags() & 4L) != 0L) {
                    if (CoverageBar.this.isShowing()) {
                        ToolTipManager.sharedInstance().registerComponent(CoverageBar.this);
                    } else {
                        ToolTipManager.sharedInstance().unregisterComponent(CoverageBar.this);
                    }
                }
            }
        });
        this.updateUI();
    }

    public float getCoveragePercentage() {
        return this.coveragePercentage;
    }

    public void setCoveragePercentage(float coveragePercentage) {
        this.coveragePercentage = coveragePercentage;
        this.repaint();
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public boolean isEmphasize() {
        return this.emphasize;
    }

    public void setEmphasize(boolean emphasize) {
        this.emphasize = emphasize;
    }

    private String getString() {
        return String.format("%.2f %%", Float.valueOf(this.coveragePercentage));
    }

    @Override
    public boolean isOpaque() {
        return true;
    }

    @Override
    public final void updateUI() {
        Font f = new JLabel().getFont();
        f = new Font(f.getName(), 1, f.getSize());
        this.setFont(f);
        this.revalidate();
        this.repaint();
    }

    @Override
    public void paint(Graphics g) {
        GraphicsUtils.configureDefaultRenderingHints((Graphics)g);
        super.paint(g);
    }

    @Override
    protected void paintComponent(Graphics g) {
        int height;
        int width;
        if (!(g instanceof Graphics2D)) {
            return;
        }
        int barRectWidth = width = this.getWidth();
        int barRectHeight = height = this.getHeight();
        if (barRectWidth <= 0 || barRectHeight <= 0) {
            return;
        }
        int amountFull = (int)((float)barRectWidth * this.coveragePercentage / 100.0f);
        Graphics2D g2 = (Graphics2D)g;
        g2.setColor(this.getBackground());
        Color notCoveredLight = NOT_COVERED_LIGHT;
        Color notCoveredDark = NOT_COVERED_DARK;
        Color coveredLight = COVERED_LIGHT;
        Color coveredDark = COVERED_DARK;
        if (this.emphasize) {
            coveredDark = coveredDark.darker();
        } else if (this.selected) {
            coveredLight = coveredLight.brighter();
            coveredDark = coveredDark.darker();
        }
        if (this.emphasize) {
            notCoveredDark = notCoveredDark.darker();
        } else if (this.selected) {
            notCoveredLight = notCoveredLight.brighter();
            notCoveredDark = notCoveredDark.darker();
        }
        g2.setPaint(new GradientPaint(0.0f, 0.0f, notCoveredLight, 0.0f, height / 2, notCoveredDark));
        g2.fillRect(amountFull, 1, width - 1, height / 2);
        g2.setPaint(new GradientPaint(0.0f, height / 2, notCoveredDark, 0.0f, 2 * height, notCoveredLight));
        g2.fillRect(amountFull, height / 2, width - 1, height / 2);
        g2.setColor(this.getForeground());
        g2.setPaint(new GradientPaint(0.0f, 0.0f, coveredLight, 0.0f, height / 2, coveredDark));
        g2.fillRect(1, 1, amountFull, height / 2);
        g2.setPaint(new GradientPaint(0.0f, height / 2, coveredDark, 0.0f, 2 * height, coveredLight));
        g2.fillRect(1, height / 2, amountFull, height / 2);
        Rectangle oldClip = g2.getClipBounds();
        if (this.coveragePercentage > 0.0f) {
            g2.setColor(coveredDark);
            g2.clipRect(0, 0, amountFull + 1, height);
            g2.drawRect(0, 0, width - 1, height - 1);
        }
        if (this.coveragePercentage < 100.0f) {
            g2.setColor(notCoveredDark);
            g2.setClip(oldClip);
            g2.clipRect(amountFull, 0, width, height);
            g2.drawRect(0, 0, width - 1, height - 1);
        }
        g2.setClip(oldClip);
        g2.setFont(this.getFont());
        this.paintDropShadowText(g2, barRectWidth, barRectHeight);
    }

    @Override
    public Dimension getPreferredSize() {
        int stringHeight;
        Insets border = this.getInsets();
        FontMetrics fontSizer = this.getFontMetrics(this.getFont());
        Dimension size = new Dimension(146, 12);
        String string = this.getString();
        int stringWidth = fontSizer.stringWidth(string);
        if (stringWidth > size.width) {
            size.width = stringWidth;
        }
        if ((stringHeight = fontSizer.getHeight() + fontSizer.getDescent()) > size.height) {
            size.height = stringHeight;
        }
        size.width += border.left + border.right;
        size.height += border.top + border.bottom;
        return size;
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension pref = this.getPreferredSize();
        pref.width = 40;
        return pref;
    }

    @Override
    public Dimension getMaximumSize() {
        Dimension pref = this.getPreferredSize();
        pref.width = Short.MAX_VALUE;
        return pref;
    }

    @Override
    public int getBaseline(int w, int h) {
        FontMetrics fm = this.getFontMetrics(this.getFont());
        return h - fm.getDescent() - (h - fm.getHeight()) / 2;
    }

    private void paintDropShadowText(Graphics g, int w, int h) {
        if (this.textImage == null) {
            this.textImage = new BufferedImage(w, h, 2);
            this.dropShadowImage = new BufferedImage(w, h, 2);
        }
        Graphics2D textImageG = this.textImage.createGraphics();
        textImageG.setComposite(AlphaComposite.Clear);
        textImageG.fillRect(0, 0, w, h);
        textImageG.setComposite(AlphaComposite.SrcOver);
        textImageG.setColor(TEXT_BLUR_COLOR);
        this.paintText(textImageG, w, h);
        textImageG.dispose();
        Graphics2D blurryImageG = this.dropShadowImage.createGraphics();
        blurryImageG.setComposite(AlphaComposite.Clear);
        blurryImageG.fillRect(0, 0, w, h);
        blurryImageG.setComposite(AlphaComposite.SrcOver);
        if (this.blur == null) {
            int kw = 3;
            int kh = 3;
            float blurFactor = 0.1f;
            float[] kernelData = new float[kw * kh];
            for (int i = 0; i < kernelData.length; ++i) {
                kernelData[i] = blurFactor;
            }
            this.blur = new ConvolveOp(new Kernel(kw, kh, kernelData));
        }
        blurryImageG.drawImage(this.textImage, this.blur, 0, 1);
        if (this.emphasize) {
            blurryImageG.setColor(Color.YELLOW);
        } else {
            blurryImageG.setColor(TEXT_COLOR);
        }
        blurryImageG.setFont(this.getFont());
        this.paintText(blurryImageG, w, h);
        blurryImageG.dispose();
        g.drawImage(this.dropShadowImage, 0, 0, null);
    }

    private void paintText(Graphics g, int w, int h) {
        g.setFont(this.getFont());
        String text = this.getString();
        FontMetrics fm = g.getFontMetrics();
        int textWidth = fm.stringWidth(text);
        g.drawString(text, (w - textWidth) / 2, h - fm.getDescent() - (h - fm.getHeight()) / 2);
    }

    public void setStats(int totalLines, int executedLines, int partialLines, int inferredLines) {
        this.totalLines = totalLines;
        this.executedLines = executedLines;
        this.partialLines = partialLines;
        this.inferredLines = inferredLines;
    }

    @Override
    public String getToolTipText(MouseEvent arg0) {
        StringBuilder sb = new StringBuilder();
        sb.append("<html><body>");
        sb.append("Total Lines: ");
        sb.append(Integer.toString(this.totalLines));
        sb.append("<br>");
        sb.append("Executed Lines: ");
        sb.append(Integer.toString(this.executedLines));
        sb.append("<br>");
        if (this.partialLines >= 0) {
            sb.append("&nbsp;&nbsp;");
            sb.append("Partial Lines: ");
            sb.append(Integer.toString(this.partialLines));
            sb.append("<br>");
        }
        if (this.inferredLines >= 0) {
            sb.append("&nbsp;&nbsp;");
            sb.append("Inferred Executed Lines: ");
            sb.append(Integer.toString(this.inferredLines));
            sb.append("<br>");
        }
        sb.append("Not Executed Lines: ");
        int notExecutedLines = this.totalLines - this.executedLines;
        sb.append(Integer.toString(notExecutedLines));
        sb.append("<br>");
        return sb.toString();
    }
}

