/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.format;

import com.vladsch.flexmark.util.format.NodeContext;
import com.vladsch.flexmark.util.html.LineFormattingAppendable;
import com.vladsch.flexmark.util.html.LineFormattingAppendableImpl;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import java.io.IOException;
import java.util.List;

public abstract class MarkdownWriterBase<M extends MarkdownWriterBase<M, N, C>, N, C extends NodeContext<N, C>>
implements LineFormattingAppendable {
    protected final LineFormattingAppendable myAppendable;
    protected C context;

    public MarkdownWriterBase() {
        this(0);
    }

    public String toString() {
        return this.myAppendable.toString();
    }

    public MarkdownWriterBase(int formatOptions) {
        this.myAppendable = new LineFormattingAppendableImpl(formatOptions);
        this.myAppendable.setOptions(this.myAppendable.getOptions() | 0x80);
    }

    public void setContext(C context) {
        this.context = context;
    }

    public C getContext() {
        return this.context;
    }

    public M tailBlankLine() {
        return this.tailBlankLine(1);
    }

    public abstract boolean isLastBlockQuoteChild();

    public abstract M tailBlankLine(int var1);

    @Override
    public boolean isPendingSpace() {
        return this.myAppendable.isPendingSpace();
    }

    @Override
    public boolean isPreFormatted() {
        return this.myAppendable.isPreFormatted();
    }

    @Override
    public boolean isPreFormattedLine(int line) {
        return this.myAppendable.isPreFormattedLine(line);
    }

    @Override
    public CharSequence getIndentPrefix() {
        return this.myAppendable.getIndentPrefix();
    }

    @Override
    public CharSequence getPrefix() {
        return this.myAppendable.getPrefix();
    }

    @Override
    public int column() {
        return this.myAppendable.column();
    }

    @Override
    public int getLineCount() {
        return this.myAppendable.getLineCount();
    }

    @Override
    public int getOptions() {
        return this.myAppendable.getOptions();
    }

    @Override
    public int getPendingEOL() {
        return this.myAppendable.getPendingEOL();
    }

    @Override
    public int getPendingSpace() {
        return this.myAppendable.getPendingSpace();
    }

    @Override
    public int offset() {
        return this.myAppendable.offset();
    }

    @Override
    public int offsetWithPending() {
        return this.myAppendable.offsetWithPending();
    }

    @Override
    public int textOnlyOffset() {
        return this.myAppendable.textOnlyOffset();
    }

    @Override
    public int textOnlyOffsetWithPending() {
        return this.myAppendable.textOnlyOffsetWithPending();
    }

    @Override
    public List<BasedSequence> getLinePrefixes(int startLine, int endLine) {
        return this.myAppendable.getLinePrefixes(startLine, endLine);
    }

    @Override
    public List<CharSequence> getLineContents(int startLine, int endLine) {
        return this.myAppendable.getLineContents(startLine, endLine);
    }

    @Override
    public List<CharSequence> getLines(int startLine, int endLine) {
        return this.myAppendable.getLines(startLine, endLine);
    }

    public M addIndentOnFirstEOL(Runnable runnable) {
        this.myAppendable.addIndentOnFirstEOL(runnable);
        return (M)this;
    }

    public M addLine() {
        this.myAppendable.addLine();
        return (M)this;
    }

    public M addPrefix(CharSequence prefix) {
        this.myAppendable.addPrefix(prefix);
        return (M)this;
    }

    public M addPrefix(CharSequence prefix, boolean afterEol) {
        this.myAppendable.addPrefix(prefix, afterEol);
        return (M)this;
    }

    public M append(char c) {
        this.myAppendable.append(c);
        return (M)this;
    }

    public M append(CharSequence csq) {
        this.myAppendable.append(csq);
        return (M)this;
    }

    public M append(CharSequence csq, int start, int end) {
        this.myAppendable.append(csq, start, end);
        return (M)this;
    }

    public M append(LineFormattingAppendable lineAppendable, int startLine, int endLine) {
        this.myAppendable.append(lineAppendable, startLine, endLine);
        return (M)this;
    }

    public M appendTo(Appendable out, int maxBlankLines, CharSequence prefix, int startLine, int endLine) throws IOException {
        this.myAppendable.appendTo(out, maxBlankLines, prefix, startLine, endLine);
        return (M)this;
    }

    public M blankLine() {
        this.myAppendable.blankLine();
        return (M)this;
    }

    public M blankLine(int count) {
        this.myAppendable.blankLine(count);
        return (M)this;
    }

    public M blankLineIf(boolean predicate) {
        this.myAppendable.blankLineIf(predicate);
        return (M)this;
    }

    public M closePreFormatted() {
        this.myAppendable.closePreFormatted();
        return (M)this;
    }

    public M indent() {
        this.myAppendable.indent();
        return (M)this;
    }

    public M line() {
        this.myAppendable.line();
        return (M)this;
    }

    public M lineIf(boolean predicate) {
        this.myAppendable.lineIf(predicate);
        return (M)this;
    }

    public M lineOnFirstText(boolean value) {
        this.myAppendable.lineOnFirstText(value);
        return (M)this;
    }

    public M lineWithTrailingSpaces(int count) {
        this.myAppendable.lineWithTrailingSpaces(count);
        return (M)this;
    }

    public M openPreFormatted(boolean keepIndent) {
        this.myAppendable.openPreFormatted(keepIndent);
        return (M)this;
    }

    public M popPrefix() {
        this.myAppendable.popPrefix();
        return (M)this;
    }

    public M popPrefix(boolean afterEol) {
        this.myAppendable.popPrefix(afterEol);
        return (M)this;
    }

    public M prefixLines(CharSequence prefix, boolean addAfterLinePrefix, int startLine, int endLine) {
        this.myAppendable.prefixLines(prefix, addAfterLinePrefix, startLine, endLine);
        return (M)this;
    }

    public M pushPrefix() {
        this.myAppendable.pushPrefix();
        return (M)this;
    }

    public M removeIndentOnFirstEOL(Runnable runnable) {
        this.myAppendable.removeIndentOnFirstEOL(runnable);
        return (M)this;
    }

    public M removeLines(int startLine, int endLine) {
        this.myAppendable.removeLines(startLine, endLine);
        return (M)this;
    }

    public M repeat(char c, int count) {
        this.myAppendable.repeat(c, count);
        return (M)this;
    }

    public M repeat(CharSequence csq, int count) {
        this.myAppendable.repeat(csq, count);
        return (M)this;
    }

    public M repeat(CharSequence csq, int start, int end, int count) {
        this.myAppendable.repeat(csq, start, end, count);
        return (M)this;
    }

    public M setIndentPrefix(CharSequence prefix) {
        this.myAppendable.setIndentPrefix(prefix);
        return (M)this;
    }

    public M setOptions(int options) {
        this.myAppendable.setOptions(options);
        return (M)this;
    }

    public M setPrefix(CharSequence prefix) {
        this.myAppendable.setPrefix(prefix);
        return (M)this;
    }

    public M setPrefix(CharSequence prefix, boolean afterEol) {
        this.myAppendable.setPrefix(prefix, afterEol);
        return (M)this;
    }

    public M unIndent() {
        this.myAppendable.unIndent();
        return (M)this;
    }

    public M unIndentNoEol() {
        this.myAppendable.unIndentNoEol();
        return (M)this;
    }

    @Override
    public String toString(int maxBlankLines) {
        return this.myAppendable.toString(maxBlankLines);
    }
}

