/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.execution;

import com.google.common.collect.ImmutableSortedMap;
import java.io.File;
import java.io.IOException;
import java.util.function.Predicate;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.execution.internal.TaskInputsListener;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.tasks.TaskExecuter;
import org.gradle.api.internal.tasks.TaskExecuterResult;
import org.gradle.api.internal.tasks.TaskExecutionContext;
import org.gradle.api.internal.tasks.TaskExecutionOutcome;
import org.gradle.api.internal.tasks.TaskStateInternal;
import org.gradle.api.internal.tasks.properties.TaskProperties;
import org.gradle.internal.Cast;
import org.gradle.internal.cleanup.BuildOutputCleanupRegistry;
import org.gradle.internal.execution.OutputChangeListener;
import org.gradle.internal.execution.history.AfterPreviousExecutionState;
import org.gradle.internal.execution.history.ExecutionHistoryStore;
import org.gradle.internal.execution.impl.OutputsCleaner;
import org.gradle.internal.fingerprint.FileCollectionFingerprint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SkipEmptySourceFilesTaskExecuter
implements TaskExecuter {
    private static final Logger LOGGER = LoggerFactory.getLogger(SkipEmptySourceFilesTaskExecuter.class);
    private final TaskInputsListener taskInputsListener;
    private final BuildOutputCleanupRegistry buildOutputCleanupRegistry;
    private final OutputChangeListener outputChangeListener;
    private final TaskExecuter executer;
    private final ExecutionHistoryStore executionHistoryStore;

    public SkipEmptySourceFilesTaskExecuter(TaskInputsListener taskInputsListener, ExecutionHistoryStore executionHistoryStore, BuildOutputCleanupRegistry buildOutputCleanupRegistry, OutputChangeListener outputChangeListener, TaskExecuter executer) {
        this.taskInputsListener = taskInputsListener;
        this.executionHistoryStore = executionHistoryStore;
        this.buildOutputCleanupRegistry = buildOutputCleanupRegistry;
        this.outputChangeListener = outputChangeListener;
        this.executer = executer;
    }

    @Override
    public TaskExecuterResult execute(TaskInternal task, TaskStateInternal state, TaskExecutionContext context) {
        TaskProperties properties = context.getTaskProperties();
        FileCollection sourceFiles = properties.getSourceFiles();
        if (properties.hasSourceFiles() && sourceFiles.isEmpty()) {
            ImmutableSortedMap outputFiles;
            AfterPreviousExecutionState previousExecution = context.getAfterPreviousExecution();
            ImmutableSortedMap immutableSortedMap = outputFiles = previousExecution == null ? ImmutableSortedMap.of() : previousExecution.getOutputFileProperties();
            if (outputFiles.isEmpty()) {
                state.setOutcome(TaskExecutionOutcome.NO_SOURCE);
                LOGGER.info("Skipping {} as it has no source files and no previous output files.", (Object)task);
            } else {
                this.outputChangeListener.beforeOutputChange();
                OutputsCleaner outputsCleaner = new OutputsCleaner((Predicate)new Predicate<File>(){

                    @Override
                    public boolean test(File file) {
                        return SkipEmptySourceFilesTaskExecuter.this.buildOutputCleanupRegistry.isOutputOwnedByBuild(file);
                    }
                }, (Predicate)new Predicate<File>(){

                    @Override
                    public boolean test(File dir) {
                        return SkipEmptySourceFilesTaskExecuter.this.buildOutputCleanupRegistry.isOutputOwnedByBuild(dir);
                    }
                });
                for (FileCollectionFingerprint outputFingerprints : outputFiles.values()) {
                    try {
                        outputsCleaner.cleanupOutputs(outputFingerprints);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException((Throwable)e);
                    }
                }
                if (outputsCleaner.getDidWork()) {
                    LOGGER.info("Cleaned previous output of {} as it has no source files.", (Object)task);
                    state.setOutcome(TaskExecutionOutcome.EXECUTED);
                } else {
                    state.setOutcome(TaskExecutionOutcome.NO_SOURCE);
                }
            }
            this.taskInputsListener.onExecute(task, (FileCollectionInternal)Cast.cast(FileCollectionInternal.class, (Object)sourceFiles));
            this.executionHistoryStore.remove(task.getPath());
            return TaskExecuterResult.WITHOUT_OUTPUTS;
        }
        this.taskInputsListener.onExecute(task, (FileCollectionInternal)Cast.cast(FileCollectionInternal.class, (Object)properties.getInputFiles()));
        return this.executer.execute(task, state, context);
    }
}

