/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.fingerprint.impl;

import java.util.List;
import org.gradle.api.NonNullApi;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.fingerprint.FileCollectionFingerprinter;
import org.gradle.internal.fingerprint.FingerprintingStrategy;
import org.gradle.internal.fingerprint.impl.DefaultCurrentFileCollectionFingerprint;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;
import org.gradle.internal.snapshot.FileSystemSnapshot;
import org.gradle.internal.snapshot.FileSystemSnapshotter;

@NonNullApi
public abstract class AbstractFileCollectionFingerprinter
implements FileCollectionFingerprinter {
    private final FileSystemSnapshotter fileSystemSnapshotter;
    private final FingerprintingStrategy fingerprintingStrategy;

    public AbstractFileCollectionFingerprinter(FingerprintingStrategy fingerprintingStrategy, FileSystemSnapshotter fileSystemSnapshotter) {
        this.fileSystemSnapshotter = fileSystemSnapshotter;
        this.fingerprintingStrategy = fingerprintingStrategy;
    }

    @Override
    public CurrentFileCollectionFingerprint fingerprint(FileCollection files) {
        FileCollectionInternal fileCollection = (FileCollectionInternal)files;
        List<FileSystemSnapshot> roots = this.fileSystemSnapshotter.snapshot(fileCollection);
        return DefaultCurrentFileCollectionFingerprint.from(roots, this.fingerprintingStrategy);
    }

    @Override
    public CurrentFileCollectionFingerprint fingerprint(Iterable<? extends FileSystemSnapshot> roots) {
        return DefaultCurrentFileCollectionFingerprint.from(roots, this.fingerprintingStrategy);
    }

    @Override
    public String normalizePath(FileSystemLocationSnapshot root) {
        return this.fingerprintingStrategy.normalizePath(root);
    }

    @Override
    public CurrentFileCollectionFingerprint empty() {
        return this.fingerprintingStrategy.getEmptyFingerprint();
    }
}

