/*
 * Decompiled with CFR 0.152.
 */
package net.htmlparser.jericho;

import net.htmlparser.jericho.Attributes;
import net.htmlparser.jericho.EndTagType;
import net.htmlparser.jericho.Source;
import net.htmlparser.jericho.StartTag;
import net.htmlparser.jericho.StartTagTypeCDATASection;
import net.htmlparser.jericho.StartTagTypeComment;
import net.htmlparser.jericho.StartTagTypeDoctypeDeclaration;
import net.htmlparser.jericho.StartTagTypeMarkupDeclaration;
import net.htmlparser.jericho.StartTagTypeNormal;
import net.htmlparser.jericho.StartTagTypeServerCommon;
import net.htmlparser.jericho.StartTagTypeServerCommonComment;
import net.htmlparser.jericho.StartTagTypeServerCommonEscaped;
import net.htmlparser.jericho.StartTagTypeUnregistered;
import net.htmlparser.jericho.StartTagTypeXMLDeclaration;
import net.htmlparser.jericho.StartTagTypeXMLProcessingInstruction;
import net.htmlparser.jericho.TagType;

public abstract class StartTagType
extends TagType {
    private final EndTagType correspondingEndTagType;
    private final boolean hasAttributes;
    private final boolean isNameAfterPrefixRequired;
    static final String START_DELIMITER_PREFIX = "<";
    public static final StartTagType UNREGISTERED = StartTagTypeUnregistered.INSTANCE;
    public static final StartTagType NORMAL = StartTagTypeNormal.INSTANCE;
    public static final StartTagType COMMENT = StartTagTypeComment.INSTANCE;
    public static final StartTagType XML_DECLARATION = StartTagTypeXMLDeclaration.INSTANCE;
    public static final StartTagType XML_PROCESSING_INSTRUCTION = StartTagTypeXMLProcessingInstruction.INSTANCE;
    public static final StartTagType DOCTYPE_DECLARATION = StartTagTypeDoctypeDeclaration.INSTANCE;
    public static final StartTagType MARKUP_DECLARATION = StartTagTypeMarkupDeclaration.INSTANCE;
    public static final StartTagType CDATA_SECTION = StartTagTypeCDATASection.INSTANCE;
    public static final StartTagType SERVER_COMMON = StartTagTypeServerCommon.INSTANCE;
    public static final StartTagType SERVER_COMMON_ESCAPED = StartTagTypeServerCommonEscaped.INSTANCE;
    public static final StartTagType SERVER_COMMON_COMMENT = StartTagTypeServerCommonComment.INSTANCE;

    protected StartTagType(String description, String startDelimiter, String closingDelimiter, EndTagType correspondingEndTagType, boolean isServerTag, boolean hasAttributes, boolean isNameAfterPrefixRequired) {
        super(description, startDelimiter.toLowerCase(), closingDelimiter, isServerTag, START_DELIMITER_PREFIX);
        if (!this.getStartDelimiter().startsWith(START_DELIMITER_PREFIX)) {
            throw new IllegalArgumentException("startDelimiter of a start tag must start with \"<\"");
        }
        this.correspondingEndTagType = correspondingEndTagType;
        this.hasAttributes = hasAttributes;
        this.isNameAfterPrefixRequired = isNameAfterPrefixRequired;
    }

    public final EndTagType getCorrespondingEndTagType() {
        return this.correspondingEndTagType;
    }

    public final boolean hasAttributes() {
        return this.hasAttributes;
    }

    public final boolean isNameAfterPrefixRequired() {
        return this.isNameAfterPrefixRequired;
    }

    public boolean atEndOfAttributes(Source source, int pos, boolean isClosingSlashIgnored) {
        return source.getParseText().containsAt(this.getClosingDelimiter(), pos);
    }

    protected final StartTag constructStartTag(Source source, int begin, int end, String name, Attributes attributes) {
        return new StartTag(source, begin, end, this, name, attributes);
    }

    protected final Attributes parseAttributes(Source source, int startTagBegin, String tagName) {
        return Attributes.construct(source, startTagBegin, this, tagName);
    }
}

